/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.WithMerge;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithAnnotations;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.TreeMap;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.util.NNF;

public abstract class ONTAxiomImpl<X extends OWLAxiom>
extends ONTStatementImpl
implements WithAnnotations,
WithMerge<ONTObject<X>>,
HasConfig,
ModelObject<X>,
OWLAxiom {
    protected static final ObjIntConsumer<OWLAxiom> SET_HASH_CODE = (a, h) -> ((ONTAxiomImpl)a).setHashCode(h);

    protected ONTAxiomImpl(Triple t, Supplier<OntModel> m) {
        this(ONTAxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), ONTAxiomImpl.strip(t.getObject()), m);
    }

    protected ONTAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
        super(subject, predicate, object, m);
    }

    public static Collection<ONTObject<OWLAnnotation>> collectAnnotations(OntStatement axiom, InternalObjectFactory factory, InternalConfig config) {
        TreeMap res = new TreeMap();
        ReadHelper.listAnnotations(axiom, config, factory).forEachRemaining(x -> WithMerge.add(res, x));
        return res.values();
    }

    @Override
    public ONTObject<X> merge(ONTObject<X> other) {
        throw new OntApiException.Unsupported("Attempt to merge " + this + " with " + other);
    }

    protected void setHashCode(int hash) {
        this.hashCode = hash;
    }

    public final boolean hasURISubject() {
        return this.subject instanceof String;
    }

    public final boolean hasURIObject() {
        return this.object instanceof String;
    }

    public final String getSubjectURI() throws ClassCastException {
        return (String)this.subject;
    }

    public final BlankNodeId getSubjectBlankNodeId() throws ClassCastException {
        return (BlankNodeId)this.subject;
    }

    public final String getObjectURI() throws ClassCastException {
        return (String)this.object;
    }

    protected boolean hasURIResource(Resource uri) {
        return this.hasURIResource(uri.getURI());
    }

    protected boolean hasURIResource(String uri) {
        return this.subject.equals(uri) || this.object.equals(uri);
    }

    @Override
    public X getOWLObject() {
        return (X)this;
    }

    @Override
    public X eraseModel() {
        return this.createAnnotatedAxiom(this.factoryAnnotations().collect(Collectors.toList()));
    }

    @Override
    public InternalConfig getConfig() {
        return HasConfig.getConfig(this.getModel());
    }

    @Override
    public Stream<Triple> triples() {
        return Stream.concat(super.triples(), this.objects().flatMap(ONTObject::triples));
    }

    public final X getAxiomWithoutAnnotations() {
        return this.createAnnotatedAxiom(ONTAxiomImpl.createSet());
    }

    public final <T extends OWLAxiom> T getAnnotatedAxiom(@Nonnull Stream<OWLAnnotation> annotations) {
        return (T)this.createAnnotatedAxiom(this.appendAnnotations(annotations.iterator()));
    }

    protected abstract X createAnnotatedAxiom(Collection<OWLAnnotation> var1);

    public OWLAxiom getNNF() {
        return (OWLAxiom)this.eraseModel().accept((OWLAxiomVisitorEx)new NNF((OWLDataFactory)this.getDataFactory()));
    }
}

