/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.owlapi.axioms.SWRLRuleImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLVariable;

public class SWRLRuleTranslator
extends AxiomTranslator<SWRLRule> {
    @Override
    public void write(SWRLRule axiom, OntModel model) {
        Stream<OntSWRL.Atom> head = axiom.head().map(atom -> WriteHelper.addSWRLAtom(model, atom));
        Stream<OntSWRL.Atom> body = axiom.body().map(atom -> WriteHelper.addSWRLAtom(model, atom));
        WriteHelper.addAnnotations(model.createSWRLImp(head.collect(Collectors.toList()), body.collect(Collectors.toList())), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalObjects(model, OntSWRL.Imp.class).mapWith(OntObject::getMainStatement);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getSubject().canAs(OntSWRL.Imp.class);
    }

    @Override
    public ONTObject<SWRLRule> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<SWRLRule> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        OntSWRL.Imp imp = statement.getSubject(OntSWRL.Imp.class);
        Collection head = imp.head().map(factory::getSWRLAtom).collect(Collectors.toList());
        Collection body = imp.body().map(factory::getSWRLAtom).collect(Collectors.toList());
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        SWRLRule res = factory.getOWLDataFactory().getSWRLRule(body.stream().map(ONTObject::getOWLObject).collect(Collectors.toList()), head.stream().map(ONTObject::getOWLObject).collect(Collectors.toList()), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, imp).append(annotations).append(body).append(head);
    }

    public static class AxiomImpl
    extends ONTAxiomImpl<SWRLRule>
    implements WithContent<AxiomImpl>,
    SWRLRule {
        protected final InternalCache.Loading<AxiomImpl, Object[]> content = this.createContentCache();

        public AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return new AxiomImpl(statement.asTriple(), model);
        }

        private static Collection<ONTObject<? extends SWRLAtom>> collectAtoms(OntList<OntSWRL.Atom> list, InternalObjectFactory factory) {
            return Iter.addAll(OntModels.listMembers(list).mapWith(factory::getSWRLAtom), new ArrayList());
        }

        private static <X extends OWLObject> Stream<X> content(Class<X> type, Object[] content, int index) {
            Object[] arr = (Object[])content[index];
            return Arrays.stream(arr).map(x -> type.isInstance(x) ? (OWLObject)x : ((ONTObject)x).getOWLObject());
        }

        private static <X extends OWLObject> List<X> getContentAsList(Class<X> type, Object[] content, int index) {
            Object[] arr = (Object[])content[index];
            if (arr.length == 0) {
                return Collections.emptyList();
            }
            if (type.isInstance(arr[0])) {
                List<Object> res = Arrays.asList(arr);
                return Collections.unmodifiableList(res);
            }
            return Arrays.stream(arr).map(x -> ((ONTObject)x).getOWLObject()).collect(Collectors.toList());
        }

        @Override
        public InternalCache.Loading<AxiomImpl, Object[]> getContentCache() {
            return this.content;
        }

        public OntSWRL.Imp asResource() {
            return this.getPersonalityModel().getNodeAs(this.getSubjectNode(), OntSWRL.Imp.class);
        }

        @Override
        public OntStatement asStatement() {
            return this.asResource().getMainStatement();
        }

        @Override
        public Object[] collectContent() {
            Object[] res;
            OntSWRL.Imp imp = this.asResource();
            InternalObjectFactory factory = this.getObjectFactory();
            Collection<ONTObject<OWLAnnotation>> annotations = AxiomImpl.collectAnnotations(imp.getMainStatement(), factory, this.getConfig());
            if (annotations.isEmpty()) {
                res = new Object[2];
            } else {
                res = new Object[3];
                res[2] = annotations.toArray();
            }
            res[0] = AxiomImpl.collectAtoms(imp.getHeadList(), factory).toArray();
            res[1] = AxiomImpl.collectAtoms(imp.getBodyList(), factory).toArray();
            return res;
        }

        @Override
        public Stream<Triple> triples() {
            return Stream.concat(this.asResource().spec().map(FrontsTriple::asTriple), this.objects().flatMap(ONTObject::triples));
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            Stream<ONTObject<? extends OWLObject>> res = Arrays.stream(this.getContent()).flatMap(x -> Arrays.stream((Object[])x));
            return res;
        }

        public Stream<SWRLAtom> body() {
            return AxiomImpl.content(SWRLAtom.class, this.getContent(), 1).distinct();
        }

        public Stream<SWRLAtom> head() {
            return AxiomImpl.content(SWRLAtom.class, this.getContent(), 0).distinct();
        }

        public Stream<SWRLVariable> variables() {
            return SWRLRuleImpl.variables(this);
        }

        public boolean containsAnonymousClassExpressions() {
            return this.classAtomPredicates().anyMatch(IsAnonymous::isAnonymous);
        }

        public Stream<OWLClassExpression> classAtomPredicates() {
            return SWRLRuleImpl.classAtomPredicates(this);
        }

        @Override
        public boolean isAnnotated() {
            return this.getContent().length == 3;
        }

        @Override
        public Stream<OWLAnnotation> annotations() {
            Object[] content = this.getContent();
            if (content.length == 3) {
                return AxiomImpl.content(OWLAnnotation.class, content, 2);
            }
            return Stream.empty();
        }

        @Override
        public List<OWLAnnotation> annotationsAsList() {
            Object[] content = this.getContent();
            if (content.length != 3) {
                return Collections.emptyList();
            }
            return AxiomImpl.getContentAsList(OWLAnnotation.class, content, 2);
        }

        @Override
        public boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        public SWRLRule getSimplified() {
            return ((SWRLRule)this.eraseModel()).getSimplified();
        }

        @Override
        protected SWRLRule createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getSWRLRule(this.body().map(ONTObjectImpl::eraseModel).collect(Collectors.toList()), this.head().map(ONTObjectImpl::eraseModel).collect(Collectors.toList()), annotations);
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return other instanceof AxiomImpl && Arrays.deepEquals(this.getContent(), ((AxiomImpl)other).getContent());
        }

        @Override
        protected boolean sameComponents(HasComponents other) {
            SWRLRule rule = (SWRLRule)other;
            return this.sameAnnotations((OWLAxiom)rule) && AxiomImpl.equalStreams(this.body(), rule.body()) && AxiomImpl.equalStreams(this.head(), rule.head());
        }

        private boolean sameAnnotations(OWLAxiom other) {
            if (this.isAnnotated()) {
                return other.isAnnotated() && this.annotationsAsList().equals(other.annotationsAsList());
            }
            return !other.isAnnotated();
        }

        @Override
        public ONTObject<SWRLRule> merge(final ONTObject<SWRLRule> other) {
            if (this == other) {
                return this;
            }
            if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                return this;
            }
            AxiomImpl res = new AxiomImpl(this.asTriple(), this.model){

                @Override
                public Stream<Triple> triples() {
                    return Stream.concat(this.triples(), other.triples());
                }
            };
            if (this.hasContent()) {
                res.putContent(this.getContent());
            }
            res.hashCode = this.hashCode;
            return res;
        }
    }
}

