/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.AbstractNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.AbstractTwoWayNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class DifferentIndividualsTranslator
extends AbstractTwoWayNaryTranslator<OWLDifferentIndividualsAxiom, OWLIndividual, OntIndividual> {
    private static final Property PREDICATE = OWL.differentFrom;

    @Override
    Property getPredicate() {
        return PREDICATE;
    }

    @Override
    Class<OntIndividual> getView() {
        return OntIndividual.class;
    }

    @Override
    Resource getMembersType() {
        return OWL.AllDifferent;
    }

    @Override
    Property getMembersPredicate() {
        return OWL.distinctMembers;
    }

    @Override
    Class<OntDisjoint.Individuals> getDisjointView() {
        return OntDisjoint.Individuals.class;
    }

    @Override
    public ONTObject<OWLDifferentIndividualsAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLDifferentIndividualsAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        return this.makeAxiom(statement, factory.getAnnotations(statement, config), factory::getIndividual, (members, annotations) -> factory.getOWLDataFactory().getOWLDifferentIndividualsAxiom(ONTObject.toSet(members), ONTObject.toSet(annotations)));
    }

    public static abstract class AxiomImpl
    extends AbstractNaryTranslator.IndividualNaryAxiomImpl<OWLDifferentIndividualsAxiom>
    implements OWLDifferentIndividualsAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            this(AxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), AxiomImpl.strip(t.getObject()), m);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            if (PREDICATE.equals(statement.getPredicate())) {
                return (AxiomImpl)WithManyObjects.create(statement, model, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
            }
            return (AxiomImpl)WithManyObjects.create(statement, model, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLIndividual>> listONTComponents(OntStatement statement, InternalObjectFactory factory) {
            if (PREDICATE.equals(statement.getPredicate())) {
                return super.listONTComponents(statement, factory);
            }
            return OntModels.listMembers(statement.getSubject(OntDisjoint.Individuals.class).getList()).mapWith(factory::getIndividual);
        }

        @Override
        protected OWLDifferentIndividualsAxiom createAxiom(Collection<OWLIndividual> members, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLDifferentIndividualsAxiom(members, annotations == null ? NO_ANNOTATIONS : annotations);
        }

        @Override
        protected OWLSubClassOfAxiom createSubClassOf(OWLIndividual a, OWLIndividual b) {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{a}), df.getOWLObjectOneOf(new OWLIndividual[]{b}).getObjectComplementOf());
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithManyObjects.Complex<ComplexImpl, OWLIndividual> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            protected long count() {
                return this.isSimple() ? 2L : this.members().count();
            }

            boolean isSimple() {
                return this.predicate.equals(PREDICATE.getURI());
            }

            public boolean containsAnonymousIndividuals() {
                if (this.isSimple()) {
                    return this.subject instanceof BlankNodeId || this.object instanceof BlankNodeId;
                }
                return this.individuals().anyMatch(IsAnonymous::isAnonymous);
            }

            protected OntDisjoint.Individuals asResource() {
                return this.getPersonalityModel().getNodeAs(this.getSubjectNode(), OntDisjoint.Individuals.class);
            }

            @Override
            public Stream<Triple> triples() {
                if (this.isSimple()) {
                    return super.triples();
                }
                return Stream.concat(this.asResource().spec().map(FrontsTriple::asTriple), this.objects().flatMap(ONTObject::triples));
            }

            @Override
            public OntStatement asStatement() {
                if (this.isSimple()) {
                    return super.asStatement();
                }
                return this.asResource().getMainStatement();
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return this.testSameContent(other);
            }

            protected ComplexImpl makeCopyWith(final ONTObject<OWLDifferentIndividualsAxiom> other) {
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                return res;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithManyObjects.Simple<OWLIndividual> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            protected SimpleImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            protected long count() {
                return 2L;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof SimpleImpl && this.isReverseTriple((SimpleImpl)other);
            }

            protected AxiomImpl makeCopyWith(final ONTObject<OWLDifferentIndividualsAxiom> other) {
                if (other instanceof SimpleImpl) {
                    final Triple t = ((SimpleImpl)other).asTriple();
                    return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                        @Override
                        public Stream<Triple> triples() {
                            return Stream.concat(this.triples(), Stream.of(t));
                        }
                    };
                }
                return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
            }

            @Override
            public Set<OWLNamedIndividual> getNamedIndividualSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsNamedIndividual(OWLNamedIndividual individual) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)individual));
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }

            public boolean containsAnonymousIndividuals() {
                return false;
            }
        }
    }
}

