/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Entities;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class DeclarationTranslator
extends AxiomTranslator<OWLDeclarationAxiom> {
    @Override
    public void write(OWLDeclarationAxiom axiom, OntModel model) {
        WriteHelper.writeDeclarationTriple(model, axiom.getEntity(), RDF.type, (RDFNode)WriteHelper.getRDFType(axiom.getEntity()), axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        if (!config.isAllowReadDeclarations()) {
            return NullIterator.instance();
        }
        return OntModels.listLocalEntities(model).mapWith(OntObject::getMainStatement).filterDrop(Objects::isNull);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        if (!statement.getSubject().isURIResource()) {
            return false;
        }
        if (!statement.getObject().isURIResource()) {
            return false;
        }
        if (!statement.isDeclaration()) {
            return false;
        }
        return Entities.find(statement.getResource()).map(Entities::getActualType).map(t -> statement.getModel().getOntEntity(t, statement.getSubject())).isPresent();
    }

    @Override
    public ONTObject<OWLDeclarationAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLDeclarationAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        OntEntity e = Entities.find(statement.getResource()).map(Entities::getActualType).map(t -> statement.getModel().getOntEntity(t, statement.getSubject())).orElseThrow(() -> new OntJenaException.IllegalArgument("Can't find entity by the statement " + statement));
        ONTObject<? extends OWLEntity> entity = factory.getEntity(e);
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLDeclarationAxiom res = factory.getOWLDataFactory().getOWLDeclarationAxiom(entity.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations);
    }

    public static abstract class AxiomImpl
    extends ONTAxiomImpl<OWLDeclarationAxiom>
    implements OWLDeclarationAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            if (annotations.isEmpty()) {
                SimpleImpl res = new SimpleImpl(statement.asTriple(), model);
                int hash = OWLObject.hashIteration((int)res.hashIndex(), (int)res.findONTEntity(factory).hashCode());
                res.hashCode = OWLObject.hashIteration((int)hash, (int)1);
                return res;
            }
            WithAnnotationsImpl res = new WithAnnotationsImpl(statement.asTriple(), model);
            int hash = OWLObject.hashIteration((int)res.hashIndex(), (int)res.findONTEntity(factory).hashCode());
            if (annotations.isEmpty()) {
                res.hashCode = OWLObject.hashIteration((int)hash, (int)1);
                return res;
            }
            int h = 1;
            int index = 0;
            Object[] content = new Object[annotations.size()];
            for (ONTObject<OWLAnnotation> a : annotations) {
                content[index++] = a;
                h = WithContent.hashIteration(h, a.hashCode());
            }
            res.hashCode = OWLObject.hashIteration((int)hash, (int)h);
            res.putContent(content);
            return res;
        }

        @Override
        public OntStatement asStatement() {
            return OntApiException.mustNotBeNull(this.getResource().getMainStatement());
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.getONTEntity());
        }

        public OWLEntity getEntity() {
            return this.getONTEntity().getOWLObject();
        }

        public ONTObject<? extends OWLEntity> getONTEntity() {
            return this.findONTEntity(this.getObjectFactory());
        }

        protected ONTObject<? extends OWLEntity> findONTEntity(InternalObjectFactory factory) {
            if (factory instanceof ModelObjectFactory) {
                return ((ModelObjectFactory)factory).getEntity((String)this.subject, this.getResourceType());
            }
            return factory.getEntity(this.getResource());
        }

        public OntEntity getResource() {
            Node s = this.getSubjectNode();
            Class<? extends OntEntity> t = this.getResourceType().getActualType();
            return OntApiException.mustNotBeNull(this.getPersonalityModel().findNodeAs(s, t), "Can't find entity " + this.subject);
        }

        public Entities getResourceType() {
            Node type = this.getObjectNode();
            return Entities.find(type).orElseThrow(() -> new OntApiException.IllegalState("Can't find type for " + this.subject));
        }

        @Override
        protected OWLDeclarationAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLDeclarationAxiom(AxiomImpl.eraseModel(this.getEntity()), annotations);
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return false;
        }

        @Override
        public Set<OWLClass> getNamedClassSet() {
            OWLEntity res = this.getEntity();
            return res.isOWLClass() ? AxiomImpl.createSet(res.asOWLClass()) : AxiomImpl.createSet();
        }

        @Override
        public Set<OWLClassExpression> getClassExpressionSet() {
            OWLEntity res = this.getEntity();
            return res.isOWLClass() ? AxiomImpl.createSet(res.asOWLClass()) : AxiomImpl.createSet();
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            OWLEntity res = this.getEntity();
            return res.isOWLNamedIndividual() ? AxiomImpl.createSet(res.asOWLNamedIndividual()) : AxiomImpl.createSet();
        }

        @Override
        public Set<OWLDataProperty> getDataPropertySet() {
            OWLEntity res = this.getEntity();
            return res.isOWLDataProperty() ? AxiomImpl.createSet(res.asOWLDataProperty()) : AxiomImpl.createSet();
        }

        @Override
        public Set<OWLObjectProperty> getObjectPropertySet() {
            OWLEntity res = this.getEntity();
            return res.isOWLObjectProperty() ? AxiomImpl.createSet(res.asOWLObjectProperty()) : AxiomImpl.createSet();
        }

        public static class WithAnnotationsImpl
        extends AxiomImpl
        implements WithContent<WithAnnotationsImpl> {
            protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

            public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Object[] collectContent() {
                return WithAnnotationsImpl.collectAnnotations(this.asStatement(), this.getObjectFactory(), this.getConfig()).toArray();
            }

            @Override
            public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            public boolean isAnnotated() {
                return true;
            }

            @Override
            public Stream<OWLAnnotation> annotations() {
                return ONTAnnotationImpl.contentAsStream(this.getContent());
            }

            @Override
            public List<OWLAnnotation> annotationsAsList() {
                return ONTAnnotationImpl.contentAsList(this.getContent());
            }

            @Override
            public Stream<ONTObject<? extends OWLObject>> objects() {
                Stream<OWLAnnotation> res = Stream.concat(super.objects(), this.annotations());
                return res;
            }

            @Override
            public boolean containsEntity(OWLEntity entity) {
                if (entity.isOWLAnnotationProperty() || entity.isOWLDatatype()) {
                    return super.containsEntity(entity);
                }
                return this.getEntity().equals(entity);
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithoutAnnotations {
            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public boolean containsEntity(OWLEntity entity) {
                return this.getEntity().equals(entity);
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return SimpleImpl.createSet(this.getEntity());
            }

            @Override
            public Set<OWLDatatype> getDatatypeSet() {
                OWLEntity res = this.getEntity();
                return res.isOWLDatatype() ? SimpleImpl.createSet(res.asOWLDatatype()) : SimpleImpl.createSet();
            }

            @Override
            public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
                OWLEntity res = this.getEntity();
                return res.isOWLAnnotationProperty() ? SimpleImpl.createSet(res.asOWLAnnotationProperty()) : SimpleImpl.createSet();
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }

            @Override
            public boolean isAnnotated() {
                return false;
            }
        }
    }
}

