/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTDatatypeImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class DatatypeDefinitionTranslator
extends AxiomTranslator<OWLDatatypeDefinitionAxiom> {
    @Override
    public void write(OWLDatatypeDefinitionAxiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, (OWLObject)axiom.getDatatype(), OWL.equivalentClass, (OWLObject)axiom.getDataRange(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalStatements(model, null, OWL.equivalentClass, null).filterKeep(s -> s.getSubject().canAs(OntDataRange.Named.class) && s.getObject().canAs(OntDataRange.class));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getPredicate().equals(OWL.equivalentClass) && statement.getSubject().canAs(OntDataRange.Named.class) && statement.getObject().canAs(OntDataRange.class);
    }

    @Override
    public ONTObject<OWLDatatypeDefinitionAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLDatatypeDefinitionAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<OWLDatatype> dt = factory.getDatatype(statement.getSubject(OntDataRange.Named.class));
        ONTObject<? extends OWLDataRange> dr = factory.getDatatype(statement.getObject(OntDataRange.class));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLDatatypeDefinitionAxiom res = factory.getOWLDataFactory().getOWLDatatypeDefinitionAxiom(dt.getOWLObject(), dr.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(dt).append(dr);
    }

    public static abstract class AxiomImpl
    extends ONTAxiomImpl<OWLDatatypeDefinitionAxiom>
    implements WithTwoObjects<OWLDatatype, OWLDataRange>,
    OWLDatatypeDefinitionAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected AxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return (AxiomImpl)WithTwoObjects.create(statement, model, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        public OWLDatatype getDatatype() {
            return (OWLDatatype)this.getONTSubject().getOWLObject();
        }

        public OWLDataRange getDataRange() {
            return (OWLDataRange)this.getONTObject().getOWLObject();
        }

        @Override
        public ONTObject<? extends OWLDatatype> getURISubject(InternalObjectFactory factory) {
            return ONTDatatypeImpl.find(this.getSubjectURI(), factory, this.model);
        }

        @Override
        public ONTObject<? extends OWLDatatype> subjectFromStatement(OntStatement statement, InternalObjectFactory factory) {
            return factory.getDatatype(statement.getSubject(OntDataRange.Named.class));
        }

        @Override
        public ONTObject<? extends OWLDataRange> getURIObject(InternalObjectFactory factory) {
            return ONTDatatypeImpl.find(this.getObjectURI(), factory, this.model);
        }

        @Override
        public ONTObject<? extends OWLDataRange> objectFromStatement(OntStatement statement, InternalObjectFactory factory) {
            return factory.getDatatype(statement.getObject(OntDataRange.class));
        }

        @Override
        protected OWLDatatypeDefinitionAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLDatatypeDefinitionAxiom(AxiomImpl.eraseModel(this.getDatatype()), AxiomImpl.eraseModel(this.getDataRange()), annotations);
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public final boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public final boolean canContainDataProperties() {
            return false;
        }

        @Override
        public final boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithTwoObjects.Complex<ComplexImpl, OWLDatatype, OWLDataRange> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameAs(ONTStatementImpl other) {
                if (this.notSame(other)) {
                    return false;
                }
                if (!this.sameSubject(other)) {
                    return false;
                }
                return this.sameContent(other);
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            @Override
            public ONTObject<OWLDatatypeDefinitionAxiom> merge(final ONTObject<OWLDatatypeDefinitionAxiom> other) {
                if (this == other) {
                    return this;
                }
                if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                    return this;
                }
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                res.hashCode = this.hashCode;
                return res;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithTwoObjects.Simple<OWLDatatype, OWLDataRange> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLDatatype> getDatatypeSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsDatatype(OWLDatatype datatype) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)datatype));
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return false;
            }
        }
    }
}

