/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithAssertion;
import com.github.owlcs.ontapi.internal.objects.ONTDataPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTLiteralImpl;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class DataPropertyAssertionTranslator
extends AbstractPropertyAssertionTranslator<OWLDataPropertyExpression, OWLDataPropertyAssertionAxiom> {
    @Override
    public void write(OWLDataPropertyAssertionAxiom axiom, OntModel model) {
        WriteHelper.writeAssertionTriple(model, (OWLObject)axiom.getSubject(), axiom.getProperty(), (OWLObject)axiom.getObject(), axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return this.listStatements(model).filterKeep(s -> this.testStatement((OntStatement)s, config));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getObject().isLiteral() && statement.getPredicate().canAs(OntDataProperty.class) && statement.getSubject().canAs(OntIndividual.class);
    }

    @Override
    public ONTObject<OWLDataPropertyAssertionAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLDataPropertyAssertionAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<? extends OWLIndividual> i = factory.getIndividual(statement.getSubject(OntIndividual.class));
        ONTObject<OWLDataProperty> p = factory.getProperty((OntDataProperty)statement.getPredicate().as(OntDataProperty.class));
        ONTObject<OWLLiteral> literal = factory.getLiteral(statement.getLiteral());
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLDataPropertyAssertionAxiom res = factory.getOWLDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p.getOWLObject(), i.getOWLObject(), literal.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(i).append(p).append(literal);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyAssertionTranslator.AssertionImpl<OWLDataPropertyAssertionAxiom, OWLIndividual, OWLDataPropertyExpression, OWLLiteral>
    implements OWLDataPropertyAssertionAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return (AxiomImpl)WithAssertion.create(statement, model, SimpleImpl.FACTORY, WithAnnotationsImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        public ONTObject<? extends OWLIndividual> findONTSubject(InternalObjectFactory factory) {
            return this.findByURIOrBlankId(this.subject, factory);
        }

        @Override
        public ONTObject<? extends OWLLiteral> findONTObject(InternalObjectFactory factory) {
            return ONTLiteralImpl.find((LiteralLabel)this.object, factory, this.model);
        }

        @Override
        public ONTObject<? extends OWLDataProperty> findONTPredicate(InternalObjectFactory factory) {
            return this.findONTProperty(factory);
        }

        public ONTObject<OWLDataProperty> findONTProperty(InternalObjectFactory factory) {
            return ONTDataPropertyImpl.find(this.predicate, factory, this.model);
        }

        @Override
        protected OWLDataPropertyAssertionAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.getFPredicate(), (OWLIndividual)this.getFSubject(), (OWLLiteral)this.getFObject(), annotations);
        }

        public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)this.getFSubject()}), (OWLClassExpression)df.getOWLDataHasValue((OWLDataPropertyExpression)this.getFPredicate(), (OWLLiteral)this.getFObject()));
        }

        @Override
        public boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public Set<OWLDataProperty> getDataPropertySet() {
            return AxiomImpl.createSet(((OWLDataPropertyExpression)this.getProperty()).asOWLDataProperty());
        }

        @Override
        public boolean containsDataProperty(OWLDataProperty property) {
            return this.predicate.equals(ONTEntityImpl.getURI((OWLEntity)property));
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            return this.hasURISubject() ? AxiomImpl.createSet(((OWLIndividual)this.getSubject()).asOWLNamedIndividual()) : AxiomImpl.createSet();
        }

        public static class WithAnnotationsImpl
        extends AxiomImpl
        implements WithAssertion.WithAnnotations<WithAnnotationsImpl, OWLIndividual, OWLDataPropertyExpression, OWLLiteral> {
            private static final BiFunction<Triple, Supplier<OntModel>, WithAnnotationsImpl> FACTORY = WithAnnotationsImpl::new;
            protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

            public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
                return this.content;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithAssertion.Simple<OWLIndividual, OWLDataPropertyExpression, OWLLiteral> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
                return this.hasURISubject() ? SimpleImpl.createSet() : SimpleImpl.createSet(((OWLIndividual)this.getSubject()).asOWLAnonymousIndividual());
            }

            @Override
            public Set<OWLDatatype> getDatatypeSet() {
                return SimpleImpl.createSet(((OWLLiteral)this.getONTObject().getOWLObject()).getDatatype());
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                Set<OWLEntity> res = SimpleImpl.createSortedSet();
                InternalObjectFactory factory = this.getObjectFactory();
                res.add((OWLEntity)this.findONTProperty(factory).getOWLObject());
                if (this.hasURISubject()) {
                    res.add((OWLEntity)this.findONTSubject(factory).getOWLObject().asOWLNamedIndividual());
                }
                res.add((OWLEntity)this.findONTObject(factory).getOWLObject().getDatatype());
                return res;
            }

            @Override
            public boolean containsNamedIndividual(OWLNamedIndividual individual) {
                return ((OWLIndividual)this.getSubject()).equals(individual);
            }
        }
    }
}

