/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractSubPropertyTranslator<Axiom extends OWLAxiom, P extends OntProperty>
extends AxiomTranslator<Axiom> {
    abstract OWLPropertyExpression getSubProperty(Axiom var1);

    abstract OWLPropertyExpression getSuperProperty(Axiom var1);

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalStatements(model, null, RDFS.subPropertyOf, null).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, InternalConfig config) {
        return statement.getSubject().canAs(this.getView()) && statement.getObject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return RDFS.subPropertyOf.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, (OWLObject)this.getSubProperty(axiom), RDFS.subPropertyOf, (OWLObject)this.getSuperProperty(axiom), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    public static abstract class SubPropertyAxiomImpl<A extends OWLAxiom, P extends OWLPropertyExpression>
    extends ONTAxiomImpl<A>
    implements WithTwoObjects.Unary<P> {
        protected SubPropertyAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected SubPropertyAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public P getSubProperty() {
            return (P)((OWLPropertyExpression)this.getONTSubject().getOWLObject());
        }

        public P getSuperProperty() {
            return (P)((OWLPropertyExpression)this.getONTObject().getOWLObject());
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return false;
        }

        @Override
        public final boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }
    }
}

