/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTClassImpl;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.HasDomain;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractPropertyDomainTranslator<Axiom extends OWLAxiom & HasDomain<?>, P extends OntProperty>
extends AxiomTranslator<Axiom> {
    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, ((HasProperty)axiom).getProperty(), RDFS.domain, ((HasDomain)axiom).getDomain(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalStatements(model, null, RDFS.domain, null).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, InternalConfig config) {
        return statement.getSubject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return RDFS.domain.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    protected static abstract class ClassDomainAxiomImpl<A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression>
    extends DomainAxiomImpl<A, P, OWLClassExpression> {
        protected ClassDomainAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected ClassDomainAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        public ONTObject<? extends OWLClassExpression> getURIObject(InternalObjectFactory factory) {
            return ONTClassImpl.find(this.getObjectURI(), factory, this.model);
        }

        @Override
        public ONTObject<? extends OWLClassExpression> objectFromStatement(OntStatement statement, InternalObjectFactory factory) {
            return factory.getClass(statement.getObject(OntClass.class));
        }
    }

    protected static abstract class DomainAxiomImpl<A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression, D extends OWLObject>
    extends ONTAxiomImpl<A>
    implements WithTwoObjects<P, D> {
        protected DomainAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected DomainAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public P getProperty() {
            return (P)((OWLPropertyExpression)this.getONTSubject().getOWLObject());
        }

        public D getDomain() {
            return (D)this.getONTObject().getOWLObject();
        }
    }
}

