/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.WithAssertion;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTNamedIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntNegativeAssertion;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractNegativePropertyAssertionTranslator<Axiom extends OWLPropertyAssertionAxiom<?, ?>, NPA extends OntNegativeAssertion<?, ?>>
extends AxiomTranslator<Axiom> {
    abstract NPA createNPA(Axiom var1, OntModel var2);

    abstract Class<NPA> getView();

    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.addAnnotations(this.createNPA(axiom, model), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalStatements(model, null, RDF.type, (RDFNode)OWL.NegativePropertyAssertion).mapWith(s -> {
            OntNegativeAssertion res = (OntNegativeAssertion)s.getSubject().getAs(this.getView());
            return res != null ? res.getMainStatement() : null;
        }).filterDrop(Objects::isNull);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getObject().equals(OWL.NegativePropertyAssertion) && statement.isDeclaration() && statement.getSubject().canAs(this.getView());
    }

    protected static abstract class NegativeAssertionImpl<R extends OntNegativeAssertion<?, ?>, A extends OWLPropertyAssertionAxiom<?, ?>, P extends OWLPropertyExpression, O extends OWLObject>
    extends ONTAxiomImpl<A>
    implements WithAssertion.Complex<NegativeAssertionImpl<?, ?, ?, ?>, OWLIndividual, P, O> {
        protected final InternalCache.Loading<NegativeAssertionImpl<?, ?, ?, ?>, Object[]> content = this.createContentCache();

        protected NegativeAssertionImpl(Triple t, Supplier<OntModel> m) {
            this(NegativeAssertionImpl.strip(t.getSubject()), t.getPredicate().getURI(), NegativeAssertionImpl.strip(t.getObject()), m);
        }

        protected NegativeAssertionImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        @Override
        public InternalCache.Loading<NegativeAssertionImpl<?, ?, ?, ?>, Object[]> getContentCache() {
            return this.content;
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return other instanceof NegativeAssertionImpl && Arrays.equals(this.getContent(), ((NegativeAssertionImpl)other).getContent());
        }

        protected abstract Class<R> getType();

        @Override
        public OntStatement asStatement() {
            return this.asResource().getMainStatement();
        }

        public final R asResource() {
            return (R)((OntNegativeAssertion)this.getPersonalityModel().getNodeAs(this.getSubjectNode(), this.getType()));
        }

        protected final R getResource(OntStatement statement) {
            return (R)((OntNegativeAssertion)statement.getSubject(this.getType()));
        }

        @Override
        public Stream<Triple> triples() {
            return Stream.concat(this.asResource().spec().map(FrontsTriple::asTriple), this.objects().flatMap(ONTObject::triples));
        }

        @Override
        public ONTObject<? extends OWLIndividual> fetchONTSubject(OntStatement statement, InternalObjectFactory factory) {
            return factory.getIndividual(this.getResource(statement).getSource());
        }

        @Override
        public OWLIndividual getSubject() {
            return (OWLIndividual)this.getONTSubject().getOWLObject();
        }

        public O getObject() {
            return this.getONTObject().getOWLObject();
        }

        @Override
        public P getProperty() {
            return (P)((OWLPropertyExpression)this.getONTPredicate().getOWLObject());
        }

        @Override
        public Object fromSubject(ONTObject o) {
            return this.fromIndividual((OWLIndividual)o.getOWLObject());
        }

        @Override
        public ONTObject<? extends OWLIndividual> toSubject(Object s, InternalObjectFactory factory) {
            return this.toIndividual(s, factory);
        }

        protected ONTObject<? extends OWLIndividual> toIndividual(Object s, InternalObjectFactory factory) {
            return s instanceof String ? this.toNamedIndividual((String)s, factory) : this.toAnonymousIndividual((BlankNodeId)s, factory);
        }

        protected ONTObject<OWLNamedIndividual> toNamedIndividual(String uri, InternalObjectFactory factory) {
            return ONTNamedIndividualImpl.find(uri, factory, this.model);
        }

        protected ONTObject<OWLAnonymousIndividual> toAnonymousIndividual(BlankNodeId id, InternalObjectFactory factory) {
            return ONTAnonymousIndividualImpl.find(id, factory, this.model);
        }

        protected Object fromIndividual(OWLIndividual i) {
            if (i.isOWLNamedIndividual()) {
                return ONTEntityImpl.getURI((OWLEntity)i.asOWLNamedIndividual());
            }
            return OWLAnonymousIndividualImpl.asONT(i.asOWLAnonymousIndividual()).getBlankNodeId();
        }

        @Override
        public final ONTObject<A> merge(ONTObject<A> other) {
            if (this == other) {
                return this;
            }
            if (other instanceof NegativeAssertionImpl && this.sameTriple((NegativeAssertionImpl)other)) {
                return this;
            }
            NegativeAssertionImpl res = this.makeCopy(other);
            if (this.hasContent()) {
                res.putContent(this.getContent());
            }
            res.hashCode = this.hashCode;
            return res;
        }

        protected abstract NegativeAssertionImpl makeCopy(ONTObject<A> var1);

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }
    }
}

