/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntList;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class AbstractListBasedTranslator<Axiom extends OWLLogicalAxiom, ONT_SUBJECT extends OntObject, OWL_SUBJECT extends OWLObject, ONT_MEMBER extends OntObject, OWL_MEMBER extends OWLObject>
extends AxiomTranslator<Axiom> {
    abstract OWLObject getSubject(Axiom var1);

    abstract Property getPredicate();

    abstract Collection<? extends OWLObject> getObjects(Axiom var1);

    abstract Class<ONT_SUBJECT> getView();

    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.writeList(model, this.getSubject(axiom), this.getPredicate(), this.getObjects(axiom), axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalStatements(model, null, this.getPredicate(), null).filterKeep(this::filter);
    }

    protected boolean filter(OntStatement statement) {
        return statement.getSubject().canAs(this.getView()) && statement.getObject().canAs(RDFList.class);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return this.getPredicate().equals(statement.getPredicate()) && this.filter(statement);
    }

    ONTObject<Axiom> makeAxiom(OntStatement statement, Function<ONT_SUBJECT, ONTObject<? extends OWL_SUBJECT>> subjectExtractor, BiFunction<ONT_SUBJECT, RDFNode, Optional<OntList<ONT_MEMBER>>> listExtractor, Function<ONT_MEMBER, ONTObject<? extends OWL_MEMBER>> memberExtractor, Collector<ONTObject<? extends OWL_MEMBER>, ?, ? extends Collection<ONTObject<? extends OWL_MEMBER>>> collector, BiFunction<ONTObject<? extends OWL_SUBJECT>, Collection<ONTObject<? extends OWL_MEMBER>>, Axiom> axiomMaker) {
        OntObject ontSubject = (OntObject)statement.getSubject(this.getView());
        ONTObject<? extends OWL_SUBJECT> subject = subjectExtractor.apply(ontSubject);
        OntList list = listExtractor.apply(ontSubject, statement.getObject()).orElseThrow(() -> new OntApiException("Can't get OntList for statement " + Models.toString(statement)));
        Collection<ONTObject<? extends OWL_MEMBER>> members = list.members().map(memberExtractor).collect(collector);
        OWLLogicalAxiom res = (OWLLogicalAxiom)axiomMaker.apply(subject, members);
        return ONTWrapperImpl.create(res, statement).append(() -> list.spec().map(FrontsTriple::asTriple)).append(members);
    }

    protected static abstract class WithListImpl<A extends OWLAxiom, M extends OntObject>
    extends ONTAxiomImpl<A>
    implements WithContent<A> {
        protected final InternalCache.Loading<A, Object[]> content = this.createContentCache();

        protected WithListImpl(Triple t, Supplier<OntModel> m) {
            this(WithListImpl.strip(t.getSubject()), t.getPredicate().getURI(), WithListImpl.strip(t.getObject()), m);
        }

        protected WithListImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        protected abstract OntList<M> findList(OntStatement var1);

        protected abstract WithListImpl<A, M> makeCopy(ONTObject<A> var1);

        protected abstract A createAnnotatedAxiom(Object[] var1, InternalObjectFactory var2, Collection<OWLAnnotation> var3);

        @Override
        public InternalCache.Loading<A, Object[]> getContentCache() {
            return this.content;
        }

        @Override
        protected boolean sameContent(ONTStatementImpl other) {
            return Arrays.equals(this.getContent(), ((WithListImpl)other).getContent());
        }

        @Override
        public Stream<Triple> triples() {
            OntStatement s = this.asStatement();
            return Stream.concat(Stream.concat(Stream.of(s), this.findList(s).spec()).map(FrontsTriple::asTriple), this.objects().flatMap(ONTObject::triples));
        }

        @Override
        public final ONTObject<A> merge(ONTObject<A> other) {
            if (this == other) {
                return this;
            }
            if (other instanceof WithListImpl && this.sameTriple((WithListImpl)other)) {
                return this;
            }
            WithListImpl<A, M> res = this.makeCopy(other);
            if (this.hasContent()) {
                res.putContent(this.getContent());
            }
            res.hashCode = this.hashCode;
            return res;
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        protected A createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.createAnnotatedAxiom(this.getContent(), this.getObjectFactory(), annotations);
        }
    }
}

