/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.impl.conf.PersonalityBuilder;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SearchModel
extends OntGraphModelImpl
implements HasObjectFactory,
HasConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchModel.class);
    protected final InternalConfig conf;
    protected final OntPersonality personality;
    private Boolean hasAnnotations;
    private Boolean hasSubAnnotations;
    protected final Map<Class<? extends OntObject>, Set<Node>> systemResources = new HashMap<Class<? extends OntObject>, Set<Node>>();

    public SearchModel(Graph graph, OntPersonality personality, InternalConfig conf) {
        this(graph, personality, conf, true);
    }

    protected SearchModel(Graph graph, OntPersonality personality, InternalConfig conf, boolean withCache) {
        super(graph, withCache ? SearchModel.cachedPersonality(personality, conf) : personality);
        this.conf = Objects.requireNonNull(conf);
        this.personality = personality;
    }

    static <X> X handleFetchNodeAsException(OntJenaException error, Node node, Class<? extends RDFNode> type, OntModel m, InternalConfig conf) throws OntApiException {
        if (!conf.isIgnoreAxiomsReadErrors()) {
            throw new OntApiException((Throwable)((Object)error));
        }
        LOGGER.warn("Can't wrap node <{}> as {}: found a problem inside <{}>: '{}'", new Object[]{node, OntObjectImpl.viewAsString(type), m.getID(), error.getMessage()});
        return null;
    }

    public static OntPersonality cachedPersonality(OntPersonality from, InternalConfig conf) {
        if (!conf.useLoadNodesCache()) {
            throw new IllegalArgumentException("Negative cache size is specified");
        }
        int size = conf.getLoadNodesCacheSize();
        PersonalityBuilder res = PersonalityBuilder.from(from);
        from.types(OntObject.class).filter(x -> x != OntSWRL.DArg.class && x != OntSWRL.Arg.class).forEach(x -> CachedFactory.cache(res, from, x, size));
        return res.build();
    }

    @Override
    public InternalConfig getConfig() {
        return this.conf;
    }

    @Override
    public OntGraphModelImpl getTopModel() {
        if (this.independent()) {
            return this;
        }
        return new SearchModel(this.getBaseGraph(), this.personality, this.conf, false){

            @Override
            public InternalObjectFactory getObjectFactory() {
                return SearchModel.this.getObjectFactory();
            }
        };
    }

    @Override
    public Set<Node> getSystemResources(Class<? extends OntObject> type) {
        return this.systemResources.computeIfAbsent(type, x -> super.getSystemResources(type));
    }

    public boolean hasAnnotations() {
        return this.hasAnnotations == null ? (this.hasAnnotations = Boolean.valueOf(this.contains(null, OWL.annotatedSource, null))) : this.hasAnnotations;
    }

    public boolean hasSubAnnotations() {
        return this.hasSubAnnotations == null ? (this.hasSubAnnotations = Boolean.valueOf(this.contains(null, RDF.type, (RDFNode)OWL.Annotation))) : this.hasSubAnnotations;
    }

    @Override
    public ExtendedIterator<Resource> listAnnotations(Resource t, Resource s, Property p, RDFNode o) {
        if (!this.hasAnnotations()) {
            return NullIterator.instance();
        }
        if (OWL.Annotation == t && !this.hasSubAnnotations()) {
            return NullIterator.instance();
        }
        return super.listAnnotations(t, s, p, o);
    }

    @Override
    public <N extends RDFNode> N fetchNodeAs(Node node, Class<N> type) {
        try {
            return super.fetchNodeAs(node, type);
        }
        catch (OntJenaException e) {
            return (N)((RDFNode)SearchModel.handleFetchNodeAsException(e, node, type, this, this.conf));
        }
    }

    public static class CachedFactory
    extends BaseFactoryImpl {
        private final ObjectFactory from;
        private final Class<? extends OntObject> type;
        private final InternalCache<Node, Boolean> canWrapCache;

        public CachedFactory(Class<? extends OntObject> type, ObjectFactory from, int limit, boolean parallel) {
            this.type = Objects.requireNonNull(type);
            this.from = Objects.requireNonNull(from);
            this.canWrapCache = InternalCache.createBounded(parallel, limit);
        }

        private static CachedFactory create(Class<? extends OntObject> type, ObjectFactory from, int limit) {
            return new CachedFactory(type, from instanceof CachedFactory ? ((CachedFactory)from).from : from, limit, false);
        }

        static void cache(PersonalityBuilder res, OntPersonality from, Class<? extends OntObject> type, int limit) {
            res.add(type, CachedFactory.create(type, from.getObjectFactory(type), limit));
        }

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
            return this.from.iterator(eg);
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            if (node.isLiteral()) {
                return this.from.canWrap(node, eg);
            }
            return this.canWrapCache.get(node, n -> this.from.canWrap((Node)n, eg));
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            return this.from.createInstance(node, eg);
        }

        public String toString() {
            return String.format("CachedFactory[%s]", OntObjectImpl.viewAsString(this.type));
        }
    }
}

