/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.CollectionGraph;
import org.apache.jena.sparql.util.graph.GraphListenerBase;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLTriples<V extends OWLObject>
extends ONTWrapperImpl<V> {
    protected final Set<Triple> triples;

    protected OWLTriples(V object, Set<Triple> triples) {
        super(object);
        this.triples = triples;
    }

    @Override
    public Stream<Triple> triples() {
        return this.triples.stream();
    }

    @Override
    public Graph toGraph() {
        return new CollectionGraph(this.triples);
    }

    @Override
    public boolean isDefinitelyEmpty() {
        return this.triples.isEmpty();
    }

    public static Listener createListener() {
        return new Listener();
    }

    public static class Listener
    extends GraphListenerBase {
        private static final Logger LOGGER = LoggerFactory.getLogger(Listener.class);
        protected final Set<Triple> triples = new HashSet<Triple>();

        protected void addEvent(Triple t) {
            this.triples.add(t);
        }

        protected void deleteEvent(Triple t) {
            LOGGER.warn("Suspicious deleting: {}", (Object)t);
            this.triples.remove(t);
        }

        public Set<Triple> getTriples() {
            return Collections.unmodifiableSet(this.triples);
        }

        public <X extends OWLObject> OWLTriples<X> toObject(X key) {
            return new OWLTriples<X>(key, this.triples);
        }
    }
}

