/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntManagers;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.SimpleObjectFactory;
import com.github.owlcs.ontapi.internal.WithMerge;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntRealProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Collection;
import java.util.HashMap;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;

public interface InternalObjectFactory {
    public static final InternalObjectFactory DEFAULT = new SimpleObjectFactory(OntManagers.getDataFactory());

    public DataFactory getOWLDataFactory();

    public ONTObject<OWLClass> getClass(OntClass.Named var1);

    public ONTObject<? extends OWLClassExpression> getClass(OntClass var1);

    public ONTObject<OWLDatatype> getDatatype(OntDataRange.Named var1);

    public ONTObject<? extends OWLDataRange> getDatatype(OntDataRange var1);

    public ONTObject<OWLObjectProperty> getProperty(OntObjectProperty.Named var1);

    public ONTObject<OWLAnnotationProperty> getProperty(OntAnnotationProperty var1);

    public ONTObject<OWLDataProperty> getProperty(OntDataProperty var1);

    public ONTObject<? extends OWLObjectPropertyExpression> getProperty(OntObjectProperty.Inverse var1);

    public ONTObject<OWLNamedIndividual> getIndividual(OntIndividual.Named var1);

    public ONTObject<OWLAnonymousIndividual> getIndividual(OntIndividual.Anonymous var1);

    public ONTObject<OWLFacetRestriction> getFacetRestriction(OntFacetRestriction var1);

    public ONTObject<OWLLiteral> getLiteral(Literal var1);

    public ONTObject<OWLAnnotation> getAnnotation(OntStatement var1);

    public ONTObject<SWRLVariable> getSWRLVariable(OntSWRL.Variable var1);

    public ONTObject<? extends SWRLIArgument> getSWRLArgument(OntSWRL.IArg var1);

    public ONTObject<? extends SWRLDArgument> getSWRLArgument(OntSWRL.DArg var1);

    public ONTObject<? extends SWRLAtom> getSWRLAtom(OntSWRL.Atom<?> var1);

    public ONTObject<IRI> getIRI(String var1);

    default public IRI toIRI(String str) {
        return IRI.create((String)OntApiException.notNull(str, "Null IRI."));
    }

    default public Collection<ONTObject<OWLAnnotation>> getAnnotations(OntStatement axiom, InternalConfig config) {
        HashMap res = new HashMap();
        ReadHelper.listAnnotations(axiom, config, this).forEachRemaining(x -> WithMerge.add(res, x));
        return res.values();
    }

    default public ONTObject<? extends OWLAnnotationSubject> getSubject(OntObject subject) {
        if (OntApiException.notNull(subject, "Null resource").isURIResource()) {
            return this.getIRI(subject.getURI());
        }
        if (subject.isAnon()) {
            return this.getIndividual(OntModels.asAnonymousIndividual((RDFNode)subject));
        }
        throw new OntApiException.IllegalArgument("Not an AnnotationSubject " + subject);
    }

    default public ONTObject<? extends OWLAnnotationValue> getValue(RDFNode value) {
        if (OntApiException.notNull(value, "Null node").isLiteral()) {
            return this.getLiteral(value.asLiteral());
        }
        if (value.isURIResource()) {
            return this.getIRI(value.asResource().getURI());
        }
        if (value.isAnon()) {
            return this.getIndividual(OntModels.asAnonymousIndividual(value));
        }
        throw new OntApiException.IllegalArgument("Not an AnnotationValue " + value);
    }

    default public ONTObject<? extends OWLIndividual> getIndividual(OntIndividual individual) {
        if (OntApiException.notNull(individual, "Null individual").isURIResource()) {
            return this.getIndividual((OntIndividual.Named)individual.as(OntIndividual.Named.class));
        }
        return this.getIndividual((OntIndividual.Anonymous)individual.as(OntIndividual.Anonymous.class));
    }

    default public ONTObject<? extends OWLEntity> getEntity(OntEntity entity) {
        Class<OntObject> type = OntModels.getOntType((OntObject)OntApiException.notNull(entity, "Null entity"));
        if (type == OntClass.Named.class) {
            return this.getClass((OntClass.Named)entity);
        }
        if (type == OntDataRange.Named.class) {
            return this.getDatatype((OntDataRange.Named)entity);
        }
        if (type == OntIndividual.Named.class) {
            return this.getIndividual((OntIndividual.Named)entity);
        }
        if (type == OntAnnotationProperty.class) {
            return this.getProperty((OntAnnotationProperty)entity);
        }
        if (type == OntDataProperty.class) {
            return this.getProperty((OntDataProperty)entity);
        }
        if (type == OntObjectProperty.Named.class) {
            return this.getProperty((OntObjectProperty.Named)entity);
        }
        throw new OntApiException.IllegalArgument("Unsupported " + entity);
    }

    default public ONTObject<? extends OWLPropertyExpression> getProperty(OntProperty property) {
        if (OntApiException.notNull(property, "Null property expression.").canAs(OntAnnotationProperty.class)) {
            return this.getProperty((OntAnnotationProperty)property.as(OntAnnotationProperty.class));
        }
        return this.getProperty((OntRealProperty)property);
    }

    default public ONTObject<? extends OWLPropertyExpression> getProperty(OntRealProperty property) {
        if (OntApiException.notNull(property, "Null Data/Object property").canAs(OntObjectProperty.class)) {
            return this.getProperty((OntObjectProperty)property.as(OntObjectProperty.class));
        }
        if (property.canAs(OntDataProperty.class)) {
            return this.getProperty((OntDataProperty)property.as(OntDataProperty.class));
        }
        throw new OntApiException("Unsupported property " + property);
    }

    default public ONTObject<? extends OWLObjectPropertyExpression> getProperty(OntObjectProperty property) {
        if (OntApiException.notNull(property, "Null object property.").isAnon()) {
            return this.getProperty((OntObjectProperty.Inverse)property.as(OntObjectProperty.Inverse.class));
        }
        return this.getProperty((OntObjectProperty.Named)property.as(OntObjectProperty.Named.class));
    }
}

