/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ObjectMap;
import com.github.owlcs.ontapi.internal.WithMerge;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLObject;

public class CacheObjectMapImpl<X extends OWLObject>
implements ObjectMap<X> {
    private final Supplier<Iterator<ONTObject<X>>> loader;
    private final InternalCache.Loading<CacheObjectMapImpl<X>, CachedMap<X, ONTObject<X>>> map;
    private volatile boolean hasNew;
    private final boolean withMerge;
    private final boolean parallel;
    private final boolean fastIterator;

    public CacheObjectMapImpl(Supplier<Iterator<ONTObject<X>>> loader, boolean parallel) {
        this(loader, true, parallel, true);
    }

    public CacheObjectMapImpl(Supplier<Iterator<ONTObject<X>>> loader, boolean withMerge, boolean parallel, boolean fastIterator) {
        this.loader = Objects.requireNonNull(loader);
        this.withMerge = withMerge;
        this.parallel = parallel;
        this.fastIterator = fastIterator;
        this.map = InternalCache.createSoftSingleton(CacheObjectMapImpl::loadMap);
    }

    protected CachedMap<X, ONTObject<X>> loadMap() {
        this.hasNew = false;
        Iterator<ONTObject<X>> it = this.loader.get();
        Map<X, ONTObject<X>> res = this.createMap();
        if (this.withMerge) {
            while (it.hasNext()) {
                WithMerge.add(res, it.next());
            }
            return CachedMap.create(res, WithMerge.getMerger(), this.parallel);
        }
        while (it.hasNext()) {
            ONTObject<X> v = it.next();
            res.put(v.getOWLObject(), v);
        }
        return CachedMap.create(res, null, this.parallel);
    }

    protected <K, V> Map<K, V> createMap() {
        if (this.parallel && !this.fastIterator) {
            return new ConcurrentHashMap();
        }
        return new LinkedHashMap();
    }

    protected CachedMap<X, ONTObject<X>> getMap() {
        return this.map.get(this);
    }

    @Override
    public boolean isLoaded() {
        return !this.map.isEmpty();
    }

    @Override
    public void load() {
        this.getMap();
    }

    @Override
    public boolean hasNew() {
        return this.isLoaded() && this.hasNew;
    }

    @Override
    public Stream<X> keys() {
        if (this.fastIterator) {
            return this.getMap().getKeys().stream();
        }
        return this.getMap().asMap().keySet().stream();
    }

    @Override
    public Stream<ONTObject<X>> values() {
        return this.getMap().asMap().values().stream();
    }

    @Override
    public long count() {
        return this.getMap().asMap().size();
    }

    @Override
    public boolean contains(X o) {
        return this.getMap().contains(o);
    }

    @Override
    public void remove(X key) {
        if (!this.isLoaded()) {
            return;
        }
        this.getMap().remove(key);
    }

    @Override
    public void add(ONTObject<X> value) {
        this.getMap().put(value.getOWLObject(), value);
        this.hasNew = true;
    }

    @Override
    public ONTObject<X> get(X key) {
        return this.getMap().get(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public static class CachedMap<K, V> {
        protected final Map<K, V> map;
        protected final BiFunction<V, V, V> merger;
        protected final InternalCache.Loading<CachedMap<?, ?>, List<K>> keys;

        protected CachedMap(Map<K, V> objects, InternalCache.Loading<CachedMap<?, ?>, List<K>> cache, BiFunction<V, V, V> merger) {
            this.map = Objects.requireNonNull(objects);
            this.keys = Objects.requireNonNull(cache);
            this.merger = merger;
        }

        public static <K, V> CachedMap<K, V> create(Map<K, V> map, BiFunction<V, V, V> merger, boolean parallel) {
            InternalCache.Loading<CachedMap<?, ?>, List<K>> keys = InternalCache.createSoftSingleton(m -> {
                if (!parallel) {
                    return new ArrayList(map.keySet());
                }
                return new CopyOnWriteArrayList(map.keySet());
            });
            return new CachedMap<K, V>(map, keys, merger);
        }

        public long size() {
            return this.map.size();
        }

        public Map<K, V> asMap() {
            return this.map;
        }

        public List<K> getKeys() {
            return this.keys.get(this);
        }

        public void remove(K key) {
            if (this.map.remove(key) == null) {
                return;
            }
            if (this.keys.isEmpty()) {
                return;
            }
            List<K> list = this.keys.get(this);
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!key.equals(list.get(i))) continue;
                list.remove(i);
                break;
            }
        }

        public void put(K key, V value) {
            if (this.merger != null) {
                this.map.merge(key, value, this.merger);
            } else {
                this.map.put(key, value);
            }
            if (this.keys.isEmpty()) {
                return;
            }
            List<K> list = this.keys.get(this);
            if (this.map.size() - 1 != list.size()) {
                return;
            }
            list.add(key);
        }

        public boolean contains(K key) {
            return this.map.containsKey(key);
        }

        public V get(K key) {
            return this.map.get(key);
        }
    }
}

