/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.BaseModel;
import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.HasAdapter;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OWLAdapter;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.OntGraphDocumentSource;
import com.github.owlcs.ontapi.OntGraphUtils;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyCollection;
import com.github.owlcs.ontapi.OntologyCollectionImpl;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.RWLockedCollection;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.config.OntWriterConfiguration;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.UnionModel;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.impl.WrappedGraph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyStorageIOException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.DefaultImpendingChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.HasOntologyID;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.ImportChange;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVetoException;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OWLStorerNotFoundException;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyManagerImpl
implements OntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler,
HasAdapter,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyManagerImpl.class);
    private static final long serialVersionUID = -4764329329583952286L;
    protected final ListenersHolder listeners = new ListenersHolder();
    protected OntConfig config;
    protected OntLoaderConfiguration loaderConfig;
    protected OntWriterConfiguration writerConfig;
    protected transient InternalCache.Loading<String, IRI> iris;
    protected final RWLockedCollection<OWLOntologyFactory> ontologyFactories;
    protected final RWLockedCollection<OWLOntologyIRIMapper> documentIRIMappers;
    protected final RWLockedCollection<OntologyManager.DocumentSourceMapping> documentSourceMappers;
    protected final RWLockedCollection<OWLParserFactory> parserFactories;
    protected final RWLockedCollection<OWLStorerFactory> ontologyStorers;
    protected final ReadWriteLock lock;
    protected final DataFactory dataFactory;
    protected final OntologyCollection<OntInfo> content;

    public OntologyManagerImpl(DataFactory dataFactory, OntologyFactory ontologyFactory, ReadWriteLock readWriteLock) {
        this(dataFactory, readWriteLock, PriorityCollectionSorting.ON_SET_INJECTION_ONLY);
        this.ontologyFactories.add((OWLOntologyFactory)((Serializable)((Object)Objects.requireNonNull(ontologyFactory, "Null Ontology Factory"))));
    }

    public OntologyManagerImpl(DataFactory dataFactory, ReadWriteLock lock, PriorityCollectionSorting sorting) {
        this.dataFactory = Objects.requireNonNull(dataFactory, "Null Data Factory");
        this.lock = lock == null ? NoOpReadWriteLock.NO_OP_RW_LOCK : lock;
        PriorityCollectionSorting _sorting = sorting == null ? PriorityCollectionSorting.NEVER : sorting;
        this.documentIRIMappers = new RWLockedCollection(this.lock, _sorting);
        this.documentSourceMappers = new RWLockedCollection(this.lock);
        this.ontologyFactories = new RWLockedCollection<OWLOntologyFactory>(this.lock, _sorting){

            @Override
            protected void onAdd(OWLOntologyFactory f) {
                if (f instanceof OntologyFactory) {
                    return;
                }
                throw new OntApiException.IllegalArgument("Wrong argument: " + f + ". Only " + OntologyFactory.class.getSimpleName() + " can be accepted.");
            }
        };
        this.parserFactories = new RWLockedCollection(this.lock, _sorting);
        this.ontologyStorers = new RWLockedCollection(this.lock, _sorting);
        this.config = OntConfig.createConfig(this.lock);
        this.content = new OntologyCollectionImpl<OntInfo>(this.lock);
        this.iris = this.createIRICache();
    }

    @Override
    public OWLAdapter getAdapter() {
        return OWLAdapter.get();
    }

    protected InternalCache.Loading<String, IRI> createIRICache() {
        int size = this.config.getManagerIRIsCacheSize();
        if (size < 0) {
            return InternalCache.createEmpty().asLoading(IRI::create);
        }
        return InternalCache.createBounded(IRI::create, NoOpReadWriteLock.isConcurrent(this.lock), size);
    }

    public boolean isConcurrent() {
        return NoOpReadWriteLock.isConcurrent(this.lock);
    }

    @Nonnull
    public ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public DataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public OntConfig getOntologyConfigurator() {
        this.getLock().readLock().lock();
        try {
            OntConfig ontConfig = this.config;
            return ontConfig;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public void setOntologyConfigurator(OntologyConfigurator conf) {
        this.getLock().writeLock().lock();
        try {
            int size = this.config.getManagerIRIsCacheSize();
            this.config = OntConfig.withLock(this.getAdapter().asONT(conf), this.lock);
            if (size != this.config.getManagerIRIsCacheSize()) {
                this.iris = this.createIRICache();
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public void setOntologyLoaderConfiguration(@Nullable OWLOntologyLoaderConfiguration config) {
        this.getLock().writeLock().lock();
        try {
            OntLoaderConfiguration conf = this.getAdapter().asONT(config);
            if (ModelConfig.hasChanges(this.getOntLoaderConfiguration(), conf)) {
                this.content.values().filter(x -> x.getModelConfig().useManagerConfig()).map(OntInfo::get).forEach(Ontology::clearCache);
            }
            this.loaderConfig = conf;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public OntLoaderConfiguration getOntologyLoaderConfiguration() {
        this.getLock().readLock().lock();
        try {
            OntLoaderConfiguration ontLoaderConfiguration = this.getOntLoaderConfiguration();
            return ontLoaderConfiguration;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected OntLoaderConfiguration getOntLoaderConfiguration() {
        if (this.loaderConfig != null) {
            return this.loaderConfig;
        }
        return this.config.buildLoaderConfiguration();
    }

    @Override
    public void setOntologyWriterConfiguration(@Nullable OWLOntologyWriterConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            if (Objects.equals((Object)this.writerConfig, conf)) {
                return;
            }
            this.writerConfig = this.getAdapter().asONT(conf);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public OntWriterConfiguration getOntologyWriterConfiguration() {
        this.getLock().readLock().lock();
        try {
            if (this.writerConfig != null) {
                OntWriterConfiguration ontWriterConfiguration = this.writerConfig;
                return ontWriterConfiguration;
            }
            OntWriterConfiguration ontWriterConfiguration = this.config.buildWriterConfiguration();
            return ontWriterConfiguration;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public RWLockedCollection<OWLOntologyFactory> getOntologyFactories() {
        return this.ontologyFactories;
    }

    @Override
    public RWLockedCollection<OWLStorerFactory> getOntologyStorers() {
        return this.ontologyStorers;
    }

    @Override
    public RWLockedCollection<OWLParserFactory> getOntologyParsers() {
        return this.parserFactories;
    }

    @Override
    public RWLockedCollection<OWLOntologyIRIMapper> getIRIMappers() {
        return this.documentIRIMappers;
    }

    @Override
    public RWLockedCollection<OntologyManager.DocumentSourceMapping> getDocumentSourceMappers() {
        return this.documentSourceMappers;
    }

    public void setDefaultChangeBroadcastStrategy(@Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.setDefaultChangeBroadcastStrategy(strategy);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener, @Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangeListener(listener, strategy);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addImpendingOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeImpendingOntologyChangeListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangesVetoedListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyChangesVetoedListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addMissingImportListener(@Nonnull MissingImportListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addMissingImportListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeMissingImportListener(@Nonnull MissingImportListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeMissingImportListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyLoaderListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyLoaderListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void addOntologyChangeProgessListener(@Nonnull OWLOntologyChangeProgressListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.addOntologyChangeProgressListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntologyChangeProgessListener(@Nonnull OWLOntologyChangeProgressListener listener) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.removeOntologyChangeProgressListener(listener);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public Ontology createOntology(@Nonnull OWLOntologyID id) {
        this.getLock().writeLock().lock();
        try {
            Ontology ontology = this.create(id).get();
            return ontology;
        }
        catch (OWLOntologyCreationException e) {
            throw new OntApiException("Unable to create ontology " + id, e);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected OntInfo create(OWLOntologyID ontologyID) throws OWLOntologyCreationException, OWLOntologyFactoryNotFoundException {
        ID id = this.getAdapter().asONT(ontologyID);
        Optional<OntInfo> ont = this.content.get(id);
        if (ont.isPresent()) {
            throw new OWLOntologyAlreadyExistsException((OWLOntologyID)id);
        }
        IRI doc = this.computeDocumentIRI(id);
        if (doc == null) {
            throw new OWLOntologyCreationException("Can't compute document iri from id " + id);
        }
        if (this.content.values().anyMatch(o -> Objects.equals(o.getDocumentIRI(), doc))) {
            throw new OWLOntologyDocumentAlreadyExistsException(doc);
        }
        for (OWLOntologyFactory factory : this.getOntologyFactories()) {
            if (!factory.canCreateFromDocumentIRI(doc)) continue;
            this.getAdapter().asONT(factory).createOntology(this, id);
            return this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException((OWLOntologyID)id)).addDocumentIRI(doc);
        }
        throw new OWLOntologyFactoryNotFoundException(doc);
    }

    public Ontology createOntology(@Nonnull IRI iri, @Nonnull Stream<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) {
        this.getLock().writeLock().lock();
        try {
            ID id = ID.create(Objects.requireNonNull(iri));
            if (this.contains(iri)) {
                throw new OWLOntologyAlreadyExistsException((OWLOntologyID)id);
            }
            Ontology res = this.createOntology(iri);
            this.addAxioms(res, ontologies.flatMap(o -> copyLogicalAxiomsOnly ? o.logicalAxioms() : o.axioms()));
            Ontology ontology = res;
            return ontology;
        }
        catch (OWLOntologyAlreadyExistsException e) {
            throw new OntApiException("Unable to create ontology " + iri, e);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public Ontology createOntology(@Nonnull Stream<OWLAxiom> axioms, @Nonnull IRI iri) {
        this.getLock().writeLock().lock();
        try {
            ID id = ID.create(Objects.requireNonNull(iri));
            if (this.contains(iri)) {
                throw new OWLOntologyAlreadyExistsException((OWLOntologyID)id);
            }
            Ontology ont = this.createOntology(iri);
            this.addAxioms(ont, axioms);
            Ontology ontology = ont;
            return ontology;
        }
        catch (OWLOntologyAlreadyExistsException e) {
            throw new OntApiException("Unable to create ontology " + iri, e);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ontology addOntology(@Nonnull Graph graph, @Nonnull OntLoaderConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            ID id = OntGraphUtils.getOntologyID(graph);
            Map<ID, Graph> graphs = OntGraphUtils.toGraphMap(graph);
            OntologyManager.DocumentSourceMapping mapping = i -> graphs.entrySet().stream().filter(e -> OntologyManagerImpl.matchIDs((OWLOntologyID)e.getKey(), i)).map(e -> OntGraphDocumentSource.wrap((Graph)e.getValue())).findFirst().orElse(null);
            RWLockedCollection<OntologyManager.DocumentSourceMapping> store = this.getDocumentSourceMappers();
            try {
                store.add(mapping);
                Ontology ontology = this.loadOntologyFromOntologyDocument(mapping.map(id), conf);
                store.remove(mapping);
                return ontology;
            }
            catch (Throwable throwable) {
                try {
                    store.remove(mapping);
                    throw throwable;
                }
                catch (OWLOntologyCreationException e) {
                    throw new OntApiException("Unable put graph into the manager", e);
                }
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public static boolean matchIDs(OWLOntologyID left, OWLOntologyID right) {
        if (left.equals((Object)right)) {
            return true;
        }
        IRI iri = right.getVersionIRI().orElse(right.getOntologyIRI().orElse(null));
        if (iri == null) {
            return false;
        }
        return left.match(iri);
    }

    @Nullable
    protected IRI computeDocumentIRI(OWLOntologyID id) {
        IRI documentIRI = this.getDocumentIRIFromMappers(id);
        if (documentIRI == null) {
            documentIRI = !id.isAnonymous() ? (IRI)id.getDefaultDocumentIRI().orElse(null) : IRI.generateDocumentIRI();
        }
        return documentIRI;
    }

    @Nullable
    protected IRI getDocumentIRIFromMappers(OWLOntologyID id) {
        IRI defaultIRI = id.getDefaultDocumentIRI().orElse(null);
        if (defaultIRI == null) {
            return null;
        }
        return this.mapIRI(defaultIRI).orElse(defaultIRI);
    }

    protected Optional<OWLOntologyDocumentSource> findDocumentSource(OWLOntologyID id) {
        return this.getDocumentSourceMappers().stream().map(x -> x.map(id)).filter(Objects::nonNull).findFirst();
    }

    protected Optional<IRI> mapIRI(IRI iri) {
        return this.getIRIMappers().stream().map(m -> m.getDocumentIRI(iri)).filter(Objects::nonNull).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Ontology getOntology(@Nonnull IRI iri) {
        this.getLock().readLock().lock();
        try {
            ID id = ID.create(Objects.requireNonNull(iri));
            Optional<OntInfo> res = this.content.get(id);
            if (!res.isPresent()) {
                res = this.content.values().filter(e -> e.getOntologyID().match(iri)).findFirst();
            }
            Ontology ontology = res.map(OntInfo::get).orElse(null);
            return ontology;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public Ontology getOntology(@Nonnull OWLOntologyID id) {
        this.getLock().readLock().lock();
        try {
            Ontology ontology = this.ontology(id).orElse(null);
            return ontology;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Optional<Ontology> ontology(OWLOntologyID id) {
        Optional<OntInfo> res = this.content.get(id);
        if (!res.isPresent() && !id.isAnonymous()) {
            IRI iri = (IRI)id.getOntologyIRI().orElseThrow(() -> new IllegalStateException("Should never happen."));
            res = this.content.values().filter(e -> e.getOntologyID().matchOntology(iri)).findFirst();
        }
        return res.map(OntInfo::get);
    }

    protected Optional<Ontology> ontology(Graph graph) {
        return this.content.values().map(OntInfo::get).filter(m -> Graphs.isSameBase(graph, m.asGraphModel().getGraph())).findFirst();
    }

    @Override
    public boolean contains(@Nonnull IRI iri) {
        OntApiException.notNull(iri, "Ontology IRI cannot be null");
        this.getLock().readLock().lock();
        try {
            boolean bl = this.content.keys().anyMatch(o -> o.match(iri));
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean contains(@Nonnull OWLOntologyID id) {
        this.getLock().readLock().lock();
        try {
            if (id.isAnonymous()) ** GOTO lbl-1000
            if (this.content.contains(id)) ** GOTO lbl-1000
            if (this.content.keys().anyMatch((Predicate<OWLOntologyID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, match(org.semanticweb.owlapi.model.OWLOntologyID ), (Lorg/semanticweb/owlapi/model/OWLOntologyID;)Z)((OWLOntologyID)id))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            var2_2 = v0;
            return var2_2;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public boolean contains(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            boolean bl = this.hasOntology(ontology);
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected boolean hasOntology(OWLOntology ontology) {
        return this.content.values().map(OntInfo::get).anyMatch(o -> o.equals(ontology));
    }

    public boolean containsVersion(@Nonnull IRI iri) {
        this.getLock().readLock().lock();
        try {
            boolean bl = this.content.keys().anyMatch(o -> o.matchVersion(iri));
            return bl;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void removeOntology(OWLOntology ontology) {
        this.getLock().writeLock().lock();
        try {
            this.removeOntology(ontology.getOntologyID());
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void removeOntology(@Nonnull OWLOntologyID id) {
        this.getLock().writeLock().lock();
        try {
            this.content.remove(id).map(OntInfo::getModelConfig).ifPresent(x -> x.setManager(null));
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void clearOntologies() {
        this.getLock().writeLock().lock();
        try {
            this.listeners.clear();
            this.content.values().map(OntInfo::getModelConfig).forEach(x -> x.setManager(null));
            this.content.clear();
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public Ontology getImportedOntology(@Nonnull OWLImportsDeclaration declaration) {
        this.getLock().readLock().lock();
        try {
            Ontology ontology = this.importedOntology(declaration.getIRI()).orElse(null);
            return ontology;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Optional<Ontology> importedOntology(IRI declaration) {
        return this.content.values().filter(e -> e.hasImportDeclaration(declaration)).map(OntInfo::get).findFirst();
    }

    protected Optional<Ontology> ontologyByDocumentIRI(IRI iri) {
        return this.content.values().filter(o -> Objects.equals(iri, o.getDocumentIRI())).map(OntInfo::get).findFirst();
    }

    @Nonnull
    public IRI getOntologyDocumentIRI(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            if (!this.hasOntology(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            IRI iRI = this.documentIRIByOntology(ontology).orElseThrow(() -> new OntApiException("Null document iri, ontology id=" + ontology.getOntologyID()));
            return iRI;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Optional<IRI> documentIRIByOntology(OWLOntology ontology) {
        return this.content.get(ontology.getOntologyID()).flatMap(i -> Optional.ofNullable(i.getDocumentIRI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOntologyDocumentIRI(@Nonnull OWLOntology ontology, @Nonnull IRI documentIRI) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            OntInfo info = this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id));
            info.addDocumentIRI(documentIRI);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOntologyFormat(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat format) {
        this.getLock().writeLock().lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id)).addFormat(format);
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public OWLDocumentFormat getOntologyFormat(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            OWLOntologyID id = ontology.getOntologyID();
            OWLDocumentFormat oWLDocumentFormat = this.content.get(id).map(OntInfo::getFormat).orElse(null);
            return oWLDocumentFormat;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void ontologyCreated(@Nonnull OWLOntology ont) {
        this.getLock().writeLock().lock();
        try {
            this.content.add(new OntInfo(this.getAdapter().asONT(ont)));
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public Stream<OWLOntology> directImports(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            if (!this.contains(ontology)) {
                throw new UnknownOWLOntologyException(ontology.getOntologyID());
            }
            Stream<OWLOntology> stream = ontology.importsDeclarations().map(this::getImportedOntology).map(OWLOntology.class::cast).filter(Objects::nonNull);
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public Stream<OWLOntology> imports(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            Stream<OWLOntology> stream = this.getImports(ontology, new LinkedHashSet<OWLOntology>()).stream();
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected Set<OWLOntology> getImports(OWLOntology ont, Set<OWLOntology> result) {
        this.directImports(ont).filter(result::add).forEach(o -> this.getImports((OWLOntology)o, result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLOntology> importsClosure(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            HashSet<OWLOntology> res = new HashSet<OWLOntology>();
            this.collectImportsClosure(ontology, res);
            Stream<OWLOntology> stream = res.stream();
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    protected void collectImportsClosure(OWLOntology ontology, Set<OWLOntology> res) {
        res.add(ontology);
        this.directImports(ontology).filter(o -> !res.contains(o)).forEach(o -> this.collectImportsClosure((OWLOntology)o, res));
    }

    public List<OWLOntology> getSortedImportsClosure(@Nonnull OWLOntology ontology) {
        this.getLock().readLock().lock();
        try {
            List<OWLOntology> list = ontology.importsClosure().sorted().collect(Collectors.toList());
            return list;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    @Override
    public Stream<OWLOntology> ontologies() {
        this.getLock().readLock().lock();
        try {
            Stream<OWLOntology> stream = this.content.values().map(OntInfo::get);
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public Stream<OWLOntologyID> ontologyIDsByVersion(@Nonnull IRI iri) {
        this.getLock().readLock().lock();
        try {
            Stream<OWLOntologyID> stream = this.content.keys().filter(o -> o.matchVersion(iri)).map(OWLOntologyID.class::cast);
            return stream;
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public ChangeApplied addAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        return this.applyChanges(Collections.singletonList(new AddAxiom(ont, axiom)));
    }

    public ChangeApplied addAxioms(@Nonnull OWLOntology ont, @Nonnull Stream<? extends OWLAxiom> axioms) {
        return this.applyChanges(axioms.map(ax -> new AddAxiom(ont, ax)).collect(Collectors.toList()));
    }

    public ChangeApplied removeAxiom(@Nonnull OWLOntology ont, @Nonnull OWLAxiom axiom) {
        return this.applyChanges(Collections.singletonList(new RemoveAxiom(ont, axiom)));
    }

    public ChangeApplied removeAxioms(@Nonnull OWLOntology ont, @Nonnull Stream<? extends OWLAxiom> axioms) {
        return this.applyChanges(axioms.map(ax -> new RemoveAxiom(ont, ax)).collect(Collectors.toList()));
    }

    public ChangeApplied applyChange(@Nonnull OWLOntologyChange change) {
        return this.applyChanges(Collections.singletonList(change));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeDetails applyChangesAndGetDetails(@Nonnull List<? extends OWLOntologyChange> changes) {
        this.getLock().writeLock().lock();
        try {
            this.listeners.broadcastImpendingChanges(changes);
            AtomicBoolean rollbackRequested = new AtomicBoolean(false);
            AtomicBoolean allNoOps = new AtomicBoolean(true);
            ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
            this.listeners.fireBeginChanges(changes.size());
            this.actuallyApply(changes, rollbackRequested, allNoOps, appliedChanges);
            if (rollbackRequested.get()) {
                this.rollBack(appliedChanges);
                appliedChanges.clear();
            }
            this.listeners.fireEndChanges();
            this.listeners.broadcastChanges(appliedChanges);
            if (rollbackRequested.get()) {
                ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, appliedChanges);
                return changeDetails;
            }
            if (allNoOps.get()) {
                ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.NO_OPERATION, appliedChanges);
                return changeDetails;
            }
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.SUCCESSFULLY, appliedChanges);
            return changeDetails;
        }
        catch (OWLOntologyChangeVetoException e) {
            this.listeners.broadcastOntologyChangesVetoed(changes, e);
            ChangeDetails changeDetails = new ChangeDetails(ChangeApplied.UNSUCCESSFULLY, Collections.emptyList());
            return changeDetails;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected void actuallyApply(List<? extends OWLOntologyChange> changes, AtomicBoolean rollbackRequested, AtomicBoolean allNoOps, List<OWLOntologyChange> appliedChanges) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (rollbackRequested.get()) continue;
            ChangeApplied enactChangeApplication = this.enactChangeApplication(oWLOntologyChange);
            if (enactChangeApplication == ChangeApplied.UNSUCCESSFULLY) {
                rollbackRequested.set(true);
            }
            if (enactChangeApplication == ChangeApplied.SUCCESSFULLY) {
                allNoOps.set(false);
                appliedChanges.add(oWLOntologyChange);
            }
            this.listeners.fireChangeApplied(oWLOntologyChange);
        }
    }

    protected void rollBack(List<OWLOntologyChange> appliedChanges) {
        for (OWLOntologyChange c : appliedChanges) {
            if (this.enactChangeApplication(c.reverseChange()) != ChangeApplied.UNSUCCESSFULLY) continue;
            throw new OntApiException("Rollback of changes unsuccessful: Change " + c + " could not be rolled back");
        }
    }

    protected ChangeApplied enactChangeApplication(OWLOntologyChange change) {
        OWLOntologyID newId;
        Optional<Ontology> existing;
        OWLOntology owl = change.getOntology();
        if (!(owl instanceof Ontology)) {
            throw new OntApiException.IllegalArgument("Not an OntologyModel instance: " + owl);
        }
        Ontology ont = (Ontology)owl;
        if (!this.hasOntology(ont)) {
            throw new UnknownOWLOntologyException(ont.getOntologyID());
        }
        if (!this.isChangeApplicable(change)) {
            return ChangeApplied.UNSUCCESSFULLY;
        }
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change.getChangeData(), owl.toString());
        }
        if (change instanceof SetOntologyID && (existing = this.content.get(newId = ((SetOntologyID)change).getNewOntologyID()).map(OntInfo::get)).isPresent() && !ont.equals(existing.get())) {
            throw new OWLOntologyRenameException(change.getChangeData(), newId);
        }
        Collection<OWLOntologyChange> relatedChanges = this.collectRelatedChanges(change);
        ChangeApplied res = ont.applyDirectChange(change);
        relatedChanges.forEach(arg_0 -> ((Ontology)ont).applyDirectChange(arg_0));
        return res;
    }

    protected Collection<OWLOntologyChange> collectRelatedChanges(OWLOntologyChange change) {
        Function<OWLAxiom, OWLAxiomChange> func;
        if (!change.isImportChange()) {
            return Collections.emptyList();
        }
        Ontology ont = (Ontology)change.getOntology();
        OWLOntologyID id = ont.getOntologyID();
        OntWriterConfiguration conf = this.content.get(id).map(OntInfo::getModelConfig).map(ModelConfig::getWriterConfig).orElseThrow(OntApiException.IllegalState::new);
        if (!conf.isControlImports()) {
            return Collections.emptyList();
        }
        OWLImportsDeclaration declaration = ((ImportChange)change).getImportDeclaration();
        Ontology importedOntology = this.getImportedOntology(declaration);
        if (importedOntology == null) {
            return Collections.emptyList();
        }
        if (change instanceof AddImport) {
            func = x -> new RemoveAxiom((OWLOntology)ont, x);
        } else if (change instanceof RemoveImport) {
            func = x -> new AddAxiom((OWLOntology)ont, x);
        } else {
            throw new OntApiException.IllegalState();
        }
        DataFactory df = this.getOWLDataFactory();
        return importedOntology.signature(Imports.INCLUDED).filter(arg_0 -> ((Ontology)ont).containsReference(arg_0)).map(arg_0 -> ((DataFactory)df).getOWLDeclarationAxiom(arg_0)).collect(Collectors.toSet()).stream().map(func).collect(Collectors.toList());
    }

    protected boolean isChangeApplicable(OWLOntologyChange change) {
        OWLOntologyID id = change.getOntology().getOntologyID();
        ModelConfig conf = this.content.get(id).map(OntInfo::getModelConfig).orElseThrow(OntApiException.IllegalState::new);
        return conf.isLoadAnnotationAxioms() || !change.isAddAxiom() || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ontology copyOntology(@Nonnull OWLOntology source, @Nonnull OntologyCopy settings) {
        this.getLock().writeLock().lock();
        try {
            Ontology res;
            OntApiException.notNull(source, "Null source ontology.");
            if (settings != OntologyCopy.SHALLOW && settings != OntologyCopy.DEEP) {
                throw new OntApiException.Unsupported("Not supported parameter: " + settings);
            }
            if (settings == OntologyCopy.SHALLOW && source instanceof Ontology) {
                Ontology ontology = this.addOntology(((Ontology)source).asGraphModel().getBaseGraph(), this.getOntologyLoaderConfiguration().setPerformTransformation(false).setProcessImports(false));
                return ontology;
            }
            OWLOntologyID id = source.getOntologyID();
            try {
                res = this.create(id).get();
            }
            catch (OWLOntologyCreationException e) {
                throw new OntApiException("Unable to create a fresh ontology with id=" + id, e);
            }
            if (source instanceof Ontology) {
                Graph src = ((Ontology)source).asGraphModel().getBaseGraph();
                OntModel dst = res.asGraphModel();
                GraphUtil.addInto((Graph)dst.getBaseGraph(), (Graph)src);
                dst.getID().imports().forEach(u -> this.importedOntology(IRI.create((String)u)).ifPresent(x -> dst.addImport(x.asGraphModel())));
            } else {
                source.importsDeclarations().forEach(i -> this.applyChange((OWLOntologyChange)new AddImport((OWLOntology)res, i)));
                source.annotations().forEach(n -> this.applyChange((OWLOntologyChange)new AddOntologyAnnotation((OWLOntology)res, n)));
                source.axioms().forEach(a -> this.applyChange((OWLOntologyChange)new AddAxiom((OWLOntology)res, a)));
            }
            if (!res.isAnonymous()) {
                OntModels.insert(this::models, res.asGraphModel(), false);
            }
            if (settings == OntologyCopy.DEEP) {
                OWLOntologyManager m = source.getOWLOntologyManager();
                this.setOntologyDocumentIRI(res, m.getOntologyDocumentIRI(source));
                OWLDocumentFormat format = m.getOntologyFormat(source);
                if (format != null) {
                    this.setOntologyFormat(res, format);
                }
            }
            Ontology ontology = res;
            return ontology;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    @Override
    public Ontology loadOntology(@Nonnull IRI source) throws OWLOntologyCreationException {
        this.getLock().writeLock().lock();
        try {
            Ontology ontology = this.load(source, this.getOntologyLoaderConfiguration(), false);
            return ontology;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ontology loadOntologyFromOntologyDocument(@Nonnull OWLOntologyDocumentSource source, @Nonnull OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        this.getLock().writeLock().lock();
        try {
            Ontology ontology = this.load(null, source, conf);
            return ontology;
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected Ontology load(IRI iri, OWLOntologyLoaderConfiguration conf, boolean allowExists) throws OWLOntologyCreationException {
        ID id = ID.create(Objects.requireNonNull(iri));
        Ontology res = this.getOntology(id);
        if (res != null) {
            return res;
        }
        Optional<OWLOntologyDocumentSource> source = this.findDocumentSource(id);
        if (source.isPresent()) {
            return this.load(iri, source.get(), conf);
        }
        IRI documentIRI = this.getDocumentIRIFromMappers(id);
        if (documentIRI == null) {
            throw new OntologyIRIMappingNotFoundException(iri);
        }
        Optional<Ontology> op = this.ontologyByDocumentIRI(documentIRI);
        if (op.isPresent() && !allowExists) {
            throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
        }
        if (op.isPresent()) {
            return op.get();
        }
        return this.load(iri, (OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI, null, null), conf);
    }

    protected Ontology load(@Nullable IRI iri, OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        this.listeners.fireStartedLoadingEvent(ID.create(iri), source.getDocumentIRI());
        Throwable ex = null;
        ID id = new ID();
        try {
            Ontology res = this.load(source, conf).get();
            id = res.getOntologyID();
            Ontology ontology = res;
            return ontology;
        }
        catch (OWLOntologyCreationException | UnloadableImportException e) {
            ex = e;
            throw e;
        }
        catch (OWLRuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OWLOntologyCreationException) {
                ex = (OWLOntologyCreationException)cause;
                throw (OWLOntologyCreationException)cause;
            }
            throw e;
        }
        finally {
            this.listeners.fireFinishedLoadingEvent(id, source.getDocumentIRI(), (Exception)ex);
        }
    }

    protected OntInfo load(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException, OWLOntologyFactoryNotFoundException {
        for (OWLOntologyFactory factory : this.getOntologyFactories()) {
            if (!factory.canAttemptLoading(source)) continue;
            try {
                Ontology res = this.getAdapter().asONT(factory).loadOntology(this, source, this.getAdapter().asONT(conf));
                OWLOntologyID id = res.getOntologyID();
                return this.content.get(id).orElseThrow(() -> new UnknownOWLOntologyException(id)).addDocumentIRI(source.getDocumentIRI());
            }
            catch (OWLOntologyRenameException e) {
                throw new OWLOntologyAlreadyExistsException(e.getOntologyID(), (Throwable)e);
            }
        }
        throw new OWLOntologyFactoryNotFoundException(source.getDocumentIRI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ontology loadImports(IRI declaration, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
        this.listeners.incrementImportsLoadCount();
        try {
            Ontology ontology = this.load(declaration, conf, true);
            return ontology;
        }
        catch (OWLOntologyCreationException e) {
            if (MissingImportHandlingStrategy.THROW_EXCEPTION.equals((Object)conf.getMissingImportHandlingStrategy())) {
                throw e;
            }
            MissingImportEvent evt = new MissingImportEvent(declaration, e);
            this.listeners.fireMissingImportEvent(evt);
        }
        finally {
            this.listeners.decrementImportsLoadCount();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeLoadImportRequest(@Nonnull OWLImportsDeclaration declaration, @Nonnull OWLOntologyLoaderConfiguration conf) {
        this.getLock().writeLock().lock();
        try {
            IRI dec = declaration.getIRI();
            if (conf.isIgnoredImport(dec)) {
                return;
            }
            if (this.importedOntology(dec).isPresent()) {
                return;
            }
            try {
                Ontology m = this.loadImports(dec, conf);
                if (m != null) {
                    this.content.get(m.getOntologyID()).ifPresent(i -> i.addImportDeclaration(dec));
                }
            }
            catch (OWLOntologyCreationException e) {
                throw new UnloadableImportException(e, declaration);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    public void saveOntology(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat ontologyFormat, final @Nonnull IRI documentIRI) throws OWLOntologyStorageException {
        if (!documentIRI.isAbsolute()) {
            throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
        }
        this.saveOntology(ontology, ontologyFormat, new OWLOntologyDocumentTarget(){

            public Optional<IRI> getDocumentIRI() {
                return Optional.of(documentIRI);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOntology(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat ontologyFormat, @Nonnull OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException {
        this.getLock().readLock().lock();
        try {
            this.write(ontology, ontologyFormat, documentTarget);
        }
        finally {
            this.getLock().readLock().unlock();
        }
    }

    public void write(OWLOntology ontology, OWLDocumentFormat doc, OWLOntologyDocumentTarget target) throws OWLOntologyStorageException {
        if (!(ontology instanceof Ontology)) {
            throw new OntApiException.Unsupported("Unsupported OWLOntology instance: " + this);
        }
        OntFormat format = OntApiException.notNull(OntFormat.get(doc), "Can't determine format: " + doc);
        Ontology ont = (Ontology)ontology;
        if (!format.isJena()) {
            this.getAdapter().asBaseModel(ont).getBase().clearCacheIfNeeded();
            try {
                for (OWLStorerFactory storer : this.getOntologyStorers()) {
                    OWLStorer writer = storer.createStorer();
                    if (!writer.canStoreOntology(doc)) continue;
                    writer.storeOntology((OWLOntology)ont, target, doc);
                    return;
                }
                throw new OWLStorerNotFoundException(doc);
            }
            catch (IOException e) {
                throw new OWLOntologyStorageIOException(e);
            }
        }
        OutputStream os = null;
        if (target.getOutputStream().isPresent()) {
            os = (OutputStream)target.getOutputStream().get();
        } else if (target.getDocumentIRI().isPresent()) {
            IRI iri = (IRI)target.getDocumentIRI().get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Save {} to {}", (Object)ont.getOntologyID(), (Object)iri);
            }
            try {
                os = OntologyManagerImpl.openStream(iri);
            }
            catch (IOException e) {
                throw new OWLOntologyStorageIOException(e);
            }
        } else if (target.getWriter().isPresent()) {
            os = new WriterOutputStream((Writer)target.getWriter().get(), StandardCharsets.UTF_8);
        }
        if (os == null) {
            throw new OWLOntologyStorageException("Null output stream, format = " + doc);
        }
        Object graph = ont.asGraphModel().getBaseGraph();
        if (doc.isPrefixOWLDocumentFormat()) {
            final PrefixMapping pm = OntGraphUtils.prefixMapping((PrefixManager)doc.asPrefixOWLDocumentFormat());
            graph = new WrappedGraph((Graph)graph){

                public PrefixMapping getPrefixMapping() {
                    return pm;
                }
            };
        }
        try {
            RDFDataMgr.write((OutputStream)os, (Graph)graph, (Lang)format.getLang());
        }
        catch (JenaException e) {
            throw new OWLOntologyStorageException("Can't save " + ont.getOntologyID() + ". Format=" + (Object)((Object)format), (Throwable)e);
        }
    }

    private static OutputStream openStream(IRI iri) throws IOException {
        if (OntConfig.DefaultScheme.FILE.same(iri)) {
            Path file = Paths.get(iri.toURI());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            return Files.newOutputStream(file, new OpenOption[0]);
        }
        URL url = iri.toURI().toURL();
        URLConnection conn = url.openConnection();
        return conn.getOutputStream();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.iris = this.createIRICache();
        this.content.values().forEach(info -> {
            ModelConfig conf = info.getModelConfig();
            BaseModel m = this.getAdapter().asBaseModel(info.get());
            m.setConfig(conf);
            UnionGraph baseGraph = m.getBase().getGraph();
            Stream<UnionGraph> imports = Graphs.getImports((Graph)baseGraph).stream().map(s -> this.content.values().map(OntInfo::get).map(BaseModel.class::cast).map(BaseModel::getBase).map(UnionModel::getGraph).filter(g -> Objects.equals(s, Graphs.getURI((Graph)g))).findFirst().orElse(null)).filter(Objects::nonNull);
            imports.forEach(baseGraph::addGraph);
            InternalModel baseModel = conf.createInternalModel((Graph)baseGraph);
            m.setBase(baseModel);
        });
    }

    public ModelConfig createModelConfig() {
        return new ModelConfig(this);
    }

    public class OntInfo
    implements HasOntologyID,
    Serializable {
        private static final long serialVersionUID = 5894845199098931128L;
        protected final Ontology ont;
        protected final ModelConfig conf;
        protected IRI documentIRI;
        protected IRI declarationIRI;
        protected OWLDocumentFormat format;

        public OntInfo(Ontology ont) throws ClassCastException {
            this.ont = Objects.requireNonNull(ont);
            OWLAdapter adapter = OntologyManagerImpl.this.getAdapter();
            this.conf = Objects.requireNonNull(adapter.asModelConfig(adapter.asBaseModel(ont).getConfig()));
        }

        public ID getOntologyID() {
            return OntologyManagerImpl.this.getAdapter().asONT(this.ont.getOntologyID());
        }

        public Ontology get() {
            return this.ont;
        }

        public OntInfo addFormat(OWLDocumentFormat format) {
            this.format = Objects.requireNonNull(format);
            return this;
        }

        public OntInfo addDocumentIRI(IRI iri) {
            this.documentIRI = Objects.requireNonNull(iri);
            return this;
        }

        public OntInfo addImportDeclaration(IRI declaration) {
            this.declarationIRI = Objects.requireNonNull(declaration);
            return this;
        }

        @Nullable
        public IRI getDocumentIRI() {
            return this.documentIRI;
        }

        @Nullable
        public OWLDocumentFormat getFormat() {
            return this.format;
        }

        @Nonnull
        public ModelConfig getModelConfig() {
            return this.conf;
        }

        public boolean hasImportDeclaration(IRI declaration) {
            if (Objects.equals(declaration, this.declarationIRI)) {
                return true;
            }
            ID id = this.getOntologyID();
            if (Objects.equals(declaration, id.getVersionIRI().orElse(null))) {
                return true;
            }
            IRI iri = id.getOntologyIRI().orElse(null);
            if (Objects.equals(declaration, iri)) {
                return OntologyManagerImpl.this.content.keys().filter(i -> i.matchOntology(iri)).count() == 1L;
            }
            return Objects.equals(declaration, this.documentIRI);
        }
    }

    protected static class ListenersHolder
    implements Serializable {
        private static final String BAD_LISTENER = "BADLY BEHAVING LISTENER: {} has been removed";
        private static final long serialVersionUID = 6728609023804778746L;
        protected final List<MissingImportListener> missingImportsListeners = new ArrayList<MissingImportListener>();
        protected final List<OWLOntologyLoaderListener> loaderListeners = new ArrayList<OWLOntologyLoaderListener>();
        protected final List<OWLOntologyChangeProgressListener> progressListeners = new ArrayList<OWLOntologyChangeProgressListener>();
        protected transient List<OWLOntologyChangesVetoedListener> vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
        protected transient Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = new HashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
        protected transient Map<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy> impendingChangeListenerMap = new HashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
        protected ImpendingOWLOntologyChangeBroadcastStrategy defaultImpendingChangeBroadcastStrategy = new DefaultImpendingChangeBroadcastStrategy();
        protected OWLOntologyChangeBroadcastStrategy defaultChangeBroadcastStrategy = new DefaultChangeBroadcastStrategy();
        protected final AtomicInteger loadCount = new AtomicInteger();
        protected final AtomicInteger importsLoadCount = new AtomicInteger();
        protected final AtomicBoolean broadcastChanges = new AtomicBoolean(true);

        protected ListenersHolder() {
        }

        public void addMissingImportListener(@Nonnull MissingImportListener listener) {
            this.missingImportsListeners.add(listener);
        }

        public void removeMissingImportListener(@Nonnull MissingImportListener listener) {
            this.missingImportsListeners.remove(listener);
        }

        public void addOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
            this.loaderListeners.add(listener);
        }

        public void removeOntologyLoaderListener(@Nonnull OWLOntologyLoaderListener listener) {
            this.loaderListeners.remove(listener);
        }

        public void addOntologyChangeProgressListener(@Nonnull OWLOntologyChangeProgressListener listener) {
            this.progressListeners.add(listener);
        }

        public void removeOntologyChangeProgressListener(@Nonnull OWLOntologyChangeProgressListener listener) {
            this.progressListeners.remove(listener);
        }

        public void addOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
            this.vetoListeners.add(listener);
        }

        public void removeOntologyChangesVetoedListener(@Nonnull OWLOntologyChangesVetoedListener listener) {
            this.vetoListeners.remove(listener);
        }

        public void setDefaultChangeBroadcastStrategy(@Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
            this.defaultChangeBroadcastStrategy = strategy;
        }

        public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
            this.addOntologyChangeListener(listener, this.defaultChangeBroadcastStrategy);
        }

        public void addOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener, @Nonnull OWLOntologyChangeBroadcastStrategy strategy) {
            this.listenerMap.put(listener, strategy);
        }

        public void removeOntologyChangeListener(@Nonnull OWLOntologyChangeListener listener) {
            this.listenerMap.remove(listener);
        }

        public void addImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
            this.impendingChangeListenerMap.put(listener, this.defaultImpendingChangeBroadcastStrategy);
        }

        public void removeImpendingOntologyChangeListener(@Nonnull ImpendingOWLOntologyChangeListener listener) {
            this.impendingChangeListenerMap.remove(listener);
        }

        protected int incrementImportsLoadCount() {
            return this.importsLoadCount.incrementAndGet();
        }

        protected int decrementImportsLoadCount() {
            return this.importsLoadCount.decrementAndGet();
        }

        protected void fireMissingImportEvent(MissingImportEvent evt) {
            this.missingImportsListeners.forEach(l -> l.importMissing(evt));
        }

        protected void fireStartedLoadingEvent(OWLOntologyID id, IRI doc, boolean imported) {
            for (OWLOntologyLoaderListener listener : this.loaderListeners) {
                listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(id, doc, imported));
            }
        }

        protected void fireStartedLoadingEvent(OWLOntologyID id, IRI doc) {
            if (this.loadCount.get() != this.importsLoadCount.get()) {
                LOGGER.debug("[{} => {}] Runtime Warning: Parsers should load imported ontologies using the makeImportLoadRequest method.", (Object)doc, (Object)id);
            }
            this.fireStartedLoadingEvent(id, doc, this.loadCount.get() > 0);
            this.loadCount.incrementAndGet();
            this.broadcastChanges.set(false);
        }

        protected void fireFinishedLoadingEvent(OWLOntologyID id, IRI doc, boolean imported, @Nullable Exception ex) {
            for (OWLOntologyLoaderListener listener : this.loaderListeners) {
                listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(id, doc, imported, ex));
            }
        }

        protected void fireFinishedLoadingEvent(OWLOntologyID id, IRI doc, @Nullable Exception ex) {
            if (this.loadCount.decrementAndGet() == 0) {
                this.broadcastChanges.set(true);
            }
            this.fireFinishedLoadingEvent(id, doc, this.loadCount.get() > 0, ex);
        }

        protected void fireBeginChanges(int size) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.begin(size);
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }

        protected void fireEndChanges() {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.end();
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }

        protected void fireChangeApplied(OWLOntologyChange change) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            if (this.progressListeners.isEmpty()) {
                return;
            }
            for (OWLOntologyChangeProgressListener listener : this.progressListeners) {
                try {
                    listener.appliedChange(change);
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.progressListeners.remove(listener);
                }
            }
        }

        protected void broadcastOntologyChangesVetoed(List<? extends OWLOntologyChange> changes, OWLOntologyChangeVetoException veto) {
            this.vetoListeners.forEach(l -> l.ontologyChangesVetoed(changes, veto));
        }

        protected void broadcastChanges(List<? extends OWLOntologyChange> changes) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
                OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
                if (strategy == null) continue;
                try {
                    strategy.broadcastChanges(listener, changes);
                }
                catch (Exception e) {
                    LOGGER.warn(BAD_LISTENER, (Object)e.getMessage(), (Object)e);
                    this.listenerMap.remove(listener);
                }
            }
        }

        protected void broadcastImpendingChanges(List<? extends OWLOntologyChange> changes) {
            if (!this.broadcastChanges.get()) {
                return;
            }
            for (ImpendingOWLOntologyChangeListener listener : new ArrayList<ImpendingOWLOntologyChangeListener>(this.impendingChangeListenerMap.keySet())) {
                ImpendingOWLOntologyChangeBroadcastStrategy strategy = this.impendingChangeListenerMap.get(listener);
                if (strategy == null) continue;
                strategy.broadcastChanges(listener, changes);
            }
        }

        public void clear() {
            this.loaderListeners.clear();
            this.missingImportsListeners.clear();
            this.progressListeners.clear();
            this.vetoListeners.clear();
            this.listenerMap.clear();
            this.impendingChangeListenerMap.clear();
            this.broadcastChanges.set(true);
            this.loadCount.set(0);
            this.importsLoadCount.set(0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.listenerMap = new HashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
            this.impendingChangeListenerMap = new HashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
            this.vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();
        }
    }
}

