/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OWLAdapter;
import com.github.owlcs.ontapi.OWLFactoryWrapper;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.OntGraphDocumentSource;
import com.github.owlcs.ontapi.OntGraphUtils;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyCreator;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyFactoryImpl;
import com.github.owlcs.ontapi.OntologyLoader;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.RWLockedCollection;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.transforms.GraphStats;
import com.github.owlcs.ontapi.transforms.TransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoaderImpl
implements OntologyFactory.Loader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologyLoaderImpl.class);
    protected final OntologyLoader alternative;
    protected Map<String, GraphInfo> graphs = new LinkedHashMap<String, GraphInfo>();
    protected Map<IRI, Optional<IRI>> sourceMap = new HashMap<IRI, Optional<IRI>>();
    protected Map<IRI, GraphInfo> loaded = new HashMap<IRI, GraphInfo>();

    public OntologyLoaderImpl(OntologyLoader alternative) {
        this.alternative = alternative;
    }

    @Override
    public OWLAdapter getAdapter() {
        return OWLAdapter.get();
    }

    @Override
    public OntologyFactory asOntologyFactory(@Nonnull OntologyCreator builder) {
        return new OntologyFactoryImpl(this.getAdapter().asBuilder(builder), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ontology loadOntology(OntologyCreator builder, OntologyManager manager, OWLOntologyDocumentSource source, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        if (config.isUseOWLParsersToLoad()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Load ontology using OWL-API methods. Source [{}]{}", (Object)source.getClass().getSimpleName(), (Object)source.getDocumentIRI());
            }
            return OntApiException.mustNotBeNull(this.alternative, "No OWL loader found.").loadOntology(builder, manager, source, config);
        }
        try {
            GraphInfo primary = this.loadGraph(source, builder, manager, config);
            this.graphs.put(primary.getURI(), primary);
            Ontology res = OntApiException.notNull(this.createModel(primary, builder, manager, config), "Should never happen");
            List graphs = this.graphs.keySet().stream().filter(u -> !Objects.equals(u, primary.getURI())).map(k -> this.graphs.get(k)).collect(Collectors.toList());
            for (GraphInfo g : graphs) {
                this.createModel(g, builder, manager, config);
            }
            Ontology ontology = res;
            return ontology;
        }
        finally {
            this.clear();
        }
    }

    public void clear() {
        this.graphs.clear();
        this.sourceMap.clear();
        this.loaded.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Ontology createModel(GraphInfo info, OntologyCreator builder, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        if (!info.isFresh()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The ontology {} is already configured.", (Object)info.name());
            }
            return null;
        }
        try {
            UnionGraph graph;
            Ontology res;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Set up ontology model {}.", (Object)info.name());
            }
            if (manager.contains(res = builder.createOntology((Graph)(graph = this.makeUnionGraph(info, builder, manager, config)), manager, config))) {
                throw new OWLOntologyAlreadyExistsException(res.getOntologyID());
            }
            if (!info.isAnonymous()) {
                OntModels.insert(manager::models, res.asGraphModel(), false);
            }
            this.getAdapter().asHandler(manager).ontologyCreated((OWLOntology)res);
            OntFormat format = OntApiException.notNull(info.getFormat(), "Null format while loading " + info.name());
            OWLDocumentFormat owl = format.newOWLFormat();
            if (owl.isPrefixOWLDocumentFormat()) {
                PrefixDocumentFormat pm = owl.asPrefixOWLDocumentFormat();
                graph.getPrefixMapping().getNsPrefixMap().forEach((arg_0, arg_1) -> ((PrefixManager)pm).setPrefix(arg_0, arg_1));
            }
            owl.setOntologyLoaderMetaData(OntGraphUtils.makeParserMetaData((Graph)graph, info.getStats()));
            manager.setOntologyFormat(res, owl);
            if (info.getSource() != null) {
                manager.setOntologyDocumentIRI(res, info.getSource());
            }
            Ontology ontology = res;
            return ontology;
        }
        finally {
            info.setProcessed();
        }
    }

    protected UnionGraph makeUnionGraph(GraphInfo info, OntologyCreator builder, OntologyManager manager, OntLoaderConfiguration config) throws OntologyFactoryImpl.OWLTransformException {
        GraphStats stats;
        boolean isPrimary = this.graphs.size() == 1;
        UnionGraph graph = this.makeUnionGraph(info, new HashSet<String>(), builder, manager, config);
        if (!isPrimary || info.noTransforms() || !config.isPerformTransformation()) {
            return graph;
        }
        Set<Graph> transformed = this.graphs.values().stream().filter(g -> !g.isFresh() || g.noTransforms()).map(GraphInfo::getGraph).collect(Collectors.toSet());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Perform graph transformations on <{}>.", (Object)info.name());
        }
        try {
            stats = config.getGraphTransformers().transform((Graph)graph, transformed);
        }
        catch (TransformException t) {
            throw new OntologyFactoryImpl.OWLTransformException(t);
        }
        info.setStats(stats);
        stats.stats(true).filter(GraphStats::isNotEmpty).forEach(s -> {
            String uri = Graphs.getURI(s.getGraph());
            if (uri == null) {
                LOGGER.warn("Not a named graph {}", (Object)Graphs.getName(s.getGraph()));
                return;
            }
            GraphInfo g = this.graphs.get(uri);
            if (g == null) {
                LOGGER.warn("Unable to find a graph for {}", (Object)Graphs.getName(s.getGraph()));
                return;
            }
            g.setStats((GraphStats)s);
        });
        return graph;
    }

    protected UnionGraph makeUnionGraph(GraphInfo node, Collection<String> seen, OntologyCreator builder, OntologyManager manager, OntLoaderConfiguration config) {
        Graph graph = node.getGraph();
        if (graph instanceof UnionGraph) {
            UnionGraph u = (UnionGraph)graph;
            if (!u.getUnderlying().isEmpty()) {
                throw new OntApiException.IllegalState("A given graph has a hierarchy structure: " + graph);
            }
            graph = u.getBaseGraph();
        }
        UnionGraph res = builder.createUnionGraph(graph, config);
        if (config.isProcessImports()) {
            this.processImports(node, seen, builder, manager, config).forEach(ch -> res.addGraph((Graph)this.makeUnionGraph((GraphInfo)ch, (Collection<String>)new HashSet<String>(seen), builder, manager, config)));
        }
        return res;
    }

    protected Collection<GraphInfo> processImports(GraphInfo node, Collection<String> seen, OntologyCreator builder, OntologyManager manager, OntLoaderConfiguration config) {
        Graph base = node.getGraph();
        String name = node.name();
        seen.add(node.getURI());
        LinkedHashSet<GraphInfo> res = new LinkedHashSet<GraphInfo>();
        List imports = node.getImports().stream().sorted().collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < imports.size(); ++i) {
            String uri = (String)imports.get(i);
            if (seen.contains(uri)) continue;
            OWLImportsDeclaration declaration = manager.getOWLDataFactory().getOWLImportsDeclaration(IRI.create((String)uri));
            if (config.isIgnoredImport(declaration.getIRI())) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("{}: {} is ignored.", (Object)name, (Object)declaration);
                continue;
            }
            GraphInfo info = this.graphs.get(uri);
            try {
                if (info == null) {
                    info = this.fetchGraph(uri, builder, manager, config);
                }
                this.graphs.put(uri, info);
                if (info.isAnonymous() && MissingOntologyHeaderStrategy.INCLUDE_GRAPH.equals((Object)config.getMissingOntologyHeaderStrategy())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("<{}>: remove import declaration <{}>.", (Object)name, (Object)uri);
                    }
                    base.remove(Node.ANY, OWL.imports.asNode(), NodeFactory.createURI((String)uri));
                    GraphUtil.addInto((Graph)base, (Graph)info.getGraph());
                    info.setProcessed();
                    imports.addAll(i + 1, info.getImports());
                    continue;
                }
                res.add(info);
                continue;
            }
            catch (OWLOntologyCreationException e) {
                if (MissingImportHandlingStrategy.THROW_EXCEPTION.equals((Object)config.getMissingImportHandlingStrategy())) {
                    throw new UnloadableImportException(e, declaration);
                }
                LOGGER.warn("Ontology <{}>: can't read sub graph with {}. Exception: '{}'", new Object[]{name, declaration, e.getMessage()});
            }
        }
        return res;
    }

    protected GraphInfo fetchGraph(String uri, OntologyCreator builder, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        IRI ontologyIRI = IRI.create((String)uri);
        Ontology res = this.findModel(manager, ontologyIRI);
        if (res != null) {
            return this.toGraphInfo(res, null);
        }
        IRI documentIRI = this.documentIRI(manager, ontologyIRI).orElse(ontologyIRI);
        res = this.findModel(manager, documentIRI);
        if (res != null) {
            return this.toGraphInfo(res, null);
        }
        OWLOntologyDocumentSource source = manager.getDocumentSourceMappers().stream().map(f -> f.map(ontologyIRI)).filter(Objects::nonNull).findFirst().orElse((OWLOntologyDocumentSource)new IRIDocumentSource(documentIRI));
        return this.loadGraph(source, builder, manager, config);
    }

    protected Ontology findModel(OntologyManager m, IRI iri) {
        Ontology res = m.getOntology(ID.create(iri));
        if (res != null) {
            return res;
        }
        if (iri.toString().startsWith("file://")) {
            iri = IRI.create((String)iri.toString().replaceAll("/+", "/"));
            return m.getOntology(ID.create(iri));
        }
        return null;
    }

    private Optional<IRI> documentIRI(OntologyManager manager, IRI source) {
        Optional<IRI> res = this.sourceMap.get(source);
        if (res != null) {
            this.sourceMap.remove(source);
        } else {
            res = this.getAdapter().asIMPL(manager).mapIRI(source);
            this.sourceMap.put(source, res);
        }
        return res;
    }

    protected GraphInfo toGraphInfo(Ontology model, IRI src) {
        OWLDocumentFormat owl = model.getOWLOntologyManager().getOntologyFormat(model);
        Graph graph = model.asGraphModel().getBaseGraph();
        OntFormat format = null;
        if (owl != null) {
            format = OntFormat.get(owl);
            if (src != null && owl.isPrefixOWLDocumentFormat()) {
                graph.getPrefixMapping().setNsPrefixes(OntGraphUtils.prefixMapping((PrefixManager)owl.asPrefixOWLDocumentFormat()));
            }
        }
        return this.createGraphInfo(graph, format, src, false);
    }

    protected GraphInfo createGraphInfo(Graph graph, OntFormat format, IRI src, boolean withTransform) {
        return new GraphInfo(graph, format, src, withTransform);
    }

    public GraphInfo loadGraph(OWLOntologyDocumentSource source, OntologyCreator builder, OntologyManager manager, OntLoaderConfiguration config) throws OWLOntologyCreationException {
        if (source instanceof OntGraphDocumentSource) {
            OntGraphDocumentSource src = (OntGraphDocumentSource)source;
            Graph graph = src.getGraph();
            OntFormat format = src.getOntFormat();
            return this.createGraphInfo(graph, format, source.getDocumentIRI(), src.withTransforms());
        }
        if (this.loaded.containsKey(source.getDocumentIRI())) {
            return this.loaded.get(source.getDocumentIRI());
        }
        IRI doc = source.getDocumentIRI();
        OWLOntologyDocumentSource src = this.documentIRI(manager, doc).map(IRIDocumentSource::new).map(OWLOntologyDocumentSource.class::cast).orElse(source);
        try {
            Graph graph = builder.createGraph();
            OntFormat format = OntGraphUtils.readGraph(graph, src, config);
            GraphInfo res = this.createGraphInfo(graph, format, doc, true);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Graph <{}> is loaded by jena. Source: {}[{}]. Format: {}", new Object[]{res.name(), source.getClass().getSimpleName(), res.getSource(), res.getFormat()});
            }
            return res;
        }
        catch (OntologyFactoryImpl.UnsupportedFormatException jenaEx) {
            if (this.alternative == null) {
                throw jenaEx;
            }
            if (source.getFormat().map(OntFormat::get).filter(OntFormat::isJena).isPresent()) {
                if (jenaEx.getSuppressed().length == 1) {
                    LOGGER.warn("Jena loading fail: {}", (Object)jenaEx.getSuppressed()[0].getMessage());
                } else {
                    LOGGER.warn("Jena loading fail!", (Throwable)((Object)jenaEx));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                String msg = jenaEx.getMessage();
                if (jenaEx.getCause() != null) {
                    msg = msg + " => " + jenaEx.getCause().getMessage();
                }
                LOGGER.debug("Can't load using Apache Jena: {}. Try OWL-API mechanisms.", (Object)msg);
            }
            OntologyCreator _builder = this.createBuilderFrom(this.alternative, builder);
            OntLoaderConfiguration _config = this.createConfigFrom(this.alternative, config);
            OntologyManagerImpl _manager = this.createLoadCopy(_builder, manager, config);
            try {
                Ontology ont = this.alternative.loadOntology(_builder, _manager, src, _config);
                ont.imports().forEach(o -> _manager.documentIRIByOntology((OWLOntology)o).ifPresent(iri -> this.loaded.put((IRI)iri, this.toGraphInfo(this.getAdapter().asONT((OWLOntology)o), (IRI)iri))));
                GraphInfo res = this.toGraphInfo(ont, doc);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Graph <{}> is loaded by OWL-API. Source: {}[{}]. Format: {}", new Object[]{res.name(), source.getClass().getSimpleName(), res.getSource(), res.getFormat()});
                }
                return res;
            }
            catch (OWLOntologyCreationException owlEx) {
                owlEx.addSuppressed((Throwable)((Object)jenaEx));
                throw owlEx;
            }
        }
    }

    protected OntologyCreator createBuilderFrom(OntologyLoader loader, OntologyCreator from) {
        return loader instanceof OWLFactoryWrapper ? ((OWLFactoryWrapper)loader).optimize(from) : from;
    }

    protected OntLoaderConfiguration createConfigFrom(OntologyLoader loader, OntLoaderConfiguration from) {
        return loader instanceof OWLFactoryWrapper ? ((OWLFactoryWrapper)loader).optimize(from) : from;
    }

    protected OntologyManagerImpl createLoadCopy(OntologyCreator builder, OntologyManager from, final OntLoaderConfiguration defaultConfig) {
        final OntologyManagerImpl delegate = this.getAdapter().asIMPL(from);
        OntologyFactory factory = this.asOntologyFactory(builder);
        return new OntologyManagerImpl(delegate.getOWLDataFactory(), factory, null){

            @Override
            protected Optional<Ontology> ontology(OWLOntologyID id) {
                Optional<Ontology> res = delegate.ontology(id);
                return res.isPresent() ? res : super.ontology(id);
            }

            @Override
            protected Optional<Ontology> importedOntology(IRI declaration) {
                Optional<Ontology> res = delegate.importedOntology(declaration);
                return res.isPresent() ? res : super.importedOntology(declaration);
            }

            @Override
            protected Ontology loadImports(IRI declaration, OWLOntologyLoaderConfiguration conf) throws OWLOntologyCreationException {
                return super.loadImports(declaration, this.makeImportConfig(conf));
            }

            private OntLoaderConfiguration makeImportConfig(OWLOntologyLoaderConfiguration conf) {
                return conf instanceof OntLoaderConfiguration ? (OntLoaderConfiguration)conf : (defaultConfig == null ? delegate.getOntologyConfigurator().buildLoaderConfiguration() : defaultConfig);
            }

            @Override
            public boolean hasOntology(OWLOntology ontology) {
                return delegate.hasOntology(ontology) || super.hasOntology(ontology);
            }

            @Override
            protected Optional<IRI> documentIRIByOntology(OWLOntology ontology) {
                Optional<IRI> res = delegate.documentIRIByOntology(ontology);
                return res.isPresent() ? res : super.documentIRIByOntology(ontology);
            }

            @Override
            protected Optional<Ontology> ontologyByDocumentIRI(IRI iri) {
                Optional<Ontology> res = delegate.ontologyByDocumentIRI(iri);
                return res.isPresent() ? res : super.ontologyByDocumentIRI(iri);
            }

            @Override
            protected Optional<IRI> mapIRI(IRI iri) {
                return OntologyLoaderImpl.this.documentIRI(delegate, iri);
            }

            @Override
            public RWLockedCollection<OWLParserFactory> getOntologyParsers() {
                return delegate.getOntologyParsers();
            }

            @Override
            public OntConfig getOntologyConfigurator() {
                return delegate.getOntologyConfigurator();
            }

            @Override
            public OntLoaderConfiguration getOntologyLoaderConfiguration() {
                return delegate.getOntologyLoaderConfiguration();
            }

            public String toString() {
                return "CopyOf-" + delegate.toString();
            }
        };
    }

    public static class GraphInfo {
        private final OntFormat format;
        private final Graph graph;
        private final IRI source;
        private boolean fresh;
        private boolean transforms;
        private Node ontology;
        private Set<String> imports;
        private GraphStats stats;

        protected GraphInfo(Graph graph, OntFormat format, IRI source, boolean withTransforms) {
            this.graph = graph;
            this.format = format;
            this.source = source;
            this.fresh = source != null;
            this.transforms = withTransforms;
        }

        protected Node ontology() {
            return this.ontology == null ? (this.ontology = Graphs.ontologyNode(Graphs.getBase(this.graph)).orElse(NodeFactory.createVariable((String)"NullOntology"))) : this.ontology;
        }

        public String getURI() {
            return this.ontology().isURI() ? this.ontology().getURI() : null;
        }

        public boolean isAnonymous() {
            return this.getURI() == null;
        }

        protected String name() {
            return this.ontology().toString();
        }

        protected Set<String> getImports() {
            return this.imports == null ? (this.imports = Graphs.getImports(this.graph)) : this.imports;
        }

        protected boolean isFresh() {
            return this.fresh;
        }

        protected boolean noTransforms() {
            return !this.transforms;
        }

        protected void setProcessed() {
            this.fresh = false;
        }

        protected OntFormat getFormat() {
            return this.format;
        }

        public Graph getGraph() {
            return this.graph;
        }

        protected IRI getSource() {
            return this.source;
        }

        public GraphStats getStats() {
            return this.stats;
        }

        protected void setStats(GraphStats stats) {
            this.stats = Objects.requireNonNull(stats, "Null transform stats");
        }
    }
}

