/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OntologyCollection;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyCollectionImpl<O extends HasOntologyID>
implements OntologyCollection<O>,
Serializable {
    private static final long serialVersionUID = 3693502109998760296L;
    protected final Map<OWLOntologyID, O> map;
    protected final ReadWriteLock lock;

    public OntologyCollectionImpl() {
        this(NoOpReadWriteLock.NO_OP_RW_LOCK);
    }

    public OntologyCollectionImpl(ReadWriteLock lock) {
        this(lock, OntologyCollectionImpl.createMap(lock));
    }

    public OntologyCollectionImpl(ReadWriteLock lock, Collection<O> list) throws IllegalArgumentException, NullPointerException {
        this(lock, Iter.toMap(Iter.create(list), HasOntologyID::getOntologyID, Function.identity(), (s, v) -> {
            throw new IllegalArgumentException("Duplicate key-id " + s);
        }, () -> OntologyCollectionImpl.createMap(lock)));
    }

    protected OntologyCollectionImpl(ReadWriteLock lock, Map<OWLOntologyID, O> map) {
        this.map = Objects.requireNonNull(map, "Null ontology map");
        this.lock = Objects.requireNonNull(lock, "Null lock");
    }

    public static <K, V> Map<K, V> createMap(ReadWriteLock lock) {
        return NoOpReadWriteLock.isConcurrent(lock) ? new ConcurrentHashMap() : new HashMap();
    }

    @Override
    public long size() {
        this.lock.readLock().lock();
        try {
            long l = this.map.size();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public OntologyCollectionImpl<O> clear() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
            OntologyCollectionImpl ontologyCollectionImpl = this;
            return ontologyCollectionImpl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Stream<O> values() {
        this.lock.readLock().lock();
        try {
            Stream<O> stream = this.map.values().stream();
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<O> get(OWLOntologyID key) {
        this.lock.readLock().lock();
        try {
            HasOntologyID res = (HasOntologyID)this.map.get(key);
            if (res != null) {
                if (key.equals((Object)res.getOntologyID())) {
                    Optional<HasOntologyID> optional = Optional.of(res);
                    return optional;
                }
                this.replace(key, res);
            }
            if ((res = (HasOntologyID)this.findValue(key).orElse(null)) != null) {
                this.replace(key, res);
                Optional<HasOntologyID> optional = Optional.of(res);
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public OntologyCollectionImpl<O> add(O value) {
        this.lock.writeLock().lock();
        try {
            this.put(value);
            OntologyCollectionImpl ontologyCollectionImpl = this;
            return ontologyCollectionImpl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<O> remove(OWLOntologyID key) {
        this.lock.writeLock().lock();
        try {
            Optional<O> res = this.get(key);
            res.ifPresent(k -> {
                HasOntologyID cfr_ignored_0 = (HasOntologyID)this.map.remove(k.getOntologyID());
            });
            Optional<O> optional = res;
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public OntologyCollectionImpl<O> delete(O value) {
        this.lock.writeLock().lock();
        try {
            this.findKey(value).ifPresent(this.map::remove);
            OntologyCollectionImpl ontologyCollectionImpl = this;
            return ontologyCollectionImpl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void replace(OWLOntologyID oldKey, O newValue) {
        this.map.remove(oldKey);
        this.put(newValue);
    }

    protected void put(O value) {
        this.findKey(value).ifPresent(this.map::remove);
        this.map.put(value.getOntologyID(), value);
    }

    protected Optional<O> findValue(OWLOntologyID key) {
        return this.map.values().stream().filter(o -> o.getOntologyID().hashCode() == key.hashCode() && key.equals((Object)o.getOntologyID())).findFirst();
    }

    protected Optional<OWLOntologyID> findKey(O value) {
        return this.map.entrySet().stream().filter(x -> ((HasOntologyID)x.getValue()).equals(value)).map(Map.Entry::getKey).findFirst();
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.values().map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

