/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nullable;

public final class NoOpReadWriteLock
implements ReadWriteLock,
Serializable {
    public static final Condition NO_OP_CONDITION = new NoOpCondition();
    public static final Lock NO_OP_LOCK = new NoOpLock();
    public static final ReadWriteLock NO_OP_RW_LOCK = new NoOpReadWriteLock();

    private NoOpReadWriteLock() {
    }

    public static boolean isConcurrent(ReadWriteLock lock) {
        return null != lock && NO_OP_RW_LOCK != lock;
    }

    @Override
    public Lock readLock() {
        return NO_OP_LOCK;
    }

    @Override
    public Lock writeLock() {
        return NO_OP_LOCK;
    }

    private Object readResolve() throws ObjectStreamException {
        return NO_OP_RW_LOCK;
    }

    private static class NoOpCondition
    implements Condition,
    Serializable {
        private NoOpCondition() {
        }

        @Override
        public void await() {
        }

        @Override
        public void awaitUninterruptibly() {
        }

        @Override
        public long awaitNanos(long nanosTimeout) {
            return 0L;
        }

        @Override
        public boolean await(long time, @Nullable TimeUnit unit) {
            return true;
        }

        @Override
        public boolean awaitUntil(@Nullable Date deadline) {
            return true;
        }

        @Override
        public void signal() {
        }

        @Override
        public void signalAll() {
        }
    }

    private static class NoOpLock
    implements Lock,
    Serializable {
        private NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, @Nullable TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return NO_OP_CONDITION;
        }
    }
}

