/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.AsNode;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.jena.model.OntID;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class ID
extends OWLOntologyID
implements AsNode {
    protected final Node node;

    public ID(String iri) {
        this(iri, null);
    }

    public ID(String iri, String ver) {
        this(NodeFactory.createURI((String)Objects.requireNonNull(iri, "Null iri")), ver);
    }

    public ID() {
        this(NodeFactory.createBlankNode(), null);
    }

    public ID(OntID id) {
        this(id.asNode(), id.getVersionIRI());
    }

    protected ID(Node id, String version) throws OntApiException, IllegalStateException, NullPointerException {
        Optional<Object> versionIRI;
        Optional<Object> ontologyIRI;
        Optional<Object> internalID;
        if (Objects.requireNonNull(id, "Null id node").isBlank()) {
            if (version != null) {
                throw new OntApiException.IllegalArgument("Anonymous ontology id (" + id + ") can not be accompanied by a version (" + version + ")");
            }
            internalID = Optional.of(id.getBlankNodeLabel());
            ontologyIRI = Optional.empty();
            versionIRI = Optional.empty();
        } else if (id.isURI()) {
            internalID = Optional.empty();
            ontologyIRI = Optional.of(id.getURI()).map(IRI::create);
            versionIRI = Optional.ofNullable(version).map(IRI::create);
        } else {
            throw new OntApiException.IllegalArgument("Illegal node is given: " + id + " - it must be either URI or Blank resource.");
        }
        this.node = id;
        int hashCode = 17;
        hashCode += 37 * internalID.hashCode();
        hashCode += 37 * ontologyIRI.hashCode();
        this.setField("hashCode", hashCode += 37 * versionIRI.hashCode());
        this.setField("internalID", internalID);
        this.setField("ontologyIRI", ontologyIRI);
        this.setField("versionIRI", versionIRI);
    }

    private void setField(String name, Object value) {
        try {
            Field field = this.getClass().getSuperclass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Can't get access to " + name, e);
        }
    }

    @Override
    public Node asNode() {
        return this.node;
    }

    public static ID asONT(OWLOntologyID id) throws IllegalArgumentException {
        if (id instanceof ID) {
            return (ID)id;
        }
        if (id.isAnonymous()) {
            return new ID();
        }
        String iri = id.getOntologyIRI().map(IRI::getIRIString).orElseThrow(IllegalArgumentException::new);
        String ver = id.getVersionIRI().map(IRI::getIRIString).orElse(null);
        return ID.create(iri, ver);
    }

    public static ID create(IRI iri) {
        return ID.create(iri == null ? null : iri.getIRIString(), null);
    }

    public static ID create(String iri, String ver) {
        return iri == null ? new ID() : new ID(iri, ver);
    }
}

