/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.owlapi.InternalizedEntities;
import com.github.owlcs.ontapi.owlapi.OWLImportsDeclarationImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLAnnotationAssertionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLAnnotationPropertyDomainAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLAnnotationPropertyRangeAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLAsymmetricObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLClassAssertionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDataPropertyAssertionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDataPropertyDomainAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDataPropertyRangeAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDatatypeDefinitionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDeclarationAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDifferentIndividualsAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDisjointClassesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDisjointDataPropertiesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDisjointObjectPropertiesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLDisjointUnionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLEquivalentClassesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLEquivalentDataPropertiesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLEquivalentObjectPropertiesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLFunctionalDataPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLFunctionalObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLHasKeyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLInverseFunctionalObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLInverseObjectPropertiesAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLIrreflexiveObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLNegativeDataPropertyAssertionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLNegativeObjectPropertyAssertionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLObjectPropertyAssertionAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLObjectPropertyDomainAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLObjectPropertyRangeAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLReflexiveObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSameIndividualAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSubAnnotationPropertyOfAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSubClassOfAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSubDataPropertyOfAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSubObjectPropertyOfAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSubPropertyChainAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLSymmetricObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.OWLTransitiveObjectPropertyAxiomImpl;
import com.github.owlcs.ontapi.owlapi.axioms.SWRLRuleImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnnotationImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnnotationImplNotAnnotated;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLFacetRestrictionImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLObjectInverseOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLDataAllValuesFromImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLDataExactCardinalityImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLDataHasValueImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLDataMaxCardinalityImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLDataMinCardinalityImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLDataSomeValuesFromImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectAllValuesFromImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectComplementOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectExactCardinalityImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectHasSelfImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectHasValueImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectIntersectionOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectMaxCardinalityImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectMinCardinalityImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectOneOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectSomeValuesFromImpl;
import com.github.owlcs.ontapi.owlapi.objects.ce.OWLObjectUnionOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.dr.OWLDataComplementOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.dr.OWLDataIntersectionOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.dr.OWLDataOneOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.dr.OWLDataUnionOfImpl;
import com.github.owlcs.ontapi.owlapi.objects.dr.OWLDatatypeRestrictionImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLAnnotationPropertyImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLClassImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLDataPropertyImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLDatatypeImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLNamedIndividualImpl;
import com.github.owlcs.ontapi.owlapi.objects.entity.OWLObjectPropertyImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLBuiltInAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLClassAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLDataPropertyAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLDataRangeAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLDifferentIndividualsAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLIndividualArgumentImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLLiteralArgumentImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLObjectPropertyAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLSameIndividualAtomImpl;
import com.github.owlcs.ontapi.owlapi.objects.swrl.SWRLVariableImpl;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.impl.LiteralLabel;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.providers.DatatypeProvider;
import org.semanticweb.owlapi.model.providers.EntityProvider;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class DataFactoryImpl
implements DataFactory {
    private static final long serialVersionUID = -4032031232398404873L;
    private static final String LEXICAL_VALUE_CANNOT_BE_NULL = "lexicalValue cannot be null";
    private static final String LITERAL_CANNOT_BE_NULL = "literal cannot be null";
    private static final String LITERALS_CANNOT_BE_NULL = "literals cannot be null";
    private static final String VAR_CANNOT_BE_NULL = "var cannot be null";
    private static final String BUILT_IN_IRI_CANNOT_BE_NULL = "builtInIRI cannot be null";
    private static final String ARGS_CANNOT_BE_NULL = "args cannot be null";
    private static final String ARG1_CANNOT_BE_NULL = "arg1 cannot be null";
    private static final String ARG0_CANNOT_BE_NULL = "arg0 cannot be null";
    private static final String ARG_CANNOT_BE_NULL = "arg cannot be null";
    private static final String PREDICATE_CANNOT_BE_NULL = "predicate cannot be null";
    private static final String HEAD_CANNOT_BE_NULL = "head cannot be null";
    private static final String BODY_CANNOT_BE_NULL = "body cannot be null";
    private static final String ANNOTATION_CANNOT_BE_NULL = "annotation cannot be null";
    private static final String OWL_CLASS_CANNOT_BE_NULL = "class cannot be null";
    private static final String CHAIN_CANNOT_BE_NULL = "chain cannot be null";
    private static final String INVERSE_PROPERTY_CANNOT_BE_NULL = "inverseProperty cannot be null";
    private static final String FORWARD_PROPERTY_CANNOT_BE_NULL = "forwardProperty cannot be null";
    private static final String SUPERCLASS_CANNOT_BE_NULL = "superclass cannot be null";
    private static final String SUBCLASS_CANNOT_BE_NULL = "subclass cannot be null";
    private static final String RANGE_CANNOT_BE_NULL = "range cannot be null";
    private static final String SUBJECT_CANNOT_BE_NULL = "subject cannot be null";
    private static final String OBJECT_CANNOT_BE_NULL = "object cannot be null";
    private static final String IMPORTED_ONTOLOGY_IRI_CANNOT_BE_NULL = "importedOntologyIRI cannot be null";
    private static final String CLASS_EXPRESSIONS_CANNOT_BE_NULL = "classExpressions cannot be null";
    private static final String PROPERTIES_CANNOT_BE_NULL = "properties cannot be null";
    private static final String CLASS_EXPRESSIONS_CANNOT_BE_NULL_OR_CONTAIN_NULL = "classExpressions cannot be null or contain null";
    private static final String INDIVIDUALS_CANNOT_BE_NULL = "individuals cannot be null";
    private static final String OWL_ENTITY_CANNOT_BE_NULL = "owlEntity cannot be null";
    private static final String SUPER_PROPERTY_CANNOT_BE_NULL = "superProperty cannot be null";
    private static final String SUB_PROPERTY_CANNOT_BE_NULL = "subProperty cannot be null";
    private static final String OWL_DATA_RANGE_CANNOT_BE_NULL = "owlDataRange cannot be null";
    private static final String DOMAIN_CANNOT_BE_NULL = "domain cannot be null";
    private static final String INDIVIDUAL_CANNOT_BE_NULL = "individual cannot be null";
    private static final String CLASS_EXPRESSION_CANNOT_BE_NULL = "classExpression cannot be null";
    private static final String VALUE_CANNOT_BE_NULL = "value cannot be null";
    private static final String CARDINALITY_CANNOT_BE_NEGATIVE = "cardinality cannot be negative";
    private static final String FACET_VALUE_CANNOT_BE_NULL = "facetValue cannot be null";
    private static final String PROPERTY_CANNOT_BE_NULL = "property cannot be null";
    private static final String FACET_CANNOT_BE_NULL = "facet cannot be null";
    private static final String DATATYPE_CANNOT_BE_NULL = "datatype cannot be null";
    private static final String FACET_RESTRICTIONS_CANNOT_BE_NULL = "facet restrictions cannot be null";
    private static final String DATA_RANGE_CANNOT_BE_NULL = "dataRange cannot be null";
    private static final String DATA_RANGES_CANNOT_BE_NULL = "data ranges cannot be null";
    private static final String ID_CANNOT_BE_NULL = "id cannot be null";
    private static final String IRI_CANNOT_BE_NULL = "iri cannot be null";
    private static final String ENTITY_TYPE_CANNOT_BE_NULL = "entityType cannot be null";
    private static final String ANNOTATIONS_CANNOT_BE_NULL = "annotations cannot be null";

    private static int nonNegativeCardinality(int value) {
        if (value < 0) {
            throw new OntApiException.IllegalArgument(CARDINALITY_CANNOT_BE_NEGATIVE);
        }
        return value;
    }

    private static Collection<OWLAnnotation> nonNullAnnotations(Collection<OWLAnnotation> annotations) {
        return OntApiException.notNull(annotations, ANNOTATIONS_CANNOT_BE_NULL);
    }

    public void purge() {
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> type, IRI iri) {
        return (E)OntApiException.notNull(type, ENTITY_TYPE_CANNOT_BE_NULL).buildEntity(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL), (EntityProvider)this);
    }

    public OWLClass getOWLClass(IRI iri) {
        return new OWLClassImpl(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLAnnotationProperty getRDFSLabel() {
        return InternalizedEntities.RDFS_LABEL;
    }

    public OWLAnnotationProperty getRDFSComment() {
        return InternalizedEntities.RDFS_COMMENT;
    }

    public OWLAnnotationProperty getRDFSSeeAlso() {
        return InternalizedEntities.RDFS_SEE_ALSO;
    }

    public OWLAnnotationProperty getRDFSIsDefinedBy() {
        return InternalizedEntities.RDFS_IS_DEFINED_BY;
    }

    public OWLAnnotationProperty getOWLVersionInfo() {
        return InternalizedEntities.OWL_VERSION_INFO;
    }

    public OWLAnnotationProperty getOWLBackwardCompatibleWith() {
        return InternalizedEntities.OWL_BACKWARD_COMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLIncompatibleWith() {
        return InternalizedEntities.OWL_INCOMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLDeprecated() {
        return InternalizedEntities.OWL_DEPRECATED;
    }

    public OWLClass getOWLThing() {
        return InternalizedEntities.OWL_THING;
    }

    public OWLClass getOWLNothing() {
        return InternalizedEntities.OWL_NOTHING;
    }

    public OWLDataProperty getOWLBottomDataProperty() {
        return InternalizedEntities.OWL_BOTTOM_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLBottomObjectProperty() {
        return InternalizedEntities.OWL_BOTTOM_OBJECT_PROPERTY;
    }

    public OWLDataProperty getOWLTopDataProperty() {
        return InternalizedEntities.OWL_TOP_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLTopObjectProperty() {
        return InternalizedEntities.OWL_TOP_OBJECT_PROPERTY;
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return new OWLObjectPropertyImpl(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLObjectInverseOf getOWLObjectInverseOf(OWLObjectProperty property) {
        return new OWLObjectInverseOfImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL));
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return new OWLDataPropertyImpl(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return new OWLAnnotationPropertyImpl(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return new OWLNamedIndividualImpl(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String id) {
        return this.getOWLAnonymousIndividual(BlankNodeId.create((String)OntApiException.notNull(id, ID_CANNOT_BE_NULL)));
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual() {
        return this.getOWLAnonymousIndividual(BlankNodeId.create());
    }

    @Override
    public OWLAnonymousIndividual getOWLAnonymousIndividual(BlankNodeId id) {
        return new OWLAnonymousIndividualImpl(OntApiException.notNull(id, ID_CANNOT_BE_NULL));
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(OntApiException.notNull(iri, IRI_CANNOT_BE_NULL));
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value) {
        return new OWLAnnotationImplNotAnnotated(property, value);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> annotations) {
        return this.getOWLAnnotation(property, value, OntApiException.notNull(annotations, ANNOTATIONS_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Collection<OWLAnnotation> annotations) {
        return new OWLAnnotationImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(value, VALUE_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDataOneOf getOWLDataOneOf(Stream<? extends OWLLiteral> values) {
        return this.getOWLDataOneOf(OntApiException.notNull(values, LITERALS_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLDataOneOf getOWLDataOneOf(Collection<? extends OWLLiteral> values) {
        return new OWLDataOneOfImpl(OntApiException.notNull(values, LITERALS_CANNOT_BE_NULL));
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWLDataRange range) {
        return new OWLDataComplementOfImpl(OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL));
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWL2Datatype range) {
        return this.getOWLDataComplementOf((OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this));
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(Stream<? extends OWLDataRange> ranges) {
        return new OWLDataIntersectionOfImpl(OntApiException.notNull(ranges, DATA_RANGES_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(Collection<? extends OWLDataRange> ranges) {
        return new OWLDataIntersectionOfImpl(OntApiException.notNull(ranges, DATA_RANGES_CANNOT_BE_NULL));
    }

    public OWLDataUnionOf getOWLDataUnionOf(Stream<? extends OWLDataRange> ranges) {
        return this.getOWLDataUnionOf(OntApiException.notNull(ranges, DATA_RANGES_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLDataUnionOf getOWLDataUnionOf(Collection<? extends OWLDataRange> ranges) {
        return new OWLDataUnionOfImpl(OntApiException.notNull(ranges, DATA_RANGES_CANNOT_BE_NULL));
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype datatype, Collection<OWLFacetRestriction> restrictions) {
        return new OWLDatatypeRestrictionImpl(OntApiException.notNull(datatype, DATATYPE_CANNOT_BE_NULL), OntApiException.notNull(restrictions, FACET_RESTRICTIONS_CANNOT_BE_NULL));
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype datatype, OWLFacet facet, OWLLiteral value) {
        return this.getOWLDatatypeRestriction(datatype, Collections.singletonList(this.getOWLFacetRestriction(facet, value)));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, OWLLiteral value) {
        return new OWLFacetRestrictionImpl(OntApiException.notNull(facet, FACET_CANNOT_BE_NULL), OntApiException.notNull(value, FACET_VALUE_CANNOT_BE_NULL));
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Stream<? extends OWLClassExpression> operands) {
        return this.getOWLObjectIntersectionOf(OntApiException.notNull(operands, CLASS_EXPRESSIONS_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Collection<? extends OWLClassExpression> operands) {
        return new OWLObjectIntersectionOfImpl(OntApiException.notNull(operands, CLASS_EXPRESSIONS_CANNOT_BE_NULL));
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWLDataRange range) {
        return new OWLDataAllValuesFromImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL));
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWL2Datatype range) {
        return this.getOWLDataAllValuesFrom(property, (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this));
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property) {
        return this.getOWLDataExactCardinality(cardinality, property, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange range) {
        return new OWLDataExactCardinalityImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNegativeCardinality(cardinality), OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL));
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype range) {
        return this.getOWLDataExactCardinality(cardinality, property, (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this));
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property) {
        return this.getOWLDataMaxCardinality(cardinality, property, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange range) {
        return new OWLDataMaxCardinalityImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNegativeCardinality(cardinality), OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL));
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype range) {
        return this.getOWLDataMaxCardinality(cardinality, property, (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this));
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property) {
        return this.getOWLDataMinCardinality(cardinality, property, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange range) {
        return new OWLDataMinCardinalityImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNegativeCardinality(cardinality), OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL));
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWL2Datatype range) {
        return this.getOWLDataMinCardinality(cardinality, property, (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this));
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWLDataRange range) {
        return new OWLDataSomeValuesFromImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL));
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWL2Datatype range) {
        return this.getOWLDataSomeValuesFrom(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this));
    }

    public OWLDataHasValue getOWLDataHasValue(OWLDataPropertyExpression property, OWLLiteral value) {
        return new OWLDataHasValueImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(value, VALUE_CANNOT_BE_NULL));
    }

    public OWLObjectComplementOf getOWLObjectComplementOf(OWLClassExpression operand) {
        return new OWLObjectComplementOfImpl(OntApiException.notNull(operand, CLASS_EXPRESSION_CANNOT_BE_NULL));
    }

    public OWLObjectAllValuesFrom getOWLObjectAllValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        return new OWLObjectAllValuesFromImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(classExpression, CLASS_EXPRESSION_CANNOT_BE_NULL));
    }

    public OWLObjectOneOf getOWLObjectOneOf(Stream<? extends OWLIndividual> values) {
        return this.getOWLObjectOneOf(OntApiException.notNull(values, CLASS_EXPRESSIONS_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLObjectOneOf getOWLObjectOneOf(Collection<? extends OWLIndividual> values) {
        return new OWLObjectOneOfImpl(OntApiException.notNull(values, CLASS_EXPRESSIONS_CANNOT_BE_NULL));
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property) {
        return this.getOWLObjectExactCardinality(cardinality, property, (OWLClassExpression)this.getOWLThing());
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression clazz) {
        return new OWLObjectExactCardinalityImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNegativeCardinality(cardinality), OntApiException.notNull(clazz, CLASS_EXPRESSION_CANNOT_BE_NULL));
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property) {
        return this.getOWLObjectMinCardinality(cardinality, property, (OWLClassExpression)this.getOWLThing());
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression clazz) {
        return new OWLObjectMinCardinalityImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNegativeCardinality(cardinality), OntApiException.notNull(clazz, CLASS_EXPRESSION_CANNOT_BE_NULL));
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property) {
        return this.getOWLObjectMaxCardinality(cardinality, property, (OWLClassExpression)this.getOWLThing());
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression clazz) {
        return new OWLObjectMaxCardinalityImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNegativeCardinality(cardinality), OntApiException.notNull(clazz, CLASS_EXPRESSION_CANNOT_BE_NULL));
    }

    public OWLObjectHasSelf getOWLObjectHasSelf(OWLObjectPropertyExpression property) {
        return new OWLObjectHasSelfImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL));
    }

    public OWLObjectSomeValuesFrom getOWLObjectSomeValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression clazz) {
        return new OWLObjectSomeValuesFromImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(clazz, CLASS_EXPRESSION_CANNOT_BE_NULL));
    }

    public OWLObjectHasValue getOWLObjectHasValue(OWLObjectPropertyExpression property, OWLIndividual individual) {
        return new OWLObjectHasValueImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(individual, INDIVIDUAL_CANNOT_BE_NULL));
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Stream<? extends OWLClassExpression> operands) {
        return this.getOWLObjectUnionOf(OntApiException.notNull(operands, CLASS_EXPRESSIONS_CANNOT_BE_NULL).collect(Collectors.toList()));
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Collection<? extends OWLClassExpression> operands) {
        return new OWLObjectUnionOfImpl(OntApiException.notNull(operands, CLASS_EXPRESSIONS_CANNOT_BE_NULL));
    }

    public SWRLVariable getSWRLVariable(IRI var) {
        return new SWRLVariableImpl(OntApiException.notNull(var, VAR_CANNOT_BE_NULL));
    }

    public SWRLIndividualArgument getSWRLIndividualArgument(OWLIndividual individual) {
        return new SWRLIndividualArgumentImpl(OntApiException.notNull(individual, INDIVIDUAL_CANNOT_BE_NULL));
    }

    public SWRLLiteralArgument getSWRLLiteralArgument(OWLLiteral literal) {
        return new SWRLLiteralArgumentImpl(OntApiException.notNull(literal, LITERAL_CANNOT_BE_NULL));
    }

    public SWRLClassAtom getSWRLClassAtom(OWLClassExpression predicate, SWRLIArgument arg) {
        return new SWRLClassAtomImpl(OntApiException.notNull(predicate, PREDICATE_CANNOT_BE_NULL), OntApiException.notNull(arg, ARG_CANNOT_BE_NULL));
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWLDataRange predicate, SWRLDArgument arg) {
        return new SWRLDataRangeAtomImpl(OntApiException.notNull(predicate, PREDICATE_CANNOT_BE_NULL), OntApiException.notNull(arg, ARG_CANNOT_BE_NULL));
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWL2Datatype range, SWRLDArgument arg) {
        return this.getSWRLDataRangeAtom((OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this), arg);
    }

    public SWRLObjectPropertyAtom getSWRLObjectPropertyAtom(OWLObjectPropertyExpression property, SWRLIArgument arg0, SWRLIArgument arg1) {
        return new SWRLObjectPropertyAtomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(arg0, ARG0_CANNOT_BE_NULL), OntApiException.notNull(arg1, ARG1_CANNOT_BE_NULL));
    }

    public SWRLDataPropertyAtom getSWRLDataPropertyAtom(OWLDataPropertyExpression property, SWRLIArgument arg0, SWRLDArgument arg1) {
        return new SWRLDataPropertyAtomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(arg0, ARG0_CANNOT_BE_NULL), OntApiException.notNull(arg1, ARG1_CANNOT_BE_NULL));
    }

    public SWRLBuiltInAtom getSWRLBuiltInAtom(IRI builtInIRI, List<SWRLDArgument> args) {
        return new SWRLBuiltInAtomImpl(OntApiException.notNull(builtInIRI, BUILT_IN_IRI_CANNOT_BE_NULL), OntApiException.notNull(args, ARGS_CANNOT_BE_NULL));
    }

    public SWRLDifferentIndividualsAtom getSWRLDifferentIndividualsAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        return new SWRLDifferentIndividualsAtomImpl(this.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_DIFFERENT_FROM), OntApiException.notNull(arg0, ARG0_CANNOT_BE_NULL), OntApiException.notNull(arg1, ARG1_CANNOT_BE_NULL));
    }

    public SWRLSameIndividualAtom getSWRLSameIndividualAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        return new SWRLSameIndividualAtomImpl(this.getOWLObjectProperty((HasIRI)OWLRDFVocabulary.OWL_SAME_AS), OntApiException.notNull(arg0, ARG0_CANNOT_BE_NULL), OntApiException.notNull(arg1, ARG1_CANNOT_BE_NULL));
    }

    public OWLLiteral getOWLLiteral(boolean b) {
        return b ? InternalizedEntities.TRUE_LITERAL : InternalizedEntities.FALSE_LITERAL;
    }

    public OWLLiteral getOWLLiteral(int i) {
        return OWLLiteralImpl.createLiteral(i);
    }

    public OWLLiteral getOWLLiteral(double d) {
        return OWLLiteralImpl.createLiteral(d);
    }

    public OWLLiteral getOWLLiteral(float f) {
        return OWLLiteralImpl.createLiteral(f);
    }

    public OWLLiteral getOWLLiteral(String txt) {
        return OWLLiteralImpl.createLiteral(OntApiException.notNull(txt, VALUE_CANNOT_BE_NULL));
    }

    public OWLLiteral getOWLLiteral(String txt, String lang) {
        return OWLLiteralImpl.createLiteral(OntApiException.notNull(txt, LITERAL_CANNOT_BE_NULL), lang);
    }

    public OWLLiteral getOWLLiteral(String txt, OWLDatatype dt) {
        return OWLLiteralImpl.createLiteral(OntApiException.notNull(txt, LEXICAL_VALUE_CANNOT_BE_NULL), OntApiException.notNull(dt, DATATYPE_CANNOT_BE_NULL));
    }

    @Override
    public OWLLiteral getOWLLiteral(LiteralLabel label) {
        return OWLLiteralImpl.newLiteral(OntApiException.notNull(label, VALUE_CANNOT_BE_NULL));
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return InternalizedEntities.XSD_BOOLEAN;
    }

    public OWLDatatype getStringOWLDatatype() {
        return InternalizedEntities.XSD_STRING;
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return InternalizedEntities.XSD_DOUBLE;
    }

    public OWLDatatype getFloatOWLDatatype() {
        return InternalizedEntities.XSD_FLOAT;
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return InternalizedEntities.XSD_INTEGER;
    }

    public OWLDatatype getTopDatatype() {
        return InternalizedEntities.RDFS_LITERAL;
    }

    public OWLDatatype getRDFPlainLiteral() {
        return InternalizedEntities.RDF_PLAIN_LITERAL;
    }

    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression properties, Collection<OWLAnnotation> annotations) {
        return new OWLAsymmetricObjectPropertyAxiomImpl(OntApiException.notNull(properties, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain, Collection<OWLAnnotation> annotations) {
        return new OWLDataPropertyDomainAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(domain, DOMAIN_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange range, Collection<OWLAnnotation> annotations) {
        return new OWLDataPropertyRangeAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(range, OWL_DATA_RANGE_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWL2Datatype range, Collection<OWLAnnotation> annotations) {
        return this.getOWLDataPropertyRangeAxiom(property, (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this), annotations);
    }

    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        return new OWLSubDataPropertyOfAxiomImpl(OntApiException.notNull(subProperty, SUB_PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(superProperty, SUPER_PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity entity, Collection<OWLAnnotation> annotations) {
        return new OWLDeclarationAxiomImpl(OntApiException.notNull(entity, OWL_ENTITY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(Collection<? extends OWLIndividual> individuals, Collection<OWLAnnotation> annotations) {
        return new OWLDifferentIndividualsAxiomImpl(OntApiException.notNull(individuals, INDIVIDUALS_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(Collection<? extends OWLClassExpression> classes, Collection<OWLAnnotation> annotations) {
        OntApiException.notNull(classes, CLASS_EXPRESSIONS_CANNOT_BE_NULL_OR_CONTAIN_NULL);
        DataFactoryImpl.nonNullAnnotations(annotations);
        if (classes.size() == 1) {
            OWLClassExpression clazz = classes.iterator().next();
            if (clazz.isOWLThing() || clazz.isOWLNothing()) {
                throw new OntApiException.IllegalArgument(String.format("DisjointClasses(%s) cannot be created: it is not a syntactically valid OWL 2 axiom. Please consider the possibility of adding the axiom SubClassOf(%s, owl:Nothing) instead.", clazz, clazz));
            }
            List<OWLClassExpression> res = Arrays.asList(InternalizedEntities.OWL_THING, clazz);
            return this.getOWLDisjointClassesAxiom(res, this.createDisjointWithThingAnnotations(annotations, clazz));
        }
        return new OWLDisjointClassesAxiomImpl(classes, annotations);
    }

    private Set<OWLAnnotation> createDisjointWithThingAnnotations(Collection<OWLAnnotation> annotations, OWLClassExpression clazz) {
        HashSet<OWLAnnotation> modifiedAnnotations = new HashSet<OWLAnnotation>(annotations.size() + 1);
        modifiedAnnotations.addAll(annotations);
        String provenanceComment = String.format("%s on %s", VersionInfo.getVersionInfo().getGeneratedByMessage(), Instant.now());
        OWLAnnotation provenanceAnnotation = this.getOWLAnnotation(InternalizedEntities.RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(provenanceComment));
        Set<OWLAnnotation> metaAnnotations = Collections.singleton(provenanceAnnotation);
        String changeComment = String.format("DisjointClasses(%s) replaced by DisjointClasses(%s %s)", clazz, clazz, InternalizedEntities.OWL_THING);
        modifiedAnnotations.add(this.getOWLAnnotation(InternalizedEntities.RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(changeComment), metaAnnotations));
        return modifiedAnnotations;
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(Collection<? extends OWLDataPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        return new OWLDisjointDataPropertiesAxiomImpl(OntApiException.notNull(properties, PROPERTIES_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(Collection<? extends OWLObjectPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        return new OWLDisjointObjectPropertiesAxiomImpl(OntApiException.notNull(properties, PROPERTIES_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(Collection<? extends OWLClassExpression> classes, Collection<OWLAnnotation> annotations) {
        return new OWLEquivalentClassesAxiomImpl(OntApiException.notNull(classes, CLASS_EXPRESSIONS_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(Collection<? extends OWLDataPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        return new OWLEquivalentDataPropertiesAxiomImpl(OntApiException.notNull(properties, PROPERTIES_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLFunctionalDataPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLFunctionalObjectPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLImportsDeclaration getOWLImportsDeclaration(IRI importedOntologyIRI) {
        return new OWLImportsDeclarationImpl(OntApiException.notNull(importedOntologyIRI, IMPORTED_ONTOLOGY_IRI_CANNOT_BE_NULL));
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Collection<OWLAnnotation> annotations) {
        return new OWLDataPropertyAssertionAxiomImpl(OntApiException.notNull(subject, SUBJECT_CANNOT_BE_NULL), OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(object, OBJECT_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Collection<OWLAnnotation> annotations) {
        return new OWLNegativeDataPropertyAssertionAxiomImpl(OntApiException.notNull(subject, SUBJECT_CANNOT_BE_NULL), OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(object, OBJECT_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object, Collection<OWLAnnotation> annotations) {
        return new OWLNegativeObjectPropertyAssertionAxiomImpl(OntApiException.notNull(subject, SUBJECT_CANNOT_BE_NULL), OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(object, OBJECT_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression ces, OWLIndividual individual, Collection<OWLAnnotation> annotations) {
        return new OWLClassAssertionAxiomImpl(OntApiException.notNull(individual, INDIVIDUAL_CANNOT_BE_NULL), OntApiException.notNull(ces, CLASS_EXPRESSION_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLInverseFunctionalObjectPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLIrreflexiveObjectPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression ces, Collection<OWLAnnotation> annotations) {
        return new OWLObjectPropertyDomainAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(ces, CLASS_EXPRESSION_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range, Collection<OWLAnnotation> annotations) {
        return new OWLObjectPropertyRangeAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(range, RANGE_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        return new OWLSubObjectPropertyOfAxiomImpl(OntApiException.notNull(subProperty, SUB_PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(superProperty, SUPER_PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLReflexiveObjectPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(Collection<? extends OWLIndividual> individuals, Collection<OWLAnnotation> annotations) {
        return new OWLSameIndividualAxiomImpl(OntApiException.notNull(individuals, INDIVIDUALS_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass, Collection<OWLAnnotation> annotations) {
        return new OWLSubClassOfAxiomImpl(OntApiException.notNull(subClass, SUBCLASS_CANNOT_BE_NULL), OntApiException.notNull(superClass, SUPERCLASS_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLSymmetricObjectPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Collection<OWLAnnotation> annotations) {
        return new OWLTransitiveObjectPropertyAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty, Collection<OWLAnnotation> annotations) {
        return new OWLInverseObjectPropertiesAxiomImpl(OntApiException.notNull(forwardProperty, FORWARD_PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(inverseProperty, INVERSE_PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        return new OWLSubPropertyChainAxiomImpl(OntApiException.notNull(chain, CHAIN_CANNOT_BE_NULL), OntApiException.notNull(superProperty, SUPER_PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, Collection<? extends OWLPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        return new OWLHasKeyAxiomImpl(OntApiException.notNull(ce, CLASS_EXPRESSION_CANNOT_BE_NULL), OntApiException.notNull(properties, PROPERTIES_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass clazz, Stream<? extends OWLClassExpression> ces, Collection<OWLAnnotation> annotations) {
        return this.getOWLDisjointUnionAxiom(clazz, OntApiException.notNull(ces, CLASS_EXPRESSIONS_CANNOT_BE_NULL).collect(Collectors.toList()), annotations);
    }

    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass clazz, Collection<? extends OWLClassExpression> ces, Collection<OWLAnnotation> annotations) {
        return new OWLDisjointUnionAxiomImpl(OntApiException.notNull(clazz, OWL_CLASS_CANNOT_BE_NULL), OntApiException.notNull(ces, CLASS_EXPRESSIONS_CANNOT_BE_NULL), OntApiException.notNull(annotations, ANNOTATIONS_CANNOT_BE_NULL));
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(Collection<? extends OWLObjectPropertyExpression> properties, Collection<OWLAnnotation> annotations) {
        return new OWLEquivalentObjectPropertiesAxiomImpl(OntApiException.notNull(properties, PROPERTIES_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object, Collection<OWLAnnotation> annotations) {
        return new OWLObjectPropertyAssertionAxiomImpl(OntApiException.notNull(individual, INDIVIDUAL_CANNOT_BE_NULL), OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(object, OBJECT_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup, Collection<OWLAnnotation> annotations) {
        return new OWLSubAnnotationPropertyOfAxiomImpl(OntApiException.notNull(sub, SUB_PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(sup, SUPER_PROPERTY_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation) {
        OntApiException.notNull(annotation, ANNOTATION_CANNOT_BE_NULL);
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotation.annotations().collect(Collectors.toList()));
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation, Collection<OWLAnnotation> annotations) {
        OntApiException.notNull(annotation, ANNOTATION_CANNOT_BE_NULL);
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value, Collection<OWLAnnotation> annotations) {
        return new OWLAnnotationAssertionAxiomImpl(OntApiException.notNull(subject, SUBJECT_CANNOT_BE_NULL), OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(value, VALUE_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLAnnotationAssertionAxiom getDeprecatedOWLAnnotationAssertionAxiom(IRI subject) {
        return this.getOWLAnnotationAssertionAxiom(this.getOWLDeprecated(), (OWLAnnotationSubject)OntApiException.notNull(subject, SUBJECT_CANNOT_BE_NULL), (OWLAnnotationValue)this.getOWLLiteral(true));
    }

    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty property, IRI domain, Collection<OWLAnnotation> annotations) {
        return new OWLAnnotationPropertyDomainAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(domain, DOMAIN_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty property, IRI range, Collection<OWLAnnotation> annotations) {
        return new OWLAnnotationPropertyRangeAxiomImpl(OntApiException.notNull(property, PROPERTY_CANNOT_BE_NULL), OntApiException.notNull(range, RANGE_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange range, Collection<OWLAnnotation> annotations) {
        return new OWLDatatypeDefinitionAxiomImpl(OntApiException.notNull(datatype, DATATYPE_CANNOT_BE_NULL), OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWL2Datatype range, Collection<OWLAnnotation> annotations) {
        return this.getOWLDatatypeDefinitionAxiom(datatype, (OWLDataRange)OntApiException.notNull(range, DATA_RANGE_CANNOT_BE_NULL).getDatatype((DatatypeProvider)this), annotations);
    }

    public SWRLRule getSWRLRule(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head) {
        return this.getSWRLRule(body, head, Collections.emptyList());
    }

    public SWRLRule getSWRLRule(Collection<? extends SWRLAtom> body, Collection<? extends SWRLAtom> head, Collection<OWLAnnotation> annotations) {
        return new SWRLRuleImpl(OntApiException.notNull(body, BODY_CANNOT_BE_NULL), OntApiException.notNull(head, HEAD_CANNOT_BE_NULL), DataFactoryImpl.nonNullAnnotations(annotations));
    }
}

