/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IntArrays;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IntSet;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.IntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntHashSet
extends AbstractIntCollection
implements IntLookupContainer,
IntSet,
Cloneable {
    public int[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<IntCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = IntHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public IntHashSet() {
        this(8, 0.75);
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public IntHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public IntHashSet(IntContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
        }
        return true;
    }

    public int add(int e1, int e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(int ... elements) {
        int count = 0;
        for (int e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(IntContainer container) {
        return this.addAll((Iterable<? extends IntCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends IntCursor> iterable) {
        int count = 0;
        for (IntCursor intCursor : iterable) {
            if (!this.add(intCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(int pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        int[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        int key = 0;
        int slot = -1;
        int[] keys = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            int[] keys = new int[capacity];
            this.keys = keys;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(int key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public boolean contains(int key) {
        int existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        IntArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h = 0;
        int[] keys = this.keys;
        int i = keys.length;
        while (--i >= 0) {
            int existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            IntSet other = (IntSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((IntCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0);
        }
        int[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0; --i) {
            int existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public int[] toArray(int[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = 0;
        }
        int[] keys = this.keys;
        for (int i = 0; i < keys.length; ++i) {
            int existing = keys[i];
            if (existing == 0) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public IntHashSet clone() {
        IntHashSet cloned = new IntHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        int existing;
        if (this.allocatedDefaultKey && !predicate.apply(0)) {
            return predicate;
        }
        int[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0)) {
            this.allocatedDefaultKey = false;
        }
        int[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            int existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static IntHashSet from(int ... elements) {
        IntHashSet set = new IntHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static IntHashSet from(IntContainer container) {
        return new IntHashSet(container);
    }

    public static IntHashSet newInstance() {
        return new IntHashSet();
    }

    public static IntHashSet newInstance(int initialCapacity, double loadFactor) {
        return new IntHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            if (this.cursor.index == IntHashSet.this.keys.length + 1) {
                if (IntHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = IntHashSet.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = IntHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntHashSet.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

