/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IntArrays;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntFloatAssociativeContainer;
import com.carrotsearch.hppcrt.IntFloatMap;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.IntFloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.predicates.IntFloatPredicate;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;
import com.carrotsearch.hppcrt.procedures.IntFloatProcedure;
import com.carrotsearch.hppcrt.procedures.IntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntFloatHashMap
implements IntFloatMap,
Cloneable {
    protected float defaultValue = 0.0f;
    public int[] keys;
    public float[] values;
    public boolean allocatedDefaultKey = false;
    public float allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<IntFloatCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = IntFloatHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public IntFloatHashMap() {
        this(8);
    }

    public IntFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public IntFloatHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public IntFloatHashMap(IntFloatAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public float put(int key, float value) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(IntFloatAssociativeContainer container) {
        return this.putAll((Iterable<? extends IntFloatCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends IntFloatCursor> iterable) {
        int count = this.size();
        for (IntFloatCursor intFloatCursor : iterable) {
            this.put(intFloatCursor.key, intFloatCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(int key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(int key, float putValue, float incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public float addTo(int key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(int pendingKey, float pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        int[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        int key = 0;
        float value = 0.0f;
        int slot = -1;
        int[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            int[] keys = new int[capacity];
            float[] values = new float[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public float remove(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                float value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            int existing = keys[slot];
            float existingValue = values[slot];
            if (existing == 0) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public int removeAll(IntContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof IntLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0)) {
                this.allocatedDefaultKey = false;
            }
            int[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                int existing = keys[i];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (IntCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0)) {
            this.allocatedDefaultKey = false;
        }
        int[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            int existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntFloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        int[] keys = this.keys;
        float[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            int existing = keys[i];
            if (existing != 0 && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public float get(int key) {
        int existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        int[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        IntArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = 0;
        if (this.allocatedDefaultKey) {
            h += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        int[] keys = this.keys;
        float[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            int existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            IntFloatHashMap other = (IntFloatHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                IntFloatCursor c = (IntFloatCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                float otherValue = other.get(c.key);
                if (Float.floatToIntBits(c.value) == Float.floatToIntBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends IntFloatProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0, this.allocatedDefaultKeyValue);
        }
        int[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            int existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends IntFloatPredicate> T forEach(T predicate) {
        int existing;
        if (this.allocatedDefaultKey && !predicate.apply(0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        int[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public IntFloatHashMap clone() {
        IntFloatHashMap cloned = new IntFloatHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static IntFloatHashMap from(int[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntFloatHashMap map = new IntFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static IntFloatHashMap from(IntFloatAssociativeContainer container) {
        return new IntFloatHashMap(container);
    }

    public static IntFloatHashMap newInstance() {
        return new IntFloatHashMap();
    }

    public static IntFloatHashMap newInstance(int initialCapacity, double loadFactor) {
        return new IntFloatHashMap(initialCapacity, loadFactor);
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == IntFloatHashMap.this.values.length + 1) {
                if (IntFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntFloatHashMap.this.values.length;
                    this.cursor.value = IntFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = IntFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntFloatHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntFloatHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractFloatCollection {
        private final IntFloatHashMap owner;
        protected final IteratorPool<FloatCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = IntFloatHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = IntFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(float value) {
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(value) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            int[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0 || Float.floatToIntBits(value) != Float.floatToIntBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            int[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == 0) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            int[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == 0 || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(float e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(e) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            int[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && Float.floatToIntBits(e) == Float.floatToIntBits(values[slot])) {
                    IntFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            int[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != 0 && predicate.apply(values[slot])) {
                    IntFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            int[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == 0) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            if (this.cursor.index == IntFloatHashMap.this.keys.length + 1) {
                if (IntFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntFloatHashMap.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = IntFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntFloatHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntFloatHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntFloatHashMap owner;
        protected final IteratorPool<IntCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = IntFloatHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = IntFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(int e) {
            return IntFloatHashMap.this.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0);
            }
            int[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                int existing = keys[i];
                if (existing == 0) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0)) {
                return predicate;
            }
            int[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0;
            }
            int[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                int existing = keys[i];
                if (existing == 0) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntFloatCursor> {
        public final IntFloatCursor cursor = new IntFloatCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected IntFloatCursor fetch() {
            int i;
            if (this.cursor.index == IntFloatHashMap.this.keys.length + 1) {
                if (IntFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = IntFloatHashMap.this.keys.length;
                    this.cursor.key = 0;
                    this.cursor.value = IntFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = IntFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && IntFloatHashMap.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (IntFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = IntFloatHashMap.this.keys[i];
            this.cursor.value = IntFloatHashMap.this.values[i];
            return this.cursor;
        }
    }
}

