/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.experimental;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.commons.rdf.api.Dataset;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Quad;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFSyntax;

public interface RDFParser {
    public RDFParser rdfTermFactory(RDF var1);

    public RDFParser contentType(RDFSyntax var1) throws IllegalArgumentException;

    public RDFParser contentType(String var1) throws IllegalArgumentException;

    default public RDFParser target(Graph graph) {
        return this.target((Quad q) -> {
            if (!q.getGraphName().isPresent()) {
                graph.add(q.asTriple());
            }
        });
    }

    default public RDFParser target(Dataset dataset) {
        return this.target(dataset::add);
    }

    public RDFParser target(Consumer<Quad> var1);

    public RDFParser base(IRI var1);

    public RDFParser base(String var1) throws IllegalArgumentException;

    public RDFParser source(InputStream var1);

    public RDFParser source(Path var1);

    public RDFParser source(IRI var1);

    public RDFParser source(String var1) throws IllegalArgumentException;

    public Future<? extends ParseResult> parse() throws IOException, IllegalStateException;

    public static interface ParseResult {
    }
}

