/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;

public abstract class DatasetGraphNull
extends DatasetGraphBaseFind {
    private Graph dftGraph = this.createGraph();
    private Graph unionGraph = this.createGraph();
    private Transactional txn = TransactionalNull.create();

    protected abstract Graph createGraph();

    protected DatasetGraphNull() {
    }

    @Override
    public void begin() {
        this.txn.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return this.txn.promote(txnType);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return Iter.nullIterator();
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return Iter.nullIterator();
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return Iter.nullIterator();
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return Iter.nullIterator();
    }

    @Override
    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    @Override
    public Graph getUnionGraph() {
        return this.unionGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (Quad.isDefaultGraph(graphNode)) {
            return this.dftGraph;
        }
        if (Quad.isUnionGraph(graphNode)) {
            return this.getUnionGraph();
        }
        return null;
    }

    @Override
    public void add(Quad quad) {
        DatasetGraphNull.unsupportedMethod(this, "add");
    }

    @Override
    public void delete(Quad quad) {
        DatasetGraphNull.unsupportedMethod(this, "delete");
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        DatasetGraphNull.unsupportedMethod(this, "deleteAny");
    }

    @Override
    public void setDefaultGraph(Graph g) {
        DatasetGraphNull.unsupportedMethod(this, "setDefaultGraph");
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        DatasetGraphNull.unsupportedMethod(this, "addGraph");
    }

    @Override
    public void removeGraph(Node graphName) {
        DatasetGraphNull.unsupportedMethod(this, "removeGraph");
    }
}

