/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Quad;

public class NodeFmtLib {
    private static final NodeFormatter plainFormatter = new NodeFormatterNT();
    private static PrefixMap dftPrefixMap = PrefixMapFactory.create();
    static char encodeMarkerChar;
    private static char LabelLeadingLetter;
    private static int relFlags;

    public static String str(Triple t) {
        return NodeFmtLib.strNodes(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static String str(Quad q) {
        return NodeFmtLib.strNodes(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    public static String str(Node n) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.str((IndentedWriter)sw, n);
        return sw.toString();
    }

    public static String strNodes(Node ... nodes) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        boolean first = true;
        for (Node n : nodes) {
            if (!first) {
                sw.append(" ", new Object[0]);
            }
            first = false;
            if (n == null) {
                sw.append("null", new Object[0]);
                continue;
            }
            NodeFmtLib.str((IndentedWriter)sw, n);
        }
        return sw.toString();
    }

    public static String displayStr(RDFNode obj) {
        return NodeFmtLib.displayStr(obj.asNode());
    }

    public static String displayStr(Triple t) {
        return NodeFmtLib.displayStrNodes(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static String displayStr(Node n) {
        return NodeFmtLib.str(n, null, dftPrefixMap);
    }

    private static String displayStrNodes(Node ... nodes) {
        StringJoiner sj = new StringJoiner(" ");
        for (Node n : nodes) {
            sj.add(NodeFmtLib.displayStr(n));
        }
        return sj.toString();
    }

    public static void str(IndentedWriter w, Node n) {
        NodeFmtLib.serialize(w, n, null, null);
    }

    public static String str(Node n, Prologue prologue) {
        return NodeFmtLib.str(n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static String str(Node n, PrefixMap prefixMap) {
        return NodeFmtLib.str(n, null, prefixMap);
    }

    public static String str(Node n, String base, PrefixMap prefixMap) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.serialize((IndentedWriter)sw, n, base, prefixMap);
        return sw.toString();
    }

    public static void serialize(IndentedWriter w, Node n, Prologue prologue) {
        NodeFmtLib.serialize(w, n, prologue.getBaseURI(), prologue.getPrefixMap());
    }

    public static void serialize(IndentedWriter w, Node n, String base, PrefixMap prefixMap) {
        NodeFormatter formatter = base == null && prefixMap == null ? plainFormatter : new NodeFormatterTTL(base, prefixMap);
        formatter.format((AWriter)w, n);
    }

    public static String encodeBNodeLabel(String label) {
        StringBuilder buff = new StringBuilder();
        buff.append(LabelLeadingLetter);
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (ch == encodeMarkerChar) {
                buff.append(ch);
                buff.append(ch);
                continue;
            }
            if (RiotChars.isA2ZN(ch)) {
                buff.append(ch);
                continue;
            }
            Chars.encodeAsHex((StringBuilder)buff, (char)encodeMarkerChar, (char)ch);
        }
        return buff.toString();
    }

    public static String decodeBNodeLabel(String label) {
        StringBuilder buffer = new StringBuilder();
        if (label.charAt(0) != LabelLeadingLetter) {
            return label;
        }
        for (int i = 1; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (ch != encodeMarkerChar) {
                buffer.append(ch);
                continue;
            }
            char ch2 = label.charAt(i + 1);
            if (ch2 == encodeMarkerChar) {
                ++i;
                buffer.append(ch);
                continue;
            }
            char hiC = label.charAt(++i);
            int hi = Bytes.hexCharToInt((char)hiC);
            char loC = label.charAt(++i);
            int lo = Bytes.hexCharToInt((char)loC);
            int combined = hi << 4 | lo;
            buffer.append((char)combined);
        }
        return buffer.toString();
    }

    public static String abbrevByBase(String uri, String base) {
        if (base == null) {
            return null;
        }
        IRI baseIRI = IRIResolver.iriFactory().construct(base);
        IRI rel = baseIRI.relativize(uri, relFlags);
        String r = null;
        try {
            r = rel.toASCIIString();
        }
        catch (MalformedURLException ex) {
            r = rel.toString();
        }
        return r;
    }

    static {
        PrefixMapping pm = ARQConstants.getGlobalPrefixMap();
        Map map = pm.getNsPrefixMap();
        for (Map.Entry e2 : map.entrySet()) {
            dftPrefixMap.add((String)e2.getKey(), (String)e2.getValue());
        }
        encodeMarkerChar = (char)88;
        LabelLeadingLetter = (char)66;
        relFlags = 9;
    }
}

