/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Operand;
import org.eclipse.rdf4j.sparqlbuilder.core.Assignment;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.DeleteDataQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.InsertDataQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.ModifyQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.SubSelect;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.json.JSONArray;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;

public class TimeSeriesSparql {
    private StoreClientInterface kbClient;
    public static final String ns_ontology = "http://www.theworldavatar.com/ontology/ontotimeseries/OntoTimeSeries.owl#";
    public static final String ns_kb = "http://www.theworldavatar.com/kb/ontotimeseries/";
    private static final Prefix prefix_ontology = SparqlBuilder.prefix((String)"ts", (Iri)Rdf.iri((String)"http://www.theworldavatar.com/ontology/ontotimeseries/OntoTimeSeries.owl#"));
    private static final Prefix prefix_kb = SparqlBuilder.prefix((String)"kb", (Iri)Rdf.iri((String)"http://www.theworldavatar.com/kb/ontotimeseries/"));
    private static final Iri TimeSeries = prefix_ontology.iri("TimeSeries");
    private static final Iri hasTimeSeries = prefix_ontology.iri("hasTimeSeries");
    private static final Iri hasRDB = prefix_ontology.iri("hasRDB");
    private static final Iri hasTimeUnit = prefix_ontology.iri("hasTimeUnit");
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";

    public TimeSeriesSparql(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    public void setKBClient(StoreClientInterface kbClient) {
        this.kbClient = kbClient;
    }

    protected void loadSparqlConfigs(String filepath) throws IOException {
        block15: {
            File file = new File(filepath);
            if (!file.exists()) {
                throw new JPSRuntimeException(this.exceptionPrefix + "No properties file found at specified filepath: " + filepath);
            }
            try (FileInputStream input = new FileInputStream(file);){
                Properties prop = new Properties();
                prop.load(input);
                if (!prop.containsKey("sparql.query.endpoint")) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"sparql.query.endpoint=<sparql_endpoint>\" ");
                }
                this.kbClient.setQueryEndpoint(prop.getProperty("sparql.query.endpoint"));
                if (prop.containsKey("sparql.update.endpoint")) {
                    this.kbClient.setUpdateEndpoint(prop.getProperty("sparql.update.endpoint"));
                    break block15;
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Properties file is missing \"sparql.update.endpoint=<sparql_endpoint>\" ");
            }
        }
    }

    public boolean checkTimeSeriesExists(String timeSeriesIRI) {
        String query = String.format("ask {<%s> a <%s>}", timeSeriesIRI, "http://www.theworldavatar.com/ontology/ontotimeseries/OntoTimeSeries.owl#TimeSeries");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    public boolean checkDataHasTimeSeries(String dataIRI) {
        String query = String.format("ask {<%s> <%s> ?a}", dataIRI, "http://www.theworldavatar.com/ontology/ontotimeseries/OntoTimeSeries.owl#hasTimeSeries");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        String query = String.format("ask {<%s> <%s> ?a}", tsIRI, "http://www.theworldavatar.com/ontology/ontotimeseries/OntoTimeSeries.owl#hasTimeUnit");
        this.kbClient.setQuery(query);
        return this.kbClient.executeQuery().getJSONObject(0).getBoolean("ASK");
    }

    protected void initTS(String timeSeriesIRI, List<String> dataIRI, String dbURL, String timeUnit) {
        if (!Pattern.compile("\\w+\\S+:\\S+\\w+").matcher(timeSeriesIRI).matches()) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series IRI does not have valid IRI format");
        }
        Iri tsIRI = Rdf.iri((String)timeSeriesIRI);
        if (this.checkTimeSeriesExists(timeSeriesIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series " + timeSeriesIRI + " already in the Knowledge Graph");
        }
        for (String iri : dataIRI) {
            String ts = this.getTimeSeries(iri);
            if (ts == null) continue;
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + iri + " is already attached to time series " + ts);
        }
        ModifyQuery modify = Queries.MODIFY();
        modify.prefix(new Prefix[]{prefix_ontology, prefix_kb});
        modify.insert(new TriplePattern[]{tsIRI.isA(new RdfObject[]{TimeSeries})});
        modify.insert(new TriplePattern[]{tsIRI.has((RdfPredicate)hasRDB, new RdfObject[]{Rdf.literalOf((String)dbURL)})});
        for (String data : dataIRI) {
            TriplePattern ts_tp = Rdf.iri((String)data).has((RdfPredicate)hasTimeSeries, new RdfObject[]{tsIRI});
            modify.insert(new TriplePattern[]{ts_tp});
        }
        if (timeUnit != null) {
            modify.insert(new TriplePattern[]{tsIRI.has((RdfPredicate)hasTimeUnit, new RdfObject[]{Rdf.literalOf((String)timeUnit)})});
        }
        this.kbClient.executeUpdate(modify.getQueryString());
    }

    public int countTS() {
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        String queryKey = "numtimeseries";
        Variable ts = query.var();
        Variable numtimeseries = SparqlBuilder.var((String)queryKey);
        TriplePattern querypattern = ts.isA(new RdfObject[]{TimeSeries});
        Assignment count = Expressions.count((Operand)ts).as(numtimeseries);
        query.prefix(new Prefix[]{prefix_ontology});
        query.select(new Projectable[]{count}).where(new GraphPattern[]{querypattern});
        this.kbClient.setQuery(query.getQueryString());
        return this.kbClient.executeQuery().getJSONObject(0).getInt(queryKey);
    }

    protected void insertTimeSeriesAssociation(String dataIRI, String tsIRI) {
        String ts = this.getTimeSeries(dataIRI);
        if (ts != null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "The data IRI " + dataIRI + " is already attached to time series " + ts);
        }
        if (!this.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Time series " + tsIRI + " does not exists in the Knowledge Graph");
        }
        InsertDataQuery insert = Queries.INSERT_DATA((TriplePattern[])new TriplePattern[]{Rdf.iri((String)dataIRI).has((RdfPredicate)hasTimeSeries, new RdfObject[]{Rdf.iri((String)tsIRI)})});
        insert.prefix(new Prefix[]{prefix_ontology});
        this.kbClient.executeUpdate(insert.getQueryString());
    }

    protected void removeTimeSeriesAssociation(String dataIRI) {
        String tsIRI = this.getTimeSeries(dataIRI);
        if (tsIRI != null) {
            List<String> data = this.getAssociatedData(tsIRI);
            if (data.size() == 1) {
                this.removeTimeSeries(tsIRI);
            } else {
                DeleteDataQuery delete = Queries.DELETE_DATA((TriplePattern[])new TriplePattern[]{Rdf.iri((String)dataIRI).has((RdfPredicate)hasTimeSeries, new RdfObject[]{Rdf.iri((String)tsIRI)})});
                delete.prefix(new Prefix[]{prefix_ontology});
                this.kbClient.executeUpdate(delete.getQueryString());
            }
        }
    }

    protected void removeTimeSeries(String tsIRI) {
        if (this.checkTimeSeriesExists(tsIRI)) {
            SubSelect sub = GraphPatterns.select((Projectable[])new Projectable[0]);
            Variable predicate1 = SparqlBuilder.var((String)"a");
            Variable predicate2 = SparqlBuilder.var((String)"b");
            Variable subject = SparqlBuilder.var((String)"c");
            Variable object = SparqlBuilder.var((String)"d");
            TriplePattern delete_tp1 = Rdf.iri((String)tsIRI).has((RdfPredicate)predicate1, new RdfObject[]{object});
            TriplePattern delete_tp2 = subject.has((RdfPredicate)predicate2, new RdfObject[]{Rdf.iri((String)tsIRI)});
            sub.select(new Projectable[]{predicate1, predicate2, subject, object}).where(new GraphPattern[]{delete_tp1, delete_tp2});
            ModifyQuery modify = Queries.MODIFY();
            modify.delete(new TriplePattern[]{delete_tp1, delete_tp2}).where(new GraphPattern[]{sub});
            this.kbClient.setQuery(modify.getQueryString());
            this.kbClient.executeUpdate();
        }
    }

    protected void removeAllTimeSeries() {
        List<String> tsIRI = this.getAllTimeSeries();
        if (!tsIRI.isEmpty()) {
            for (String ts : tsIRI) {
                this.removeTimeSeries(ts);
            }
        }
    }

    public String getTimeSeries(String dataIRI) {
        String result = null;
        if (this.checkDataHasTimeSeries(dataIRI)) {
            String queryString = "tsIRI";
            SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
            Variable tsIRI = SparqlBuilder.var((String)queryString);
            TriplePattern queryPattern = Rdf.iri((String)dataIRI).has((RdfPredicate)hasTimeSeries, new RdfObject[]{tsIRI});
            ((SelectQuery)query.select(new Projectable[]{tsIRI}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{prefix_ontology});
            this.kbClient.setQuery(query.getQueryString());
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public String getDbUrl(String tsIRI) {
        String result = null;
        if (this.checkTimeSeriesExists(tsIRI)) {
            String queryString = "dbURL";
            SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
            Variable dbURL = SparqlBuilder.var((String)queryString);
            TriplePattern queryPattern = Rdf.iri((String)tsIRI).has((RdfPredicate)hasRDB, new RdfObject[]{dbURL});
            ((SelectQuery)query.select(new Projectable[]{dbURL}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{prefix_ontology});
            this.kbClient.setQuery(query.getQueryString());
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public String getTimeUnit(String tsIRI) {
        String result = null;
        if (this.checkTimeSeriesExists(tsIRI) && this.checkTimeUnitExists(tsIRI)) {
            String queryString = "timeUnit";
            SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
            Variable timeUnit = SparqlBuilder.var((String)queryString);
            TriplePattern queryPattern = Rdf.iri((String)tsIRI).has((RdfPredicate)hasTimeUnit, new RdfObject[]{timeUnit});
            ((SelectQuery)query.select(new Projectable[]{timeUnit}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{prefix_ontology});
            this.kbClient.setQuery(query.getQueryString());
            result = this.kbClient.executeQuery().getJSONObject(0).getString(queryString);
        }
        return result;
    }

    public List<String> getAssociatedData(String tsIRI) {
        String queryString = "dataIRI";
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable data = SparqlBuilder.var((String)queryString);
        TriplePattern queryPattern = data.has((RdfPredicate)hasTimeSeries, new RdfObject[]{Rdf.iri((String)tsIRI)});
        ((SelectQuery)query.select(new Projectable[]{data}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{prefix_ontology});
        return this.getInstances(query, queryString);
    }

    public List<String> getAllTimeSeries() {
        String queryString = "ts";
        SelectQuery query = Queries.SELECT((Projectable[])new Projectable[0]);
        Variable ts = SparqlBuilder.var((String)queryString);
        TriplePattern queryPattern = ts.isA(new RdfObject[]{TimeSeries});
        ((SelectQuery)query.select(new Projectable[]{ts}).where(new GraphPattern[]{queryPattern})).prefix(new Prefix[]{prefix_ontology});
        return this.getInstances(query, queryString);
    }

    private List<String> getInstances(SelectQuery instanceSelectQuery, String placeholder) {
        this.kbClient.setQuery(instanceSelectQuery.getQueryString());
        JSONArray queryResult = this.kbClient.executeQuery();
        ArrayList<String> instanceIRIs = new ArrayList<String>();
        for (int i = 0; i < queryResult.length(); ++i) {
            instanceIRIs.add(queryResult.getJSONObject(i).getString(placeholder));
        }
        return instanceIRIs;
    }
}

