/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.timeseries;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeries;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesRDBClient;
import uk.ac.cam.cares.jps.base.timeseries.TimeSeriesSparql;

public class TimeSeriesClient<T> {
    private TimeSeriesRDBClient<T> rdbClient;
    private TimeSeriesSparql rdfClient;
    private final String exceptionPrefix = this.getClass().getSimpleName() + ": ";

    public TimeSeriesClient(StoreClientInterface kbClient, Class<T> timeClass, String rdbURL, String user, String password) {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    public TimeSeriesClient(StoreClientInterface kbClient, Class<T> timeClass, String filepath) throws IOException {
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    public TimeSeriesClient(Class<T> timeClass, String filepath) throws IOException {
        RemoteStoreClient kbClient = new RemoteStoreClient();
        this.rdfClient = new TimeSeriesSparql(kbClient);
        this.loadSparqlConfigs(filepath);
        this.rdbClient = new TimeSeriesRDBClient<T>(timeClass);
        this.loadRdbConfigs(filepath);
    }

    private void loadRdbConfigs(String filepath) throws IOException {
        this.rdbClient.loadRdbConfigs(filepath);
    }

    private void loadSparqlConfigs(String filepath) throws IOException {
        this.rdfClient.loadSparqlConfigs(filepath);
    }

    public void setKBClient(StoreClientInterface kbClient) {
        this.rdfClient.setKBClient(kbClient);
    }

    public void setRDBClient(String rdbURL, String user, String password) {
        this.rdbClient.setRdbURL(rdbURL);
        this.rdbClient.setRdbUser(user);
        this.rdbClient.setRdbPassword(password);
    }

    public void initTimeSeries(List<String> dataIRIs, List<Class<?>> dataClass, String timeUnit) {
        String tsIRI = "http://www.theworldavatar.com/kb/ontotimeseries/Timeseries_" + UUID.randomUUID();
        try {
            this.rdfClient.initTS(tsIRI, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
        }
        catch (Exception e_RdfCreate) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdfCreate);
        }
        try {
            this.rdbClient.initTimeSeriesTable(dataIRIs, dataClass, tsIRI);
        }
        catch (JPSRuntimeException e_RdbCreate) {
            try {
                this.rdfClient.removeTimeSeries(tsIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when initialising time series " + tsIRI + " , as database related instantiation failed but KG triples were created.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries was not created!", e_RdbCreate);
        }
    }

    public void addTimeSeriesData(TimeSeries<T> ts) {
        List<String> dataIRIs = ts.getDataIRIs();
        for (String iri : dataIRIs) {
            if (this.rdfClient.checkDataHasTimeSeries(iri)) continue;
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + iri + " is not attached to any time series instance in the KG");
        }
        this.rdbClient.addTimeSeriesData(ts);
    }

    public void deleteTimeSeriesHistory(String dataIRI, T lowerBound, T upperBound) {
        if (!this.rdfClient.checkDataHasTimeSeries(dataIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " is not attached to any time series instance in the KG");
        }
        this.rdbClient.deleteRows(dataIRI, lowerBound, upperBound);
    }

    public void deleteIndividualTimeSeries(String dataIRI) {
        String tsIRI = this.rdfClient.getTimeSeries(dataIRI);
        if (tsIRI == null) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " not associated with any timeseries.");
        }
        if (this.rdfClient.getAssociatedData(tsIRI).size() == 1) {
            this.deleteTimeSeries(tsIRI);
        } else {
            try {
                this.rdfClient.removeTimeSeriesAssociation(dataIRI);
            }
            catch (Exception e_RdfDelete) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdfDelete);
            }
            try {
                this.rdbClient.deleteTimeSeries(dataIRI);
            }
            catch (JPSRuntimeException e_RdbDelete) {
                try {
                    this.rdfClient.insertTimeSeriesAssociation(dataIRI, tsIRI);
                }
                catch (Exception e_RdfCreate) {
                    throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series association for " + dataIRI + " , as database related deletion failed but KG triples were deleted.");
                }
                throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries association for " + dataIRI + " was not deleted!", e_RdbDelete);
            }
        }
    }

    public void deleteTimeSeries(String tsIRI) {
        if (!this.rdfClient.checkTimeSeriesExists(tsIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + tsIRI + " does not exist in KG");
        }
        List<String> dataIRIs = this.rdfClient.getAssociatedData(tsIRI);
        String timeUnit = this.rdfClient.getTimeUnit(tsIRI);
        try {
            this.rdfClient.removeTimeSeries(tsIRI);
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteTimeSeriesTable(dataIRIs.get(0));
        }
        catch (JPSRuntimeException e_RdbDelete) {
            try {
                this.rdfClient.initTS(tsIRI, dataIRIs, this.rdbClient.getRdbURL(), timeUnit);
            }
            catch (Exception e_RdfCreate) {
                throw new JPSRuntimeException(this.exceptionPrefix + "Inconsistent state created when deleting time series " + tsIRI + " , as database related deletion failed but KG triples were deleted.");
            }
            throw new JPSRuntimeException(this.exceptionPrefix + "Timeseries " + tsIRI + " was not deleted!", e_RdbDelete);
        }
    }

    public void deleteAll() {
        try {
            this.rdfClient.removeAllTimeSeries();
        }
        catch (Exception e_RdfDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from KG! Potentially inconsistent state between KG and database", e_RdfDelete);
        }
        try {
            this.rdbClient.deleteAll();
        }
        catch (JPSRuntimeException e_RdbDelete) {
            throw new JPSRuntimeException(this.exceptionPrefix + "Not all timeseries were deleted from database! Potentially inconsistent state between KG and database", e_RdbDelete);
        }
    }

    public TimeSeries<T> getTimeSeriesWithinBounds(List<String> dataIRIs, T lowerBound, T upperBound) {
        for (String iri : dataIRIs) {
            if (this.rdfClient.checkDataHasTimeSeries(iri)) continue;
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + iri + " is not attached to any time series instance in the KG");
        }
        return this.rdbClient.getTimeSeriesWithinBounds(dataIRIs, lowerBound, upperBound);
    }

    public TimeSeries<T> getTimeSeries(List<String> dataIRIs) {
        return this.getTimeSeriesWithinBounds(dataIRIs, null, null);
    }

    public double getAverage(String dataIRI) {
        if (!this.rdfClient.checkDataHasTimeSeries(dataIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " is not attached to any time series instance in the KG");
        }
        return this.rdbClient.getAverage(dataIRI);
    }

    public double getMaxValue(String dataIRI) {
        if (!this.rdfClient.checkDataHasTimeSeries(dataIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " is not attached to any time series instance in the KG");
        }
        return this.rdbClient.getMaxValue(dataIRI);
    }

    public double getMinValue(String dataIRI) {
        if (!this.rdfClient.checkDataHasTimeSeries(dataIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " is not attached to any time series instance in the KG");
        }
        return this.rdbClient.getMinValue(dataIRI);
    }

    public T getMaxTime(String dataIRI) {
        if (!this.rdfClient.checkDataHasTimeSeries(dataIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " is not attached to any time series instance in the KG");
        }
        return this.rdbClient.getMaxTime(dataIRI);
    }

    public T getMinTime(String dataIRI) {
        if (!this.rdfClient.checkDataHasTimeSeries(dataIRI)) {
            throw new JPSRuntimeException(this.exceptionPrefix + "DataIRI " + dataIRI + " is not attached to any time series instance in the KG");
        }
        return this.rdbClient.getMinTime(dataIRI);
    }

    public boolean checkTimeSeriesExists(String tsIRI) {
        return this.rdfClient.checkTimeSeriesExists(tsIRI);
    }

    public boolean checkDataHasTimeSeries(String dataIRI) {
        return this.rdfClient.checkDataHasTimeSeries(dataIRI);
    }

    public boolean checkTimeUnitExists(String tsIRI) {
        return this.rdfClient.checkTimeUnitExists(tsIRI);
    }

    public int countTimeSeries() {
        return this.rdfClient.countTS();
    }

    public String getTimeSeriesIRI(String dataIRI) {
        return this.rdfClient.getTimeSeries(dataIRI);
    }

    public String getDbUrl(String tsIRI) {
        return this.rdfClient.getDbUrl(tsIRI);
    }

    public String getTimeUnit(String tsIRI) {
        return this.rdfClient.getTimeUnit(tsIRI);
    }

    public List<String> getAssociatedData(String tsIRI) {
        return this.rdfClient.getAssociatedData(tsIRI);
    }

    public List<String> getAllTimeSeries() {
        return this.rdfClient.getAllTimeSeries();
    }
}

