/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.arq.querybuilder.WhereBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.interfaces.StoreClientInterface;
import uk.ac.cam.cares.jps.base.query.FileBasedStoreClient;
import uk.ac.cam.cares.jps.base.query.RemoteStoreClient;

public class StoreRouter {
    private static Logger LOGGER = LogManager.getLogger(StoreRouter.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String KB = "kb";
    public static final String BACKSLASH = "/";
    public static final String HTTP_KB_PREFIX = "http://".concat("kb").concat("/");
    public static final String EMPTY = "";
    private static final String STOREROUTER_ENDPOINT = "http://www.theworldavatar.com/blazegraph/namespace/ontokgrouter/sparql";
    public static final String RDFS_PREFIX = "rdfs";
    public static final String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    public static final String RDF_PREFIX = "rdf";
    public static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDF_TYPE = "type";
    public static final String ONTOKGROUTER_PREFIX = "ontokgrouter";
    public static final String ONTOKGROUTER = "http://www.theworldavatar.com/ontology/ontokgrouter/OntoKGRouter.owl#";
    public static final String RESOURCE = "resource";
    public static final String LABEL = "label";
    public static final String QUERY_ENDPOINT = "queryEndpoint";
    public static final String HAS_QUERY_ENDPOINT = "hasQueryEndpoint";
    public static final String UPDATE_ENDPOINT = "updateEndpoint";
    public static final String HAS_UPDATE_ENDPOINT = "hasUpdateEndpoint";
    public static final String FILE_PATH = "filePath";
    public static final String HAS_FILE_PATH = "hasFilePath";
    public static final String TOMCAT_ROOT_LABEL = "tomcatrootpath";
    public static final String COLON = ":";
    public static final String QUESTION_MARK = "?";
    public static final String TARGET_RESOURCE = "TargetResource";
    public static final String OWL_FILE_EXTENSION = ".owl";
    public static final String RDF_FILE_EXTENSION = ".rdf";
    static StoreRouter storeRouter = null;

    public static StoreClientInterface getStoreClient(String targetResourceIRI, boolean isQueryOperation, boolean isUpdateOperation) {
        String queryIRI = null;
        String updateIRI = null;
        StoreClientInterface kbClient = null;
        if (targetResourceIRI != null && !targetResourceIRI.isEmpty()) {
            if (storeRouter == null) {
                storeRouter = new StoreRouter();
            }
            if (targetResourceIRI.trim().endsWith(OWL_FILE_EXTENSION) || targetResourceIRI.trim().endsWith(RDF_FILE_EXTENSION)) {
                String rootPath = storeRouter.getLocalFilePath(STOREROUTER_ENDPOINT, TOMCAT_ROOT_LABEL);
                String filePath = targetResourceIRI.replace(HTTP, rootPath + BACKSLASH);
                kbClient = new FileBasedStoreClient(filePath);
            } else {
                if (isQueryOperation) {
                    queryIRI = storeRouter.getQueryIRI(STOREROUTER_ENDPOINT, targetResourceIRI.replace(HTTP_KB_PREFIX, EMPTY));
                }
                if (isUpdateOperation) {
                    updateIRI = storeRouter.getUpdateIRI(STOREROUTER_ENDPOINT, targetResourceIRI.replace(HTTP_KB_PREFIX, EMPTY));
                }
                if (queryIRI != null && !queryIRI.isEmpty()) {
                    kbClient = new RemoteStoreClient(queryIRI);
                }
                if (updateIRI != null && !updateIRI.isEmpty()) {
                    if (kbClient == null) {
                        kbClient = new RemoteStoreClient();
                    }
                    kbClient.setUpdateEndpoint(updateIRI);
                }
                if (queryIRI == null && updateIRI == null) {
                    LOGGER.error("Endpoint could not be retrieved for the following resource IRI:" + targetResourceIRI);
                }
                if (!isQueryOperation && !isUpdateOperation) {
                    LOGGER.error("null will be returned as both the isQueryOperation and isUpdateOperation parameters are set to false.");
                }
            }
        }
        return kbClient;
    }

    private String getLocalFilePath(String kgrouterEndpoint, String targetResourceName) {
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar((Object)QUESTION_MARK.concat(RESOURCE)).addVar((Object)QUESTION_MARK.concat(LABEL)).addVar((Object)QUESTION_MARK.concat(FILE_PATH)).addWhere((AbstractQueryBuilder)this.getCommonKGRouterWhereBuilder())).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_FILE_PATH), (Object)QUESTION_MARK.concat(FILE_PATH));
        RemoteStoreClient rKBClient = new RemoteStoreClient(kgrouterEndpoint);
        System.out.println(builder.toString());
        String json = rKBClient.execute(builder.toString());
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(FILE_PATH));
            return obj.getString(FILE_PATH);
        }
        return null;
    }

    private String getQueryIRI(String kgrouterEndpoint, String targetResourceName) {
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar((Object)QUESTION_MARK.concat(RESOURCE)).addVar((Object)QUESTION_MARK.concat(LABEL)).addVar((Object)QUESTION_MARK.concat(QUERY_ENDPOINT)).addWhere((AbstractQueryBuilder)this.getCommonKGRouterWhereBuilder())).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_QUERY_ENDPOINT), (Object)QUESTION_MARK.concat(QUERY_ENDPOINT));
        RemoteStoreClient rKBClient = new RemoteStoreClient(kgrouterEndpoint);
        System.out.println(builder.toString());
        String json = rKBClient.execute(builder.toString());
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(QUERY_ENDPOINT));
            return obj.getString(QUERY_ENDPOINT);
        }
        return null;
    }

    private String getUpdateIRI(String kgrouterEndpoint, String targetResourceName) {
        SelectBuilder builder = ((SelectBuilder)((SelectBuilder)((SelectBuilder)((SelectBuilder)new SelectBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addVar((Object)QUESTION_MARK.concat(RESOURCE)).addVar((Object)QUESTION_MARK.concat(LABEL)).addVar((Object)QUESTION_MARK.concat(UPDATE_ENDPOINT)).addWhere((AbstractQueryBuilder)this.getCommonKGRouterWhereBuilder())).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(HAS_UPDATE_ENDPOINT), (Object)QUESTION_MARK.concat(UPDATE_ENDPOINT));
        RemoteStoreClient rKBClient = new RemoteStoreClient(kgrouterEndpoint);
        System.out.println(builder.toString());
        String json = rKBClient.execute(builder.toString());
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (!obj.getString(LABEL).equals(targetResourceName)) continue;
            System.out.println(obj.get(UPDATE_ENDPOINT));
            return obj.getString(UPDATE_ENDPOINT);
        }
        return null;
    }

    private WhereBuilder getCommonKGRouterWhereBuilder() {
        return ((WhereBuilder)((WhereBuilder)((WhereBuilder)new WhereBuilder().addPrefix(RDFS_PREFIX, RDFS)).addPrefix(RDF_PREFIX, RDF)).addPrefix(ONTOKGROUTER_PREFIX, ONTOKGROUTER)).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)RDF_PREFIX.concat(COLON).concat(RDF_TYPE), (Object)ONTOKGROUTER_PREFIX.concat(COLON).concat(TARGET_RESOURCE)).addWhere((Object)QUESTION_MARK.concat(RESOURCE), (Object)RDFS_PREFIX.concat(COLON).concat(LABEL), (Object)QUESTION_MARK.concat(LABEL));
    }
}

