/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import org.apache.http.client.methods.HttpRequestBase;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.discovery.MediaType;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.http.Http;
import uk.ac.cam.cares.jps.base.query.JenaHelper;
import uk.ac.cam.cares.jps.base.query.JenaResultSetFormatter;
import uk.ac.cam.cares.jps.base.query.ResourcePathConverter;
import uk.ac.cam.cares.jps.base.scenario.JPSContext;
import uk.ac.cam.cares.jps.base.scenario.ScenarioHelper;

public class AccessAgentCaller {
    private static final Logger LOGGER = LogManager.getLogger(AccessAgentCaller.class);

    public static String put(String datasetUrl, String targetUrl, String content, String contentType) {
        LOGGER.info("put for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl, true);
        if (a != null) {
            String requestUrl = (String)a[0];
            JSONObject joparams = (JSONObject)a[1];
            return Http.execute((HttpRequestBase)Http.put(requestUrl, content, contentType, null, joparams));
        }
        throw new JPSRuntimeException("No requestUrl was created");
    }

    public static String get(String datasetUrl, String targetUrl, String accept) {
        LOGGER.info("get for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl, true);
        if (a != null) {
            String requestUrl = (String)a[0];
            JSONObject joparams = (JSONObject)a[1];
            return Http.execute((HttpRequestBase)Http.get(requestUrl, accept, joparams));
        }
        throw new JPSRuntimeException("No requestUrl was created");
    }

    public static String query(String datasetUrl, String targetUrl, String sparqlQuery) {
        LOGGER.info("query for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        boolean sparqlAbility = AccessAgentCaller.hasSparqlAbility(targetUrl);
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl, sparqlAbility);
        if (a != null) {
            System.out.println("a IS NOT NULL!!!");
            String requestUrl = (String)a[0];
            JSONObject joparams = (JSONObject)a[1];
            if (joparams == null) {
                joparams = new JSONObject();
            }
            System.out.println("joparams=" + joparams.toString());
            System.out.println("REQUESTURL=" + requestUrl);
            joparams.put("sparqlquery", (Object)sparqlQuery);
            return Http.execute((HttpRequestBase)Http.get(requestUrl, null, joparams));
        }
        LOGGER.info("SPARQL query is performed locally for targetUrl=" + targetUrl);
        String localUrl = ScenarioHelper.cutHash(targetUrl);
        localUrl = ResourcePathConverter.convert(localUrl);
        ResultSet resultSet = JenaHelper.queryUrl(localUrl, sparqlQuery);
        return JenaResultSetFormatter.convertToJSONW3CStandard(resultSet);
    }

    public static Object[] createRequestUrl(String datasetUrl, String targetUrl, boolean targetHasSparqlAbility) {
        String scenarioUrl = JPSContext.getScenarioUrl();
        String requestUrl = null;
        if (datasetUrl != null && datasetUrl.isEmpty()) {
            datasetUrl = null;
        }
        if (scenarioUrl != null || datasetUrl != null || targetHasSparqlAbility) {
            String resource;
            JSONObject joparams = null;
            if (scenarioUrl != null) {
                joparams = new JSONObject();
                resource = AccessAgentCaller.cutHashFragment(targetUrl);
                joparams.put("scenarioresource", (Object)resource);
                if (datasetUrl != null) {
                    if (targetUrl == null) {
                        joparams.put("scenarioresource", (Object)datasetUrl);
                    } else {
                        joparams.put("dataset", (Object)datasetUrl);
                    }
                }
                requestUrl = scenarioUrl;
            } else if (datasetUrl != null) {
                joparams = new JSONObject();
                resource = AccessAgentCaller.cutHashFragment(targetUrl);
                joparams.put("scenarioresource", (Object)resource);
                requestUrl = datasetUrl;
            } else {
                requestUrl = AccessAgentCaller.cutHashFragment(targetUrl);
            }
            requestUrl = ResourcePathConverter.convert(requestUrl);
            Object[] a = new Object[]{requestUrl, joparams};
            return a;
        }
        return null;
    }

    public static void update(String datasetUrl, String targetUrl, String sparqlUpdate) {
        LOGGER.info("update for datasetUrl=" + datasetUrl + ", targetUrl=" + targetUrl + ", scenarioUrl=" + JPSContext.getScenarioUrl());
        boolean sparqlAbility = AccessAgentCaller.hasSparqlAbility(targetUrl);
        Object[] a = AccessAgentCaller.createRequestUrl(datasetUrl, targetUrl, sparqlAbility);
        if (a != null) {
            String requestUrl = (String)a[0];
            JSONObject joparams = (JSONObject)a[1];
            JSONObject jobody = new JSONObject();
            jobody.put("sparqlupdate", (Object)sparqlUpdate);
            String contentType = MediaType.APPLICATION_JSON.type;
            Http.execute((HttpRequestBase)Http.post(requestUrl, jobody.toString(), contentType, null, joparams));
            return;
        }
        String requestUrl = ScenarioHelper.cutHash(targetUrl);
        requestUrl = ResourcePathConverter.convert(requestUrl);
        LOGGER.info("SPARQL update is performed locally for requestUrl=" + requestUrl);
        UpdateRequest request = UpdateFactory.create((String)sparqlUpdate);
        OntModel model = JenaHelper.createModel(requestUrl);
        UpdateAction.execute((UpdateRequest)request, (Model)model);
        JenaHelper.writeAsFile((Model)model, requestUrl);
    }

    private static boolean hasSparqlAbility(String targetUrl) {
        if (targetUrl == null) {
            return false;
        }
        return targetUrl.contains("/jps/");
    }

    public static String cutHashFragment(String url) {
        if (url == null) {
            return null;
        }
        int i = url.lastIndexOf("#");
        if (i >= 0) {
            return url.substring(0, i);
        }
        return url;
    }
}

