# AUTOGENERATED! DO NOT EDIT! File to edit: authSdk.ipynb (unless otherwise specified).

__all__ = ['FunctionName', 'AuthSdk', 'CreateCashier', 'createCashier', 'Auth', 'auth', 'Confirm', 'confirm',
           'GetProfile', 'getProfile', 'UpdateProfile', 'updateProfile', 'SetPassword', 'setPassword', 'unauth',
           'DeleteUser', 'deleteUser']

# Cell
from nicHelper.wrappers import add_method
from lambdasdk.lambdasdk import Lambda
from awsSchema.apigateway import Event, Response
from nicHelper.dictUtil import printDict
from nicHelper.exception import errorString
from dataclasses import dataclass
from dataclasses_json import dataclass_json
from typing import Optional

# Cell
class FunctionName:
  def __init__(self, branch, appName):
    self.branch = branch; self.appName=appName
  def getName(self,function):
    return f'{self.appName}-{self.branch}-{function}'

class AuthSdk:
  def __init__(
    self,
    user = None,
    pw = None,
    sessionToken = None,
    region = 'ap-southeast-1',
    branch = 'dev-blank',
    appName = 'villa-employee'
    ):
    self.lambda_ = Lambda(user = user, pw = pw, sessionToken= sessionToken, region = region)
    self.functionName = FunctionName(branch, appName)

  def generalInvoke(self, body={}, function= 'unauth'):
    functionName = self.functionName.getName(function)
    event = Event.getInput(body=body)
    response = self.lambda_.invoke(functionName=functionName, input=event)
    try: return Response.parseBody(response)
    except: return response


# Cell
@dataclass_json
@dataclass
class CreateCashier:
  user: str
  phone: str
  pw: str
  name: str
  cashierCode: str
  email: Optional[str] = None

@add_method(AuthSdk)
def createCashier(self,data={}, function= 'createCashier'):
  payload = CreateCashier(**data).to_dict()
  return self.generalInvoke(body=payload,function=function)

# Cell
@dataclass_json
@dataclass
class Auth:
  user: str
  pw: str
@add_method(AuthSdk)
def auth(self,user,pw, function= 'auth'):
  payload = Auth(user=user, pw=pw).to_dict()
  return self.generalInvoke(body=payload,function=function)

# Cell
@dataclass_json
@dataclass
class Confirm:
  user: str
  code: str
@add_method(AuthSdk)
def confirm(self,user:str, code:str, function:str='confirm', **kwargs):
  payload = Confirm(user=user, code=code).to_dict()
  return self.generalInvoke(body=payload, function=function)

# Cell
@dataclass_json
@dataclass
class GetProfile:
  user: str

@add_method(AuthSdk)
def getProfile(self,user:str, function:str='getProfile', **kwargs):
  payload = GetProfile(user=user).to_dict()
  return self.generalInvoke(body=payload, function=function)

# Cell
@dataclass_json
@dataclass
class UpdateProfile:
  user: str
  attributes: dict

@add_method(AuthSdk)
def updateProfile(self,user:str, attributes:dict, function:str='updateProfile', **kwargs):
  payload = UpdateProfile(user=user, attributes=attributes).to_dict()
  return self.generalInvoke(body=payload, function=function)

# Cell
@dataclass_json
@dataclass
class SetPassword:
  user: str
  pw: str

@add_method(AuthSdk)
def setPassword(self,user:str, pw:str, function:str='setPassword', **kwargs):
  payload = SetPassword(user=user, pw=pw).to_dict()
  return self.generalInvoke(body=payload, function=function)

# Cell
@add_method(AuthSdk)
def unauth(self, function:str='unauth', **kwargs):
  return self.generalInvoke(body={}, function=function)

# Cell
@dataclass_json
@dataclass
class DeleteUser:
  user: str

@add_method(AuthSdk)
def deleteUser(self,user:str, function:str='deleteUser', **kwargs):
  payload = DeleteUser(user=user).to_dict()
  return self.generalInvoke(body=payload, function=function)