# mollie-cli

[![PyPI - Version](https://img.shields.io/pypi/v/mollie-cli.svg)](https://pypi.org/project/mollie-cli)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mollie-cli.svg)](https://pypi.org/project/mollie-cli)

-----

**Table of Contents**

- [About Mollie CLI](#about)
- [Features](#features)
- [Installation](#installation)
- [Examples](#examples)
- [License](#license)

## About

Mollie CLI is a simple command-line client, designed to send requests to the Mollie
API and return data in an easily readable format. It can be used to have a quick look
into your Mollie data, or to test your authentication credentials: it supports all 
authentication methods that Mollie provides (API key, access token and OAuth2).

This tool could be useful to developers working with Mollie, for quick insights
into the data state on the Mollie side of things.

## Features

Currently the following features are supported:

- Authentication using API key, access token or OAuth2 flow (Oauth2 needs help of an external tunnel tool like [pagekite](https://pagekite.net) or [ngrok](https://ngrok.com))
- Authentication credentials can be provided using the CLI or with environment variables
- Data retrieval from simple sources (chargebacks, clients, customers, invoices, orders, organizations, payment links, payments, profiles, refunds, settlements, subscriptions)
- Output in a nicely formatted table on the CLI, or in JSON or CSV, which can be saved to a file using regular shell interaction (e.g. `mollie-cli -f csv list payments > payments.csv`)

### Possible future additions

- Retrieval of nested data from the API (e.g. [payment->refund](https://docs.mollie.com/reference/v2/refunds-api/get-payment-refund_))
- Fully automated OAuth2 flow
- More output formats, if needed
- Creation of new data (e.g. create a new payment), possible with a guided interface: the CLI presents all required fields and checks for correct datatypes etc before sending it to Mollie
- [You name it](https://github.com/whyscream/mollie-cli/issues)

## Installation

```console
pip install mollie-cli
```

## Examples

```console
$ mollie-cli --help
Usage: mollie-cli [OPTIONS] COMMAND [ARGS]...

Options:
  --version                      Show the version and exit.
  -f, --format [table|json|csv]  Change output formatting
  --help                         Show this message and exit.

Commands:
  apikey  Connect to Mollie using an api key
  oauth   Connect to Mollie using OAuth2.0
  token   Connect to Mollie using an access token

$ mollie-cli apikey --help
Usage: mollie-cli apikey [OPTIONS] COMMAND [ARGS]...

  Connect to Mollie using an api key

Options:
  -k, --key TEXT  The Mollie API key to use for authentication  [required]
  --help          Show this message and exit.

Commands:
  get   Retrieve a single item by resource ID
  list  List items by resource name

$ mollie-cli apikey --key <apikey> list payments --limit 3

List of payments:

╒═══════════════╤═════════════════════════════════════════╤══════════╤═══════════════════════════╕
│ ID            │ Amount                                  │ Status   │ Paid at                   │
╞═══════════════╪═════════════════════════════════════════╪══════════╪═══════════════════════════╡
│ tr_bN<...>fJG │ {'value': '1568.16', 'currency': 'EUR'} │ paid     │ 2022-03-22T10:08:18+00:00 │
├───────────────┼─────────────────────────────────────────┼──────────┼───────────────────────────┤
│ tr_A5<...>pCx │ {'value': '25.00', 'currency': 'EUR'}   │ pending  │                           │
├───────────────┼─────────────────────────────────────────┼──────────┼───────────────────────────┤
│ tr_fH<...>WAQ │ {'value': '810.00', 'currency': 'EUR'}  │ pending  │                           │
╘═══════════════╧═════════════════════════════════════════╧══════════╧═══════════════════════════╛

$ mollie-cli apikey -k <apikey> get <paymentid>

Properties of payment with id tr_bN<...>fJG:

╒════════════════════════╤════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╕
│ Property               │ Value                                                                                                                                          │
╞════════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
│ amount                 │ {'value': '1568.16', 'currency': 'EUR'}                                                                                                        │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ amount_captured        │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ amount_chargedback     │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ amount_refunded        │ {'value': '0.00', 'currency': 'EUR'}                                                                                                           │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ amount_remaining       │ {'value': '1568.16', 'currency': 'EUR'}                                                                                                        │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ application_fee        │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ authorized_at          │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ canceled_at            │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ changepaymentstate_url │ https://www.mollie.com/checkout/test-mode?method=ideal&token=3.9xh6dq                                                                          │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ checkout_url           │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ country_code           │ NL                                                                                                                                             │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ created_at             │ 2022-03-22T10:07:33+00:00                                                                                                                      │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ customer_id            │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ description            │ Order 2431                                                                                                                                     │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ details                │ {'consumerName': 'T. TEST', 'consumerAccount': 'NL83RABO0012345678', 'consumerBic': 'RABONL2U'}                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ expired_at             │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ expires_at             │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ failed_at              │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ id                     │ tr_bN<...>fJG                                                                                                                                  │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ is_cancelable          │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ locale                 │ nl_NL                                                                                                                                          │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ mandate_id             │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ metadata               │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ method                 │ ideal                                                                                                                                          │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ mode                   │ test                                                                                                                                           │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ order_id               │ ord_k<...>4                                                                                                                                    │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ paid_at                │ 2022-03-22T10:08:18+00:00                                                                                                                      │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ payonline_url          │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ profile_id             │ pfl_pb<...>eDF                                                                                                                                 │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ redirect_url           │ https://example.org/mollie/eysabcjhdshjescbnxvbchshvbV0dXJuX3VybCI6bnVsbH0:1nWbQL:efsdghfjsdghfsdfgjshgfsG_yE5FYuThL3fZtY-nos/return/          │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ resource               │ payment                                                                                                                                        │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ routing                │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ sequence_type          │ oneoff                                                                                                                                         │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ settlement_amount      │ {'value': '1568.16', 'currency': 'EUR'}                                                                                                        │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ settlement_id          │                                                                                                                                                │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ status                 │ paid                                                                                                                                           │
├────────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ webhook_url            │                                                                                                                                                │
╘════════════════════════╧════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════╛

```

## License

`mollie-cli` is distributed under the terms of the [MIT](https://spdx.org/licenses/MIT.html) license.
