# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AppDto(_serialization.Model):
    """AppDto.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar key: Required.
    :vartype key: str
    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    :ivar accessible_by_suppliers: Required.
    :vartype accessible_by_suppliers: bool
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "key": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "description": {"required": True, "min_length": 1},
        "private_app": {"required": True},
        "accessible_by_suppliers": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
        "accessible_by_suppliers": {"key": "accessibleBySuppliers", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        key: str,
        name: str,
        description: str,
        private_app: bool,
        accessible_by_suppliers: bool,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword key: Required.
        :paramtype key: str
        :keyword name: Required.
        :paramtype name: str
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        :keyword accessible_by_suppliers: Required.
        :paramtype accessible_by_suppliers: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.key = key
        self.name = name
        self.description = description
        self.private_app = private_app
        self.accessible_by_suppliers = accessible_by_suppliers


class AzureRegionDto(_serialization.Model):
    """AzureRegionDto.

    All required parameters must be populated in order to send to server.

    :ivar display_name: Required.
    :vartype display_name: str
    :ivar name: Required.
    :vartype name: str
    :ivar region_display_name: Required.
    :vartype region_display_name: str
    """

    _validation = {
        "display_name": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "region_display_name": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "region_display_name": {"key": "regionDisplayName", "type": "str"},
    }

    def __init__(self, *, display_name: str, name: str, region_display_name: str, **kwargs: Any) -> None:
        """
        :keyword display_name: Required.
        :paramtype display_name: str
        :keyword name: Required.
        :paramtype name: str
        :keyword region_display_name: Required.
        :paramtype region_display_name: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.name = name
        self.region_display_name = region_display_name


class CdfClusterDto(_serialization.Model):
    """CdfClusterDto.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar name: Required.
    :vartype name: str
    :ivar base_url: Required.
    :vartype base_url: str
    :ivar scope: Required.
    :vartype scope: str
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "base_url": {"required": True, "min_length": 1},
        "scope": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "base_url": {"key": "baseUrl", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self, *, id: str, name: str, base_url: str, scope: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword scope: Required.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.base_url = base_url
        self.scope = scope


class CdfConfigDto(_serialization.Model):
    """CdfConfigDto.

    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar client_id:
    :vartype client_id: str
    :ivar client_secret_exists:
    :vartype client_secret_exists: bool
    """

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_exists": {"key": "clientSecretExists", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret_exists: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword client_id:
        :paramtype client_id: str
        :keyword client_secret_exists:
        :paramtype client_secret_exists: bool
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.client_id = client_id
        self.client_secret_exists = client_secret_exists


class CdfDetailsDto(_serialization.Model):
    """CdfDetailsDto.

    All required parameters must be populated in order to send to server.

    :ivar project: Required.
    :vartype project: str
    :ivar base_url: Required.
    :vartype base_url: str
    :ivar client_id: Required.
    :vartype client_id: str
    :ivar client_secret_exists: Required.
    :vartype client_secret_exists: bool
    :ivar token_scopes: Required.
    :vartype token_scopes: str
    :ivar token_url: Required.
    :vartype token_url: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        "project": {"required": True, "min_length": 1},
        "base_url": {"required": True, "min_length": 1},
        "client_id": {"required": True, "min_length": 1},
        "client_secret_exists": {"required": True},
        "token_scopes": {"required": True, "min_length": 1},
        "token_url": {"required": True, "min_length": 1},
        "customer_managed_cdf": {"required": True},
    }

    _attribute_map = {
        "project": {"key": "project", "type": "str"},
        "base_url": {"key": "baseUrl", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_exists": {"key": "clientSecretExists", "type": "bool"},
        "token_scopes": {"key": "tokenScopes", "type": "str"},
        "token_url": {"key": "tokenUrl", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        *,
        project: str,
        base_url: str,
        client_id: str,
        client_secret_exists: bool,
        token_scopes: str,
        token_url: str,
        customer_managed_cdf: bool,
        **kwargs: Any
    ) -> None:
        """
        :keyword project: Required.
        :paramtype project: str
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword client_secret_exists: Required.
        :paramtype client_secret_exists: bool
        :keyword token_scopes: Required.
        :paramtype token_scopes: str
        :keyword token_url: Required.
        :paramtype token_url: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super().__init__(**kwargs)
        self.project = project
        self.base_url = base_url
        self.client_id = client_id
        self.client_secret_exists = client_secret_exists
        self.token_scopes = token_scopes
        self.token_url = token_url
        self.customer_managed_cdf = customer_managed_cdf


class ComponentSettingsDto(_serialization.Model):
    """ComponentSettingsDto.

    :ivar component_id:
    :vartype component_id: str
    :ivar disabled_fields:
    :vartype disabled_fields: list[str]
    """

    _attribute_map = {
        "component_id": {"key": "componentId", "type": "str"},
        "disabled_fields": {"key": "disabledFields", "type": "[str]"},
    }

    def __init__(
        self, *, component_id: Optional[str] = None, disabled_fields: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword component_id:
        :paramtype component_id: str
        :keyword disabled_fields:
        :paramtype disabled_fields: list[str]
        """
        super().__init__(**kwargs)
        self.component_id = component_id
        self.disabled_fields = disabled_fields


class ContactPersonDto(_serialization.Model):
    """ContactPersonDto.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar phone: Required.
    :vartype phone: str
    :ivar email: Required.
    :vartype email: str
    """

    _validation = {
        "name": {"required": True, "min_length": 1},
        "phone": {"required": True, "min_length": 1},
        "email": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(self, *, name: str, phone: str, email: str, **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword phone: Required.
        :paramtype phone: str
        :keyword email: Required.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.phone = phone
        self.email = email


class CountryDto(_serialization.Model):
    """CountryDto.

    All required parameters must be populated in order to send to server.

    :ivar two_letter_iso_region_name: Required.
    :vartype two_letter_iso_region_name: str
    :ivar three_letter_iso_region_name: Required.
    :vartype three_letter_iso_region_name: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "two_letter_iso_region_name": {"required": True, "min_length": 1},
        "three_letter_iso_region_name": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "two_letter_iso_region_name": {"key": "twoLetterISORegionName", "type": "str"},
        "three_letter_iso_region_name": {"key": "threeLetterISORegionName", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, two_letter_iso_region_name: str, three_letter_iso_region_name: str, name: str, **kwargs: Any
    ) -> None:
        """
        :keyword two_letter_iso_region_name: Required.
        :paramtype two_letter_iso_region_name: str
        :keyword three_letter_iso_region_name: Required.
        :paramtype three_letter_iso_region_name: str
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.two_letter_iso_region_name = two_letter_iso_region_name
        self.three_letter_iso_region_name = three_letter_iso_region_name
        self.name = name


class CreateApp(_serialization.Model):
    """CreateApp.

    All required parameters must be populated in order to send to server.

    :ivar key: Required.
    :vartype key: str
    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    :ivar accessible_by_suppliers: Required.
    :vartype accessible_by_suppliers: bool
    """

    _validation = {
        "key": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "description": {"required": True, "min_length": 1},
        "private_app": {"required": True},
        "accessible_by_suppliers": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
        "accessible_by_suppliers": {"key": "accessibleBySuppliers", "type": "bool"},
    }

    def __init__(
        self, *, key: str, name: str, description: str, private_app: bool, accessible_by_suppliers: bool, **kwargs: Any
    ) -> None:
        """
        :keyword key: Required.
        :paramtype key: str
        :keyword name: Required.
        :paramtype name: str
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        :keyword accessible_by_suppliers: Required.
        :paramtype accessible_by_suppliers: bool
        """
        super().__init__(**kwargs)
        self.key = key
        self.name = name
        self.description = description
        self.private_app = private_app
        self.accessible_by_suppliers = accessible_by_suppliers


class CreateCdfCluster(_serialization.Model):
    """CreateCdfCluster.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar base_url: Required.
    :vartype base_url: str
    :ivar scope: Required.
    :vartype scope: str
    """

    _validation = {
        "name": {"required": True, "min_length": 1},
        "base_url": {"required": True, "min_length": 1},
        "scope": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "base_url": {"key": "baseUrl", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(self, *, name: str, base_url: str, scope: str, **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword scope: Required.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.base_url = base_url
        self.scope = scope


class CreateIgnosCustomer(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """CreateIgnosCustomer.

    All required parameters must be populated in order to send to server.

    :ivar short_name: Required.
    :vartype short_name: str
    :ivar name: Required.
    :vartype name: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar azure_ad_tenant_id:
    :vartype azure_ad_tenant_id: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar external_reference:
    :vartype external_reference: str
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        "short_name": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "azure_region_id": {"required": True, "min_length": 1},
        "contact_person": {"required": True},
        "three_letter_iso_country": {"required": True, "min_length": 1},
        "customer_managed_cdf": {"required": True},
    }

    _attribute_map = {
        "short_name": {"key": "shortName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        *,
        short_name: str,
        name: str,
        azure_region_id: str,
        contact_person: "_models.ContactPersonDto",
        three_letter_iso_country: str,
        customer_managed_cdf: bool,
        azure_ad_tenant_id: Optional[str] = None,
        external_reference: Optional[str] = None,
        logo_url: Optional[str] = None,
        company_url: Optional[str] = None,
        domain: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword short_name: Required.
        :paramtype short_name: str
        :keyword name: Required.
        :paramtype name: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword azure_ad_tenant_id:
        :paramtype azure_ad_tenant_id: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super().__init__(**kwargs)
        self.short_name = short_name
        self.name = name
        self.azure_region_id = azure_region_id
        self.azure_ad_tenant_id = azure_ad_tenant_id
        self.contact_person = contact_person
        self.external_reference = external_reference
        self.three_letter_iso_country = three_letter_iso_country
        self.logo_url = logo_url
        self.company_url = company_url
        self.domain = domain
        self.customer_managed_cdf = customer_managed_cdf


class CreatePowerRegion(_serialization.Model):
    """CreatePowerRegion.

    All required parameters must be populated in order to send to server.

    :ivar country: Required.
    :vartype country: str
    :ivar region: Required.
    :vartype region: str
    :ivar description: Required.
    :vartype description: str
    :ivar initial_co2_per_kwh_date:
    :vartype initial_co2_per_kwh_date: ~datetime.datetime
    :ivar co2_per_kwh:
    :vartype co2_per_kwh: int
    """

    _validation = {
        "country": {"required": True, "min_length": 1},
        "region": {"required": True, "min_length": 1},
        "description": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "country": {"key": "country", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "initial_co2_per_kwh_date": {"key": "initialCo2PerKwhDate", "type": "iso-8601"},
        "co2_per_kwh": {"key": "co2PerKwh", "type": "int"},
    }

    def __init__(
        self,
        *,
        country: str,
        region: str,
        description: str,
        initial_co2_per_kwh_date: Optional[datetime.datetime] = None,
        co2_per_kwh: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword country: Required.
        :paramtype country: str
        :keyword region: Required.
        :paramtype region: str
        :keyword description: Required.
        :paramtype description: str
        :keyword initial_co2_per_kwh_date:
        :paramtype initial_co2_per_kwh_date: ~datetime.datetime
        :keyword co2_per_kwh:
        :paramtype co2_per_kwh: int
        """
        super().__init__(**kwargs)
        self.country = country
        self.region = region
        self.description = description
        self.initial_co2_per_kwh_date = initial_co2_per_kwh_date
        self.co2_per_kwh = co2_per_kwh


class CreateTenantRequest(_serialization.Model):
    """CreateTenantRequest.

    All required parameters must be populated in order to send to server.

    :ivar description:
    :vartype description: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar contact_person:
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
    :vartype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    :ivar cdf_cluster_id:
    :vartype cdf_cluster_id: str
    """

    _validation = {
        "azure_region_id": {"required": True, "min_length": 1},
        "environment": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "environment": {"key": "environment", "type": "str"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
        "cdf_cluster_id": {"key": "cdfClusterId", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_region_id: str,
        environment: Union[str, "_models.TenantEnvironment"],
        description: Optional[str] = None,
        contact_person: Optional["_models.ContactPersonDto"] = None,
        cdf_tenant: Optional[str] = None,
        cdf_cluster_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description:
        :paramtype description: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword contact_person:
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
        :paramtype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        :keyword cdf_cluster_id:
        :paramtype cdf_cluster_id: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.azure_region_id = azure_region_id
        self.contact_person = contact_person
        self.environment = environment
        self.cdf_tenant = cdf_tenant
        self.cdf_cluster_id = cdf_cluster_id


class CustomerAppDto(_serialization.Model):
    """CustomerAppDto.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar key: Required.
    :vartype key: str
    :ivar name: Required.
    :vartype name: str
    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "key": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "description": {"required": True, "min_length": 1},
        "private_app": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        key: str,
        name: str,
        description: str,
        private_app: bool,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword key: Required.
        :paramtype key: str
        :keyword name: Required.
        :paramtype name: str
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.key = key
        self.name = name
        self.description = description
        self.private_app = private_app


class DataSyncOrchestrationConfig(_serialization.Model):
    """DataSyncOrchestrationConfig.

    :ivar sync_companies:
    :vartype sync_companies: bool
    :ivar sync_resources:
    :vartype sync_resources: bool
    :ivar sync_work_orders:
    :vartype sync_work_orders: bool
    :ivar sync_deviations:
    :vartype sync_deviations: bool
    :ivar include_work_activities:
    :vartype include_work_activities: bool
    :ivar work_order_sync_batch_size:
    :vartype work_order_sync_batch_size: int
    """

    _attribute_map = {
        "sync_companies": {"key": "syncCompanies", "type": "bool"},
        "sync_resources": {"key": "syncResources", "type": "bool"},
        "sync_work_orders": {"key": "syncWorkOrders", "type": "bool"},
        "sync_deviations": {"key": "syncDeviations", "type": "bool"},
        "include_work_activities": {"key": "includeWorkActivities", "type": "bool"},
        "work_order_sync_batch_size": {"key": "workOrderSyncBatchSize", "type": "int"},
    }

    def __init__(
        self,
        *,
        sync_companies: Optional[bool] = None,
        sync_resources: Optional[bool] = None,
        sync_work_orders: Optional[bool] = None,
        sync_deviations: Optional[bool] = None,
        include_work_activities: Optional[bool] = None,
        work_order_sync_batch_size: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sync_companies:
        :paramtype sync_companies: bool
        :keyword sync_resources:
        :paramtype sync_resources: bool
        :keyword sync_work_orders:
        :paramtype sync_work_orders: bool
        :keyword sync_deviations:
        :paramtype sync_deviations: bool
        :keyword include_work_activities:
        :paramtype include_work_activities: bool
        :keyword work_order_sync_batch_size:
        :paramtype work_order_sync_batch_size: int
        """
        super().__init__(**kwargs)
        self.sync_companies = sync_companies
        self.sync_resources = sync_resources
        self.sync_work_orders = sync_work_orders
        self.sync_deviations = sync_deviations
        self.include_work_activities = include_work_activities
        self.work_order_sync_batch_size = work_order_sync_batch_size


class DataSyncOrchestrationInstance(_serialization.Model):
    """DataSyncOrchestrationInstance.

    :ivar name:
    :vartype name: str
    :ivar instance_id:
    :vartype instance_id: str
    :ivar runtime_status:
    :vartype runtime_status: str
    :ivar input:
    :vartype input: ~ignos.internal.api.client.models.DataSyncOrchestrationConfig
    :ivar output: Anything.
    :vartype output: any
    :ivar created_time:
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time:
    :vartype last_updated_time: ~datetime.datetime
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "runtime_status": {"key": "runtimeStatus", "type": "str"},
        "input": {"key": "input", "type": "DataSyncOrchestrationConfig"},
        "output": {"key": "output", "type": "object"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        instance_id: Optional[str] = None,
        runtime_status: Optional[str] = None,
        input: Optional["_models.DataSyncOrchestrationConfig"] = None,
        output: Optional[Any] = None,
        created_time: Optional[datetime.datetime] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword instance_id:
        :paramtype instance_id: str
        :keyword runtime_status:
        :paramtype runtime_status: str
        :keyword input:
        :paramtype input: ~ignos.internal.api.client.models.DataSyncOrchestrationConfig
        :keyword output: Anything.
        :paramtype output: any
        :keyword created_time:
        :paramtype created_time: ~datetime.datetime
        :keyword last_updated_time:
        :paramtype last_updated_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.name = name
        self.instance_id = instance_id
        self.runtime_status = runtime_status
        self.input = input
        self.output = output
        self.created_time = created_time
        self.last_updated_time = last_updated_time


class DataSyncOrchestrationTriggerResponse(_serialization.Model):
    """DataSyncOrchestrationTriggerResponse.

    :ivar id:
    :vartype id: str
    :ivar purge_history_delete_uri:
    :vartype purge_history_delete_uri: str
    :ivar send_event_post_uri:
    :vartype send_event_post_uri: str
    :ivar status_query_get_uri:
    :vartype status_query_get_uri: str
    :ivar terminate_post_uri:
    :vartype terminate_post_uri: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "purge_history_delete_uri": {"key": "purgeHistoryDeleteUri", "type": "str"},
        "send_event_post_uri": {"key": "sendEventPostUri", "type": "str"},
        "status_query_get_uri": {"key": "statusQueryGetUri", "type": "str"},
        "terminate_post_uri": {"key": "terminatePostUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        purge_history_delete_uri: Optional[str] = None,
        send_event_post_uri: Optional[str] = None,
        status_query_get_uri: Optional[str] = None,
        terminate_post_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword purge_history_delete_uri:
        :paramtype purge_history_delete_uri: str
        :keyword send_event_post_uri:
        :paramtype send_event_post_uri: str
        :keyword status_query_get_uri:
        :paramtype status_query_get_uri: str
        :keyword terminate_post_uri:
        :paramtype terminate_post_uri: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.purge_history_delete_uri = purge_history_delete_uri
        self.send_event_post_uri = send_event_post_uri
        self.status_query_get_uri = status_query_get_uri
        self.terminate_post_uri = terminate_post_uri


class ErpSyncErrorDto(_serialization.Model):
    """ErpSyncErrorDto.

    :ivar entity:
    :vartype entity: str
    :ivar id:
    :vartype id: str
    :ivar company_id:
    :vartype company_id: str
    :ivar retry_attempts:
    :vartype retry_attempts: int
    :ivar row_key:
    :vartype row_key: str
    :ivar partition_key:
    :vartype partition_key: str
    :ivar timestamp:
    :vartype timestamp: ~datetime.datetime
    """

    _attribute_map = {
        "entity": {"key": "entity", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "company_id": {"key": "companyId", "type": "str"},
        "retry_attempts": {"key": "retryAttempts", "type": "int"},
        "row_key": {"key": "rowKey", "type": "str"},
        "partition_key": {"key": "partitionKey", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        entity: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        company_id: Optional[str] = None,
        retry_attempts: Optional[int] = None,
        row_key: Optional[str] = None,
        partition_key: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity:
        :paramtype entity: str
        :keyword id:
        :paramtype id: str
        :keyword company_id:
        :paramtype company_id: str
        :keyword retry_attempts:
        :paramtype retry_attempts: int
        :keyword row_key:
        :paramtype row_key: str
        :keyword partition_key:
        :paramtype partition_key: str
        :keyword timestamp:
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.entity = entity
        self.id = id
        self.company_id = company_id
        self.retry_attempts = retry_attempts
        self.row_key = row_key
        self.partition_key = partition_key
        self.timestamp = timestamp


class ErpSyncErrorMessage(_serialization.Model):
    """ErpSyncErrorMessage.

    :ivar stack_trace:
    :vartype stack_trace: str
    """

    _attribute_map = {
        "stack_trace": {"key": "stackTrace", "type": "str"},
    }

    def __init__(self, *, stack_trace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword stack_trace:
        :paramtype stack_trace: str
        """
        super().__init__(**kwargs)
        self.stack_trace = stack_trace


class IgnosCustomerDto(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """IgnosCustomerDto.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar short_name: Required.
    :vartype short_name: str
    :ivar name: Required.
    :vartype name: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar azure_region_name: Required.
    :vartype azure_region_name: str
    :ivar azure_ad_tenant_id:
    :vartype azure_ad_tenant_id: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar number_of_tenants: Required.
    :vartype number_of_tenants: int
    :ivar external_reference:
    :vartype external_reference: str
    :ivar status: Required. Known values are: "Draft", "Active", and "Deactivated".
    :vartype status: str or ~ignos.internal.api.client.models.CustomerStatusDto
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar country: Required.
    :vartype country: str
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        "id": {"required": True, "min_length": 1},
        "short_name": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "azure_region_id": {"required": True, "min_length": 1},
        "azure_region_name": {"required": True, "min_length": 1},
        "contact_person": {"required": True},
        "number_of_tenants": {"required": True},
        "status": {"required": True},
        "three_letter_iso_country": {"required": True, "min_length": 1},
        "country": {"required": True, "min_length": 1},
        "customer_managed_cdf": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "short_name": {"key": "shortName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "azure_region_name": {"key": "azureRegionName", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "number_of_tenants": {"key": "numberOfTenants", "type": "int"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        short_name: str,
        name: str,
        azure_region_id: str,
        azure_region_name: str,
        contact_person: "_models.ContactPersonDto",
        number_of_tenants: int,
        status: Union[str, "_models.CustomerStatusDto"],
        three_letter_iso_country: str,
        country: str,
        customer_managed_cdf: bool,
        azure_ad_tenant_id: Optional[str] = None,
        external_reference: Optional[str] = None,
        logo_url: Optional[str] = None,
        company_url: Optional[str] = None,
        domain: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword short_name: Required.
        :paramtype short_name: str
        :keyword name: Required.
        :paramtype name: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword azure_region_name: Required.
        :paramtype azure_region_name: str
        :keyword azure_ad_tenant_id:
        :paramtype azure_ad_tenant_id: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword number_of_tenants: Required.
        :paramtype number_of_tenants: int
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword status: Required. Known values are: "Draft", "Active", and "Deactivated".
        :paramtype status: str or ~ignos.internal.api.client.models.CustomerStatusDto
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword country: Required.
        :paramtype country: str
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super().__init__(**kwargs)
        self.id = id
        self.short_name = short_name
        self.name = name
        self.azure_region_id = azure_region_id
        self.azure_region_name = azure_region_name
        self.azure_ad_tenant_id = azure_ad_tenant_id
        self.contact_person = contact_person
        self.number_of_tenants = number_of_tenants
        self.external_reference = external_reference
        self.status = status
        self.three_letter_iso_country = three_letter_iso_country
        self.country = country
        self.logo_url = logo_url
        self.company_url = company_url
        self.domain = domain
        self.customer_managed_cdf = customer_managed_cdf


class InitFactoryTemplateFerroAmpRequest(_serialization.Model):
    """InitFactoryTemplateFerroAmpRequest.

    All required parameters must be populated in order to send to server.

    :ivar factory_asset_external_id: Required.
    :vartype factory_asset_external_id: str
    """

    _validation = {
        "factory_asset_external_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "factory_asset_external_id": {"key": "factoryAssetExternalId", "type": "str"},
    }

    def __init__(self, *, factory_asset_external_id: str, **kwargs: Any) -> None:
        """
        :keyword factory_asset_external_id: Required.
        :paramtype factory_asset_external_id: str
        """
        super().__init__(**kwargs)
        self.factory_asset_external_id = factory_asset_external_id


class InitFactoryTemplateRequest(_serialization.Model):
    """InitFactoryTemplateRequest.

    All required parameters must be populated in order to send to server.

    :ivar factory_asset_external_id: Required.
    :vartype factory_asset_external_id: str
    :ivar grid_region: Required.
    :vartype grid_region: str
    """

    _validation = {
        "factory_asset_external_id": {"required": True, "min_length": 1},
        "grid_region": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "factory_asset_external_id": {"key": "factoryAssetExternalId", "type": "str"},
        "grid_region": {"key": "gridRegion", "type": "str"},
    }

    def __init__(self, *, factory_asset_external_id: str, grid_region: str, **kwargs: Any) -> None:
        """
        :keyword factory_asset_external_id: Required.
        :paramtype factory_asset_external_id: str
        :keyword grid_region: Required.
        :paramtype grid_region: str
        """
        super().__init__(**kwargs)
        self.factory_asset_external_id = factory_asset_external_id
        self.grid_region = grid_region


class InitFerroAmpRequest(_serialization.Model):
    """InitFerroAmpRequest.

    All required parameters must be populated in order to send to server.

    :ivar asset_external_id: Required.
    :vartype asset_external_id: str
    :ivar asset_name: Required.
    :vartype asset_name: str
    :ivar factory_asset_external_id: Required.
    :vartype factory_asset_external_id: str
    :ivar has_solar_panels:
    :vartype has_solar_panels: bool
    """

    _validation = {
        "asset_external_id": {"required": True, "min_length": 1},
        "asset_name": {"required": True, "min_length": 1},
        "factory_asset_external_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "asset_external_id": {"key": "assetExternalId", "type": "str"},
        "asset_name": {"key": "assetName", "type": "str"},
        "factory_asset_external_id": {"key": "factoryAssetExternalId", "type": "str"},
        "has_solar_panels": {"key": "hasSolarPanels", "type": "bool"},
    }

    def __init__(
        self,
        *,
        asset_external_id: str,
        asset_name: str,
        factory_asset_external_id: str,
        has_solar_panels: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword asset_external_id: Required.
        :paramtype asset_external_id: str
        :keyword asset_name: Required.
        :paramtype asset_name: str
        :keyword factory_asset_external_id: Required.
        :paramtype factory_asset_external_id: str
        :keyword has_solar_panels:
        :paramtype has_solar_panels: bool
        """
        super().__init__(**kwargs)
        self.asset_external_id = asset_external_id
        self.asset_name = asset_name
        self.factory_asset_external_id = factory_asset_external_id
        self.has_solar_panels = has_solar_panels


class PowerRegionDto(_serialization.Model):
    """PowerRegionDto.

    :ivar id:
    :vartype id: str
    :ivar country:
    :vartype country: str
    :ivar region:
    :vartype region: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        country: Optional[str] = None,
        region: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword country:
        :paramtype country: str
        :keyword region:
        :paramtype region: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.country = country
        self.region = region
        self.description = description


class RewindInstance(_serialization.Model):
    """RewindInstance.

    :ivar instance_id:
    :vartype instance_id: str
    :ivar reason:
    :vartype reason: str
    """

    _attribute_map = {
        "instance_id": {"key": "instanceId", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, instance_id: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword instance_id:
        :paramtype instance_id: str
        :keyword reason:
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.instance_id = instance_id
        self.reason = reason


class SaveComponentSettingsRequest(_serialization.Model):
    """SaveComponentSettingsRequest.

    All required parameters must be populated in order to send to server.

    :ivar disabled_fields: Required.
    :vartype disabled_fields: list[str]
    """

    _validation = {
        "disabled_fields": {"required": True},
    }

    _attribute_map = {
        "disabled_fields": {"key": "disabledFields", "type": "[str]"},
    }

    def __init__(self, *, disabled_fields: List[str], **kwargs: Any) -> None:
        """
        :keyword disabled_fields: Required.
        :paramtype disabled_fields: list[str]
        """
        super().__init__(**kwargs)
        self.disabled_fields = disabled_fields


class StartFullSync(_serialization.Model):
    """StartFullSync.

    :ivar sync_companies:
    :vartype sync_companies: bool
    :ivar sync_resources:
    :vartype sync_resources: bool
    :ivar sync_work_orders:
    :vartype sync_work_orders: bool
    :ivar sync_deviations:
    :vartype sync_deviations: bool
    :ivar include_work_activities:
    :vartype include_work_activities: bool
    :ivar work_order_sync_batch_size:
    :vartype work_order_sync_batch_size: int
    """

    _attribute_map = {
        "sync_companies": {"key": "syncCompanies", "type": "bool"},
        "sync_resources": {"key": "syncResources", "type": "bool"},
        "sync_work_orders": {"key": "syncWorkOrders", "type": "bool"},
        "sync_deviations": {"key": "syncDeviations", "type": "bool"},
        "include_work_activities": {"key": "includeWorkActivities", "type": "bool"},
        "work_order_sync_batch_size": {"key": "workOrderSyncBatchSize", "type": "int"},
    }

    def __init__(
        self,
        *,
        sync_companies: Optional[bool] = None,
        sync_resources: Optional[bool] = None,
        sync_work_orders: Optional[bool] = None,
        sync_deviations: Optional[bool] = None,
        include_work_activities: Optional[bool] = None,
        work_order_sync_batch_size: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sync_companies:
        :paramtype sync_companies: bool
        :keyword sync_resources:
        :paramtype sync_resources: bool
        :keyword sync_work_orders:
        :paramtype sync_work_orders: bool
        :keyword sync_deviations:
        :paramtype sync_deviations: bool
        :keyword include_work_activities:
        :paramtype include_work_activities: bool
        :keyword work_order_sync_batch_size:
        :paramtype work_order_sync_batch_size: int
        """
        super().__init__(**kwargs)
        self.sync_companies = sync_companies
        self.sync_resources = sync_resources
        self.sync_work_orders = sync_work_orders
        self.sync_deviations = sync_deviations
        self.include_work_activities = include_work_activities
        self.work_order_sync_batch_size = work_order_sync_batch_size


class SyncSingleWorkOrder(_serialization.Model):
    """SyncSingleWorkOrder.

    :ivar company_id:
    :vartype company_id: str
    :ivar work_order_id:
    :vartype work_order_id: str
    """

    _attribute_map = {
        "company_id": {"key": "companyId", "type": "str"},
        "work_order_id": {"key": "workOrderId", "type": "str"},
    }

    def __init__(self, *, company_id: Optional[str] = None, work_order_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword company_id:
        :paramtype company_id: str
        :keyword work_order_id:
        :paramtype work_order_id: str
        """
        super().__init__(**kwargs)
        self.company_id = company_id
        self.work_order_id = work_order_id


class TenantDetailDto(_serialization.Model):
    """TenantDetailDto.

    All required parameters must be populated in order to send to server.

    :ivar tenant_id: Required.
    :vartype tenant_id: str
    :ivar apps: Required.
    :vartype apps: list[~ignos.internal.api.client.models.CustomerAppDto]
    :ivar cdf:
    :vartype cdf: ~ignos.internal.api.client.models.CdfDetailsDto
    """

    _validation = {
        "tenant_id": {"required": True, "min_length": 1},
        "apps": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "apps": {"key": "apps", "type": "[CustomerAppDto]"},
        "cdf": {"key": "cdf", "type": "CdfDetailsDto"},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        apps: List["_models.CustomerAppDto"],
        cdf: Optional["_models.CdfDetailsDto"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: Required.
        :paramtype tenant_id: str
        :keyword apps: Required.
        :paramtype apps: list[~ignos.internal.api.client.models.CustomerAppDto]
        :keyword cdf:
        :paramtype cdf: ~ignos.internal.api.client.models.CdfDetailsDto
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.apps = apps
        self.cdf = cdf


class TenantDto(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """TenantDto.

    All required parameters must be populated in order to send to server.

    :ivar tenant_id: Required.
    :vartype tenant_id: str
    :ivar name: Required.
    :vartype name: str
    :ivar environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
    :vartype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
    :ivar environment_name: Required.
    :vartype environment_name: str
    :ivar description:
    :vartype description: str
    :ivar customer_id: Required.
    :vartype customer_id: str
    :ivar customer_short_name: Required.
    :vartype customer_short_name: str
    :ivar customer_name: Required.
    :vartype customer_name: str
    :ivar azure_region_id: Required.
    :vartype azure_region_id: str
    :ivar azure_region_name: Required.
    :vartype azure_region_name: str
    :ivar azure_ad_tenant_id: Required.
    :vartype azure_ad_tenant_id: str
    :ivar cosmos_database:
    :vartype cosmos_database: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar external_reference:
    :vartype external_reference: str
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar country: Required.
    :vartype country: str
    :ivar status: Required.
    :vartype status: int
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar infrastructure_status: Required. Known values are: 0, 1, 2, and 9.
    :vartype infrastructure_status: int or
     ~ignos.internal.api.client.models.TenantInfrastructureStatus
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    :ivar cdf_tenant_client_id:
    :vartype cdf_tenant_client_id: str
    :ivar tenant_key:
    :vartype tenant_key: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        "tenant_id": {"required": True, "min_length": 1},
        "name": {"required": True, "min_length": 1},
        "environment": {"required": True},
        "environment_name": {"required": True, "min_length": 1},
        "customer_id": {"required": True, "min_length": 1},
        "customer_short_name": {"required": True, "min_length": 1},
        "customer_name": {"required": True, "min_length": 1},
        "azure_region_id": {"required": True, "min_length": 1},
        "azure_region_name": {"required": True, "min_length": 1},
        "azure_ad_tenant_id": {"required": True, "min_length": 1},
        "contact_person": {"required": True},
        "three_letter_iso_country": {"required": True, "min_length": 1},
        "country": {"required": True, "min_length": 1},
        "status": {"required": True},
        "infrastructure_status": {"required": True},
        "customer_managed_cdf": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "environment": {"key": "environment", "type": "str"},
        "environment_name": {"key": "environmentName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "customer_id": {"key": "customerId", "type": "str"},
        "customer_short_name": {"key": "customerShortName", "type": "str"},
        "customer_name": {"key": "customerName", "type": "str"},
        "azure_region_id": {"key": "azureRegionId", "type": "str"},
        "azure_region_name": {"key": "azureRegionName", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "cosmos_database": {"key": "cosmosDatabase", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "status": {"key": "status", "type": "int"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "infrastructure_status": {"key": "infrastructureStatus", "type": "int"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
        "cdf_tenant_client_id": {"key": "cdfTenantClientId", "type": "str"},
        "tenant_key": {"key": "tenantKey", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        tenant_id: str,
        name: str,
        environment: Union[str, "_models.TenantEnvironment"],
        environment_name: str,
        customer_id: str,
        customer_short_name: str,
        customer_name: str,
        azure_region_id: str,
        azure_region_name: str,
        azure_ad_tenant_id: str,
        contact_person: "_models.ContactPersonDto",
        three_letter_iso_country: str,
        country: str,
        status: int,
        infrastructure_status: Union[int, "_models.TenantInfrastructureStatus"],
        customer_managed_cdf: bool,
        description: Optional[str] = None,
        cosmos_database: Optional[str] = None,
        external_reference: Optional[str] = None,
        logo_url: Optional[str] = None,
        company_url: Optional[str] = None,
        domain: Optional[str] = None,
        cdf_tenant: Optional[str] = None,
        cdf_tenant_client_id: Optional[str] = None,
        tenant_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: Required.
        :paramtype tenant_id: str
        :keyword name: Required.
        :paramtype name: str
        :keyword environment: Required. Known values are: "Prod", "QA", "Test", and "Dev".
        :paramtype environment: str or ~ignos.internal.api.client.models.TenantEnvironment
        :keyword environment_name: Required.
        :paramtype environment_name: str
        :keyword description:
        :paramtype description: str
        :keyword customer_id: Required.
        :paramtype customer_id: str
        :keyword customer_short_name: Required.
        :paramtype customer_short_name: str
        :keyword customer_name: Required.
        :paramtype customer_name: str
        :keyword azure_region_id: Required.
        :paramtype azure_region_id: str
        :keyword azure_region_name: Required.
        :paramtype azure_region_name: str
        :keyword azure_ad_tenant_id: Required.
        :paramtype azure_ad_tenant_id: str
        :keyword cosmos_database:
        :paramtype cosmos_database: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword country: Required.
        :paramtype country: str
        :keyword status: Required.
        :paramtype status: int
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword infrastructure_status: Required. Known values are: 0, 1, 2, and 9.
        :paramtype infrastructure_status: int or
         ~ignos.internal.api.client.models.TenantInfrastructureStatus
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        :keyword cdf_tenant_client_id:
        :paramtype cdf_tenant_client_id: str
        :keyword tenant_key:
        :paramtype tenant_key: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.name = name
        self.environment = environment
        self.environment_name = environment_name
        self.description = description
        self.customer_id = customer_id
        self.customer_short_name = customer_short_name
        self.customer_name = customer_name
        self.azure_region_id = azure_region_id
        self.azure_region_name = azure_region_name
        self.azure_ad_tenant_id = azure_ad_tenant_id
        self.cosmos_database = cosmos_database
        self.contact_person = contact_person
        self.external_reference = external_reference
        self.three_letter_iso_country = three_letter_iso_country
        self.country = country
        self.status = status
        self.logo_url = logo_url
        self.company_url = company_url
        self.domain = domain
        self.infrastructure_status = infrastructure_status
        self.cdf_tenant = cdf_tenant
        self.cdf_tenant_client_id = cdf_tenant_client_id
        self.tenant_key = tenant_key
        self.customer_managed_cdf = customer_managed_cdf


class TenantKeyDto(_serialization.Model):
    """TenantKeyDto.

    :ivar key:
    :vartype key: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar tenant_row_key:
    :vartype tenant_row_key: str
    :ivar customer_short_name:
    :vartype customer_short_name: str
    :ivar customer_row_key:
    :vartype customer_row_key: str
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "tenant_row_key": {"key": "tenantRowKey", "type": "str"},
        "customer_short_name": {"key": "customerShortName", "type": "str"},
        "customer_row_key": {"key": "customerRowKey", "type": "str"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        tenant_id: Optional[str] = None,
        tenant_row_key: Optional[str] = None,
        customer_short_name: Optional[str] = None,
        customer_row_key: Optional[str] = None,
        cdf_tenant: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key:
        :paramtype key: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword tenant_row_key:
        :paramtype tenant_row_key: str
        :keyword customer_short_name:
        :paramtype customer_short_name: str
        :keyword customer_row_key:
        :paramtype customer_row_key: str
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.tenant_id = tenant_id
        self.tenant_row_key = tenant_row_key
        self.customer_short_name = customer_short_name
        self.customer_row_key = customer_row_key
        self.cdf_tenant = cdf_tenant


class TerminateInstance(_serialization.Model):
    """TerminateInstance.

    :ivar instance_id:
    :vartype instance_id: str
    :ivar reason:
    :vartype reason: str
    """

    _attribute_map = {
        "instance_id": {"key": "instanceId", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, instance_id: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword instance_id:
        :paramtype instance_id: str
        :keyword reason:
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.instance_id = instance_id
        self.reason = reason


class UpdateAppRequest(_serialization.Model):
    """UpdateAppRequest.

    All required parameters must be populated in order to send to server.

    :ivar description: Required.
    :vartype description: str
    :ivar private_app: Required.
    :vartype private_app: bool
    :ivar accessible_by_suppliers: Required.
    :vartype accessible_by_suppliers: bool
    """

    _validation = {
        "description": {"required": True, "min_length": 1},
        "private_app": {"required": True},
        "accessible_by_suppliers": {"required": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "private_app": {"key": "privateApp", "type": "bool"},
        "accessible_by_suppliers": {"key": "accessibleBySuppliers", "type": "bool"},
    }

    def __init__(self, *, description: str, private_app: bool, accessible_by_suppliers: bool, **kwargs: Any) -> None:
        """
        :keyword description: Required.
        :paramtype description: str
        :keyword private_app: Required.
        :paramtype private_app: bool
        :keyword accessible_by_suppliers: Required.
        :paramtype accessible_by_suppliers: bool
        """
        super().__init__(**kwargs)
        self.description = description
        self.private_app = private_app
        self.accessible_by_suppliers = accessible_by_suppliers


class UpdateCdfClusterRequest(_serialization.Model):
    """UpdateCdfClusterRequest.

    All required parameters must be populated in order to send to server.

    :ivar base_url: Required.
    :vartype base_url: str
    :ivar scope: Required.
    :vartype scope: str
    """

    _validation = {
        "base_url": {"required": True, "min_length": 1},
        "scope": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "base_url": {"key": "baseUrl", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(self, *, base_url: str, scope: str, **kwargs: Any) -> None:
        """
        :keyword base_url: Required.
        :paramtype base_url: str
        :keyword scope: Required.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.base_url = base_url
        self.scope = scope


class UpdateCustomerRequest(_serialization.Model):
    """UpdateCustomerRequest.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar azure_ad_tenant_id:
    :vartype azure_ad_tenant_id: str
    :ivar contact_person: Required.
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar external_reference:
    :vartype external_reference: str
    :ivar three_letter_iso_country: Required.
    :vartype three_letter_iso_country: str
    :ivar logo_url:
    :vartype logo_url: str
    :ivar company_url:
    :vartype company_url: str
    :ivar domain:
    :vartype domain: str
    :ivar customer_managed_cdf: Required.
    :vartype customer_managed_cdf: bool
    """

    _validation = {
        "name": {"required": True, "min_length": 1},
        "contact_person": {"required": True},
        "three_letter_iso_country": {"required": True, "min_length": 1},
        "customer_managed_cdf": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "azure_ad_tenant_id": {"key": "azureAdTenantId", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "external_reference": {"key": "externalReference", "type": "str"},
        "three_letter_iso_country": {"key": "threeLetterIsoCountry", "type": "str"},
        "logo_url": {"key": "logoUrl", "type": "str"},
        "company_url": {"key": "companyUrl", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "customer_managed_cdf": {"key": "customerManagedCdf", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        contact_person: "_models.ContactPersonDto",
        three_letter_iso_country: str,
        customer_managed_cdf: bool,
        azure_ad_tenant_id: Optional[str] = None,
        external_reference: Optional[str] = None,
        logo_url: Optional[str] = None,
        company_url: Optional[str] = None,
        domain: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword azure_ad_tenant_id:
        :paramtype azure_ad_tenant_id: str
        :keyword contact_person: Required.
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword external_reference:
        :paramtype external_reference: str
        :keyword three_letter_iso_country: Required.
        :paramtype three_letter_iso_country: str
        :keyword logo_url:
        :paramtype logo_url: str
        :keyword company_url:
        :paramtype company_url: str
        :keyword domain:
        :paramtype domain: str
        :keyword customer_managed_cdf: Required.
        :paramtype customer_managed_cdf: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.azure_ad_tenant_id = azure_ad_tenant_id
        self.contact_person = contact_person
        self.external_reference = external_reference
        self.three_letter_iso_country = three_letter_iso_country
        self.logo_url = logo_url
        self.company_url = company_url
        self.domain = domain
        self.customer_managed_cdf = customer_managed_cdf


class UpdateTenantCdfConfigRequest(_serialization.Model):
    """UpdateTenantCdfConfigRequest.

    All required parameters must be populated in order to send to server.

    :ivar client_id: Required.
    :vartype client_id: str
    :ivar client_secret:
    :vartype client_secret: str
    """

    _validation = {
        "client_id": {"required": True, "min_length": 1},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
    }

    def __init__(self, *, client_id: str, client_secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword client_secret:
        :paramtype client_secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret


class UpdateTenantRequest(_serialization.Model):
    """UpdateTenantRequest.

    :ivar description:
    :vartype description: str
    :ivar contact_person:
    :vartype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
    :ivar cdf_tenant:
    :vartype cdf_tenant: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "contact_person": {"key": "contactPerson", "type": "ContactPersonDto"},
        "cdf_tenant": {"key": "cdfTenant", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        contact_person: Optional["_models.ContactPersonDto"] = None,
        cdf_tenant: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description:
        :paramtype description: str
        :keyword contact_person:
        :paramtype contact_person: ~ignos.internal.api.client.models.ContactPersonDto
        :keyword cdf_tenant:
        :paramtype cdf_tenant: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.contact_person = contact_person
        self.cdf_tenant = cdf_tenant


class UserDetailsDto(_serialization.Model):
    """UserDetailsDto.

    :ivar id:
    :vartype id: str
    :ivar full_name:
    :vartype full_name: str
    :ivar upn:
    :vartype upn: str
    :ivar roles:
    :vartype roles: list[str]
    :ivar given_name:
    :vartype given_name: str
    :ivar sur_name:
    :vartype sur_name: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar customer_id:
    :vartype customer_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "full_name": {"key": "fullName", "type": "str"},
        "upn": {"key": "upn", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
        "given_name": {"key": "givenName", "type": "str"},
        "sur_name": {"key": "surName", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "customer_id": {"key": "customerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        full_name: Optional[str] = None,
        upn: Optional[str] = None,
        roles: Optional[List[str]] = None,
        given_name: Optional[str] = None,
        sur_name: Optional[str] = None,
        tenant_id: Optional[str] = None,
        customer_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword full_name:
        :paramtype full_name: str
        :keyword upn:
        :paramtype upn: str
        :keyword roles:
        :paramtype roles: list[str]
        :keyword given_name:
        :paramtype given_name: str
        :keyword sur_name:
        :paramtype sur_name: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword customer_id:
        :paramtype customer_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.full_name = full_name
        self.upn = upn
        self.roles = roles
        self.given_name = given_name
        self.sur_name = sur_name
        self.tenant_id = tenant_id
        self.customer_id = customer_id
