# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ...operations._operations import (
    build_apps_create_app_request,
    build_apps_list_apps_request,
    build_apps_update_app_request,
    build_azure_regions_list_azure_regions_request,
    build_cdf_clusters_create_cdf_cluster_request,
    build_cdf_clusters_list_cdf_clusters_request,
    build_cdf_clusters_update_cdf_cluster_request,
    build_countries_list_countries_request,
    build_customers_add_customer_app_request,
    build_customers_create_customer_request,
    build_customers_create_tenant_request,
    build_customers_get_cdf_config_request,
    build_customers_get_customer_request,
    build_customers_list_customer_apps_request,
    build_customers_list_customer_tenants_request,
    build_customers_list_customers_request,
    build_customers_list_tenant_keys_request,
    build_customers_remove_customer_app_request,
    build_customers_update_cdf_config_request,
    build_customers_update_customer_request,
    build_customers_update_tenant_request,
    build_databases_update_databases_request,
    build_erp_sync_delete_erp_sync_error_request,
    build_erp_sync_get_stack_trace_request,
    build_erp_sync_list_erp_sync_errors_request,
    build_erp_sync_list_full_sync_instances_request,
    build_erp_sync_rewind_full_sync_instance_request,
    build_erp_sync_start_full_sync_request,
    build_erp_sync_sync_single_work_order_request,
    build_erp_sync_terminate_full_sync_instance_request,
    build_power_create_power_region_request,
    build_power_list_power_regions_by_country_request,
    build_presentation_delete_component_settings_request,
    build_presentation_save_component_settings_request,
    build_sustainability_setup_init_ferro_amp_request,
    build_sustainability_setup_map_factory_template_ferro_amp_request,
    build_sustainability_setup_map_factory_template_request,
    build_tenants_list_tenants_details_request,
    build_user_get_user_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AppsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`apps` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_apps(self, **kwargs: Any) -> List[_models.AppDto]:
        """Internal Ignos api for listing apps.

        Internal Ignos api for listing apps.

        :return: list of AppDto
        :rtype: list[~ignos.internal.api.client.models.AppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AppDto]] = kwargs.pop("cls", None)

        _request = build_apps_list_apps_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[AppDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_app(
        self, body: Optional[_models.CreateApp] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_app(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_app(self, body: Optional[Union[_models.CreateApp, IO]] = None, **kwargs: Any) -> _models.AppDto:
        """Internal Ignos api for creating a new app.

        Internal Ignos api for creating a new app.

        :param body: Is either a CreateApp type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateApp or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateApp")
            else:
                _json = None

        _request = build_apps_create_app_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("AppDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_app(
        self,
        id: str,
        body: Optional[_models.UpdateAppRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_app(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_app(
        self, id: str, body: Optional[Union[_models.UpdateAppRequest, IO]] = None, **kwargs: Any
    ) -> _models.AppDto:
        """Internal Ignos api for updating an app.

        Internal Ignos api for updating an app.

        :param id: Required.
        :type id: str
        :param body: Is either a UpdateAppRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateAppRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: AppDto
        :rtype: ~ignos.internal.api.client.models.AppDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AppDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateAppRequest")
            else:
                _json = None

        _request = build_apps_update_app_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("AppDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class AzureRegionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`azure_regions` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_azure_regions(self, **kwargs: Any) -> List[_models.AzureRegionDto]:
        """list_azure_regions.

        :return: list of AzureRegionDto
        :rtype: list[~ignos.internal.api.client.models.AzureRegionDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AzureRegionDto]] = kwargs.pop("cls", None)

        _request = build_azure_regions_list_azure_regions_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[AzureRegionDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class CdfClustersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`cdf_clusters` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_cdf_clusters(self, **kwargs: Any) -> List[_models.CdfClusterDto]:
        """list_cdf_clusters.

        :return: list of CdfClusterDto
        :rtype: list[~ignos.internal.api.client.models.CdfClusterDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CdfClusterDto]] = kwargs.pop("cls", None)

        _request = build_cdf_clusters_list_cdf_clusters_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[CdfClusterDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_cdf_cluster(
        self, body: Optional[_models.CreateCdfCluster] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CdfClusterDto:
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateCdfCluster
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_cdf_cluster(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CdfClusterDto:
        """create_cdf_cluster.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_cdf_cluster(
        self, body: Optional[Union[_models.CreateCdfCluster, IO]] = None, **kwargs: Any
    ) -> _models.CdfClusterDto:
        """create_cdf_cluster.

        :param body: Is either a CreateCdfCluster type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateCdfCluster or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CdfClusterDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateCdfCluster")
            else:
                _json = None

        _request = build_cdf_clusters_create_cdf_cluster_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfClusterDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_cdf_cluster(
        self,
        id: str,
        body: Optional[_models.UpdateCdfClusterRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfClusterDto:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCdfClusterRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_cdf_cluster(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CdfClusterDto:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_cdf_cluster(
        self, id: str, body: Optional[Union[_models.UpdateCdfClusterRequest, IO]] = None, **kwargs: Any
    ) -> _models.CdfClusterDto:
        """update_cdf_cluster.

        :param id: Required.
        :type id: str
        :param body: Is either a UpdateCdfClusterRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCdfClusterRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: CdfClusterDto
        :rtype: ~ignos.internal.api.client.models.CdfClusterDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CdfClusterDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateCdfClusterRequest")
            else:
                _json = None

        _request = build_cdf_clusters_update_cdf_cluster_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfClusterDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class CountriesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`countries` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_countries(self, **kwargs: Any) -> List[_models.CountryDto]:
        """list_countries.

        :return: list of CountryDto
        :rtype: list[~ignos.internal.api.client.models.CountryDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CountryDto]] = kwargs.pop("cls", None)

        _request = build_countries_list_countries_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[CountryDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class CustomersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`customers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_customers(
        self, *, page_size: int = 100, continuation_token_parameter: Optional[str] = None, **kwargs: Any
    ) -> List[_models.IgnosCustomerDto]:
        """Internal Ignos api for listing customers.

        Internal Ignos api for listing customers.

        :keyword page_size: Default value is 100.
        :paramtype page_size: int
        :keyword continuation_token_parameter: Default value is None.
        :paramtype continuation_token_parameter: str
        :return: list of IgnosCustomerDto
        :rtype: list[~ignos.internal.api.client.models.IgnosCustomerDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.IgnosCustomerDto]] = kwargs.pop("cls", None)

        _request = build_customers_list_customers_request(
            page_size=page_size,
            continuation_token_parameter=continuation_token_parameter,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[IgnosCustomerDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_customer(
        self,
        body: Optional[_models.CreateIgnosCustomer] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_customer(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_customer(
        self, body: Optional[Union[_models.CreateIgnosCustomer, IO]] = None, **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for creating a customer.

        Internal Ignos api for creating a customer.

        :param body: Is either a CreateIgnosCustomer type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateIgnosCustomer or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IgnosCustomerDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateIgnosCustomer")
            else:
                _json = None

        _request = build_customers_create_customer_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("IgnosCustomerDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_customer(self, id: str, **kwargs: Any) -> _models.IgnosCustomerDto:
        """Internal Ignos api for getting a customer.

        Internal Ignos api for getting a customer.

        :param id: Required.
        :type id: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.IgnosCustomerDto] = kwargs.pop("cls", None)

        _request = build_customers_get_customer_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("IgnosCustomerDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_customer(
        self,
        id: str,
        body: Optional[_models.UpdateCustomerRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_customer(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_customer(
        self, id: str, body: Optional[Union[_models.UpdateCustomerRequest, IO]] = None, **kwargs: Any
    ) -> _models.IgnosCustomerDto:
        """Internal Ignos api for updating a customer.

        Internal Ignos api for updating a customer.

        :param id: Required.
        :type id: str
        :param body: Is either a UpdateCustomerRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateCustomerRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: IgnosCustomerDto
        :rtype: ~ignos.internal.api.client.models.IgnosCustomerDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.IgnosCustomerDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateCustomerRequest")
            else:
                _json = None

        _request = build_customers_update_customer_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("IgnosCustomerDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_customer_tenants(self, id: str, **kwargs: Any) -> List[_models.TenantDto]:
        """Internal Ignos api for a customer's tenants.

        Internal Ignos api for a customer's tenants.

        :param id: Required.
        :type id: str
        :return: list of TenantDto
        :rtype: list[~ignos.internal.api.client.models.TenantDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TenantDto]] = kwargs.pop("cls", None)

        _request = build_customers_list_customer_tenants_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[TenantDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_tenant(
        self,
        id: str,
        body: Optional[_models.CreateTenantRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_tenant(
        self, id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_tenant(
        self, id: str, body: Optional[Union[_models.CreateTenantRequest, IO]] = None, **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for creating a customer tenant.

        Internal Ignos api for creating a customer tenant.

        :param id: Required.
        :type id: str
        :param body: Is either a CreateTenantRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TenantDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreateTenantRequest")
            else:
                _json = None

        _request = build_customers_create_tenant_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("TenantDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[_models.UpdateTenantRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_tenant(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_tenant(
        self, id: str, tenant_id: str, body: Optional[Union[_models.UpdateTenantRequest, IO]] = None, **kwargs: Any
    ) -> _models.TenantDto:
        """Internal Ignos api for updating a customer tenant.

        Internal Ignos api for updating a customer tenant.

        :param id: Required.
        :type id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a UpdateTenantRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: TenantDto
        :rtype: ~ignos.internal.api.client.models.TenantDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TenantDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateTenantRequest")
            else:
                _json = None

        _request = build_customers_update_tenant_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("TenantDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_cdf_config(self, id: str, tenant_id: str, **kwargs: Any) -> _models.CdfConfigDto:
        """Internal Ignos api for checking CDF config.

        Internal Ignos api for checking CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CdfConfigDto] = kwargs.pop("cls", None)

        _request = build_customers_get_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfConfigDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[_models.UpdateTenantCdfConfigRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_cdf_config(
        self,
        id: str,
        tenant_id: str,
        body: Optional[Union[_models.UpdateTenantCdfConfigRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.CdfConfigDto:
        """Internal Ignos api for updating CDF config.

        Internal Ignos api for updating CDF config.

        :param id: Customer id. Required.
        :type id: str
        :param tenant_id: Tenant id. Required.
        :type tenant_id: str
        :param body: Is either a UpdateTenantCdfConfigRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.UpdateTenantCdfConfigRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: CdfConfigDto
        :rtype: ~ignos.internal.api.client.models.CdfConfigDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CdfConfigDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "UpdateTenantCdfConfigRequest")
            else:
                _json = None

        _request = build_customers_update_cdf_config_request(
            id=id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CdfConfigDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_customer_apps(self, id: str, **kwargs: Any) -> List[_models.CustomerAppDto]:
        """Internal Ignos api for listing customer apps.

        Internal Ignos api for listing customer apps.

        :param id: Required.
        :type id: str
        :return: list of CustomerAppDto
        :rtype: list[~ignos.internal.api.client.models.CustomerAppDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.CustomerAppDto]] = kwargs.pop("cls", None)

        _request = build_customers_list_customer_apps_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[CustomerAppDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def add_customer_app(  # pylint: disable=inconsistent-return-statements
        self, id: str, app_id: str, **kwargs: Any
    ) -> None:
        """Internal Ignos api for adding an app to a customer.

        Internal Ignos api for adding an app to a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_customers_add_customer_app_request(
            id=id,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def remove_customer_app(  # pylint: disable=inconsistent-return-statements
        self, id: str, app_id: str, **kwargs: Any
    ) -> None:
        """Internal Ignos api for removing an app from a customer.

        Internal Ignos api for removing an app from a customer.

        :param id: Required.
        :type id: str
        :param app_id: Required.
        :type app_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_customers_remove_customer_app_request(
            id=id,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def list_tenant_keys(self, **kwargs: Any) -> List[_models.TenantKeyDto]:
        """list_tenant_keys.

        :return: list of TenantKeyDto
        :rtype: list[~ignos.internal.api.client.models.TenantKeyDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TenantKeyDto]] = kwargs.pop("cls", None)

        _request = build_customers_list_tenant_keys_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[TenantKeyDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class DatabasesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`databases` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def update_databases(self, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """update_databases.

        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_databases_update_databases_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class ErpSyncOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`erp_sync` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_erp_sync_errors(self, tenant_id: str, **kwargs: Any) -> List[_models.ErpSyncErrorDto]:
        """list_erp_sync_errors.

        :param tenant_id: Required.
        :type tenant_id: str
        :return: list of ErpSyncErrorDto
        :rtype: list[~ignos.internal.api.client.models.ErpSyncErrorDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.ErpSyncErrorDto]] = kwargs.pop("cls", None)

        _request = build_erp_sync_list_erp_sync_errors_request(
            tenant_id=tenant_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[ErpSyncErrorDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_stack_trace(self, tenant_id: str, row_key: str, **kwargs: Any) -> _models.ErpSyncErrorMessage:
        """get_stack_trace.

        :param tenant_id: Required.
        :type tenant_id: str
        :param row_key: Required.
        :type row_key: str
        :return: ErpSyncErrorMessage
        :rtype: ~ignos.internal.api.client.models.ErpSyncErrorMessage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ErpSyncErrorMessage] = kwargs.pop("cls", None)

        _request = build_erp_sync_get_stack_trace_request(
            tenant_id=tenant_id,
            row_key=row_key,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("ErpSyncErrorMessage", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_erp_sync_error(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, partition_key: str, row_key: str, **kwargs: Any
    ) -> None:
        """delete_erp_sync_error.

        :param tenant_id: Required.
        :type tenant_id: str
        :param partition_key: Required.
        :type partition_key: str
        :param row_key: Required.
        :type row_key: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_erp_sync_delete_erp_sync_error_request(
            tenant_id=tenant_id,
            partition_key=partition_key,
            row_key=row_key,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def start_full_sync(
        self,
        tenant_id: str,
        body: Optional[_models.StartFullSync] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DataSyncOrchestrationTriggerResponse:
        """start_full_sync.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.StartFullSync
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DataSyncOrchestrationTriggerResponse
        :rtype: ~ignos.internal.api.client.models.DataSyncOrchestrationTriggerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def start_full_sync(
        self, tenant_id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DataSyncOrchestrationTriggerResponse:
        """start_full_sync.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: DataSyncOrchestrationTriggerResponse
        :rtype: ~ignos.internal.api.client.models.DataSyncOrchestrationTriggerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def start_full_sync(
        self, tenant_id: str, body: Optional[Union[_models.StartFullSync, IO]] = None, **kwargs: Any
    ) -> _models.DataSyncOrchestrationTriggerResponse:
        """start_full_sync.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a StartFullSync type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.StartFullSync or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: DataSyncOrchestrationTriggerResponse
        :rtype: ~ignos.internal.api.client.models.DataSyncOrchestrationTriggerResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DataSyncOrchestrationTriggerResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "StartFullSync")
            else:
                _json = None

        _request = build_erp_sync_start_full_sync_request(
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("DataSyncOrchestrationTriggerResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def sync_single_work_order(  # pylint: disable=inconsistent-return-statements
        self,
        tenant_id: str,
        body: Optional[_models.SyncSingleWorkOrder] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """sync_single_work_order.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.SyncSingleWorkOrder
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def sync_single_work_order(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """sync_single_work_order.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def sync_single_work_order(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, body: Optional[Union[_models.SyncSingleWorkOrder, IO]] = None, **kwargs: Any
    ) -> None:
        """sync_single_work_order.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a SyncSingleWorkOrder type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.SyncSingleWorkOrder or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "SyncSingleWorkOrder")
            else:
                _json = None

        _request = build_erp_sync_sync_single_work_order_request(
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def list_full_sync_instances(
        self,
        tenant_id: str,
        *,
        created_from_time: Optional[datetime.datetime] = None,
        created_to_time: Optional[datetime.datetime] = None,
        runtime_status: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.DataSyncOrchestrationInstance]:
        """list_full_sync_instances.

        :param tenant_id: Required.
        :type tenant_id: str
        :keyword created_from_time: Default value is None.
        :paramtype created_from_time: ~datetime.datetime
        :keyword created_to_time: Default value is None.
        :paramtype created_to_time: ~datetime.datetime
        :keyword runtime_status: Default value is None.
        :paramtype runtime_status: str
        :return: list of DataSyncOrchestrationInstance
        :rtype: list[~ignos.internal.api.client.models.DataSyncOrchestrationInstance]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.DataSyncOrchestrationInstance]] = kwargs.pop("cls", None)

        _request = build_erp_sync_list_full_sync_instances_request(
            tenant_id=tenant_id,
            created_from_time=created_from_time,
            created_to_time=created_to_time,
            runtime_status=runtime_status,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[DataSyncOrchestrationInstance]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def terminate_full_sync_instance(  # pylint: disable=inconsistent-return-statements
        self,
        tenant_id: str,
        body: Optional[_models.TerminateInstance] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """terminate_full_sync_instance.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.TerminateInstance
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def terminate_full_sync_instance(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """terminate_full_sync_instance.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def terminate_full_sync_instance(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, body: Optional[Union[_models.TerminateInstance, IO]] = None, **kwargs: Any
    ) -> None:
        """terminate_full_sync_instance.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a TerminateInstance type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.TerminateInstance or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "TerminateInstance")
            else:
                _json = None

        _request = build_erp_sync_terminate_full_sync_instance_request(
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def rewind_full_sync_instance(  # pylint: disable=inconsistent-return-statements
        self,
        tenant_id: str,
        body: Optional[_models.RewindInstance] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """rewind_full_sync_instance.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.RewindInstance
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def rewind_full_sync_instance(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """rewind_full_sync_instance.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def rewind_full_sync_instance(  # pylint: disable=inconsistent-return-statements
        self, tenant_id: str, body: Optional[Union[_models.RewindInstance, IO]] = None, **kwargs: Any
    ) -> None:
        """rewind_full_sync_instance.

        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a RewindInstance type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.RewindInstance or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "RewindInstance")
            else:
                _json = None

        _request = build_erp_sync_rewind_full_sync_instance_request(
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class PowerOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`power` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_power_regions_by_country(
        self, *, country: Optional[str] = None, **kwargs: Any
    ) -> List[_models.PowerRegionDto]:
        """list_power_regions_by_country.

        :keyword country: Default value is None.
        :paramtype country: str
        :return: list of PowerRegionDto
        :rtype: list[~ignos.internal.api.client.models.PowerRegionDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.PowerRegionDto]] = kwargs.pop("cls", None)

        _request = build_power_list_power_regions_by_country_request(
            country=country,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[PowerRegionDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_power_region(
        self, body: Optional[_models.CreatePowerRegion] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PowerRegionDto:
        """create_power_region.

        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.CreatePowerRegion
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: PowerRegionDto
        :rtype: ~ignos.internal.api.client.models.PowerRegionDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_power_region(
        self, body: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PowerRegionDto:
        """create_power_region.

        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: PowerRegionDto
        :rtype: ~ignos.internal.api.client.models.PowerRegionDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_power_region(
        self, body: Optional[Union[_models.CreatePowerRegion, IO]] = None, **kwargs: Any
    ) -> _models.PowerRegionDto:
        """create_power_region.

        :param body: Is either a CreatePowerRegion type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.CreatePowerRegion or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: PowerRegionDto
        :rtype: ~ignos.internal.api.client.models.PowerRegionDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PowerRegionDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "CreatePowerRegion")
            else:
                _json = None

        _request = build_power_create_power_region_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("PowerRegionDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class PresentationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`presentation` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def delete_component_settings(  # pylint: disable=inconsistent-return-statements
        self, azure_ad_tenant_id: str, tenant_id: str, component_id: str, **kwargs: Any
    ) -> None:
        """delete_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_presentation_delete_component_settings_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            component_id=component_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def save_component_settings(
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        component_id: str,
        body: Optional[_models.SaveComponentSettingsRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ComponentSettingsDto:
        """save_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.SaveComponentSettingsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ComponentSettingsDto
        :rtype: ~ignos.internal.api.client.models.ComponentSettingsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def save_component_settings(
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        component_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ComponentSettingsDto:
        """save_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: ComponentSettingsDto
        :rtype: ~ignos.internal.api.client.models.ComponentSettingsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def save_component_settings(
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        component_id: str,
        body: Optional[Union[_models.SaveComponentSettingsRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.ComponentSettingsDto:
        """save_component_settings.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param component_id: Required.
        :type component_id: str
        :param body: Is either a SaveComponentSettingsRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.SaveComponentSettingsRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: ComponentSettingsDto
        :rtype: ~ignos.internal.api.client.models.ComponentSettingsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ComponentSettingsDto] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "SaveComponentSettingsRequest")
            else:
                _json = None

        _request = build_presentation_save_component_settings_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            component_id=component_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("ComponentSettingsDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class SustainabilitySetupOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`sustainability_setup` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def init_ferro_amp(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[_models.InitFerroAmpRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """init_ferro_amp.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.InitFerroAmpRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def init_ferro_amp(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """init_ferro_amp.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def init_ferro_amp(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[Union[_models.InitFerroAmpRequest, IO]] = None,
        **kwargs: Any
    ) -> None:
        """init_ferro_amp.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a InitFerroAmpRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.InitFerroAmpRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "InitFerroAmpRequest")
            else:
                _json = None

        _request = build_sustainability_setup_init_ferro_amp_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def map_factory_template(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[_models.InitFactoryTemplateRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """map_factory_template.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.InitFactoryTemplateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def map_factory_template(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """map_factory_template.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def map_factory_template(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[Union[_models.InitFactoryTemplateRequest, IO]] = None,
        **kwargs: Any
    ) -> None:
        """map_factory_template.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a InitFactoryTemplateRequest type or a IO type. Default value is None.
        :type body: ~ignos.internal.api.client.models.InitFactoryTemplateRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "InitFactoryTemplateRequest")
            else:
                _json = None

        _request = build_sustainability_setup_map_factory_template_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def map_factory_template_ferro_amp(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[_models.InitFactoryTemplateFerroAmpRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """map_factory_template_ferro_amp.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: ~ignos.internal.api.client.models.InitFactoryTemplateFerroAmpRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def map_factory_template_ferro_amp(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """map_factory_template_ferro_amp.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/*+json', 'application/json', 'text/json'. Default value is
         "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def map_factory_template_ferro_amp(  # pylint: disable=inconsistent-return-statements
        self,
        azure_ad_tenant_id: str,
        tenant_id: str,
        body: Optional[Union[_models.InitFactoryTemplateFerroAmpRequest, IO]] = None,
        **kwargs: Any
    ) -> None:
        """map_factory_template_ferro_amp.

        :param azure_ad_tenant_id: Required.
        :type azure_ad_tenant_id: str
        :param tenant_id: Required.
        :type tenant_id: str
        :param body: Is either a InitFactoryTemplateFerroAmpRequest type or a IO type. Default value is
         None.
        :type body: ~ignos.internal.api.client.models.InitFactoryTemplateFerroAmpRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/*+json',
         'application/json', 'text/json'. Default value is None.
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "InitFactoryTemplateFerroAmpRequest")
            else:
                _json = None

        _request = build_sustainability_setup_map_factory_template_ferro_amp_request(
            azure_ad_tenant_id=azure_ad_tenant_id,
            tenant_id=tenant_id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class TenantsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`tenants` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list_tenants_details(
        self, *, tenant_id_prefix: Optional[str] = None, app_id: Optional[str] = None, **kwargs: Any
    ) -> List[_models.TenantDetailDto]:
        """Internal Ignos api for listing tenants.

        Internal Ignos api for listing tenants.

        :keyword tenant_id_prefix: Default value is None.
        :paramtype tenant_id_prefix: str
        :keyword app_id: Default value is None.
        :paramtype app_id: str
        :return: list of TenantDetailDto
        :rtype: list[~ignos.internal.api.client.models.TenantDetailDto]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.TenantDetailDto]] = kwargs.pop("cls", None)

        _request = build_tenants_list_tenants_details_request(
            tenant_id_prefix=tenant_id_prefix,
            app_id=app_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[TenantDetailDto]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class UserOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~ignos.internal.api.client.aio.IgnosInternalApi`'s
        :attr:`user` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_user(self, **kwargs: Any) -> _models.UserDetailsDto:
        """get_user.

        :return: UserDetailsDto
        :rtype: ~ignos.internal.api.client.models.UserDetailsDto
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.UserDetailsDto] = kwargs.pop("cls", None)

        _request = build_user_get_user_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("UserDetailsDto", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
