# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core import AsyncPipelineClient
from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import IgnosInternalApiConfiguration
from .operations import (
    AppsOperations,
    AzureRegionsOperations,
    CdfClustersOperations,
    CountriesOperations,
    CustomersOperations,
    DatabasesOperations,
    ErpSyncOperations,
    PowerOperations,
    PresentationOperations,
    SustainabilitySetupOperations,
    TenantsOperations,
    UserOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class IgnosInternalApi:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """IgnosInternalApi.

    :ivar apps: AppsOperations operations
    :vartype apps: ignos.internal.api.client.aio.operations.AppsOperations
    :ivar azure_regions: AzureRegionsOperations operations
    :vartype azure_regions: ignos.internal.api.client.aio.operations.AzureRegionsOperations
    :ivar cdf_clusters: CdfClustersOperations operations
    :vartype cdf_clusters: ignos.internal.api.client.aio.operations.CdfClustersOperations
    :ivar countries: CountriesOperations operations
    :vartype countries: ignos.internal.api.client.aio.operations.CountriesOperations
    :ivar customers: CustomersOperations operations
    :vartype customers: ignos.internal.api.client.aio.operations.CustomersOperations
    :ivar databases: DatabasesOperations operations
    :vartype databases: ignos.internal.api.client.aio.operations.DatabasesOperations
    :ivar erp_sync: ErpSyncOperations operations
    :vartype erp_sync: ignos.internal.api.client.aio.operations.ErpSyncOperations
    :ivar power: PowerOperations operations
    :vartype power: ignos.internal.api.client.aio.operations.PowerOperations
    :ivar presentation: PresentationOperations operations
    :vartype presentation: ignos.internal.api.client.aio.operations.PresentationOperations
    :ivar sustainability_setup: SustainabilitySetupOperations operations
    :vartype sustainability_setup:
     ignos.internal.api.client.aio.operations.SustainabilitySetupOperations
    :ivar tenants: TenantsOperations operations
    :vartype tenants: ignos.internal.api.client.aio.operations.TenantsOperations
    :ivar user: UserOperations operations
    :vartype user: ignos.internal.api.client.aio.operations.UserOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :keyword endpoint: Service URL. Required. Default value is "".
    :paramtype endpoint: str
    """

    def __init__(self, credential: "AsyncTokenCredential", *, endpoint: str = "", **kwargs: Any) -> None:
        self._config = IgnosInternalApiConfiguration(credential=credential, **kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncPipelineClient = AsyncPipelineClient(base_url=endpoint, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.apps = AppsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.azure_regions = AzureRegionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cdf_clusters = CdfClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.countries = CountriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.customers = CustomersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.databases = DatabasesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.erp_sync = ErpSyncOperations(self._client, self._config, self._serialize, self._deserialize)
        self.power = PowerOperations(self._client, self._config, self._serialize, self._deserialize)
        self.presentation = PresentationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sustainability_setup = SustainabilitySetupOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.tenants = TenantsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.user = UserOperations(self._client, self._config, self._serialize, self._deserialize)

    def send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client.send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "IgnosInternalApi":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
