"use strict";
const assert_1 = require("@aws-cdk/assert");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
// tslint:disable-next-line:max-line-length
const lib_1 = require("../lib");
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
module.exports = {
    'test vpc endpoint service': {
        'create endpoint service with no principals'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            new lib_1.Vpc(stack, "MyVPC");
            // WHEN
            const lb = new DummyEndpointLoadBalacer("arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a");
            new lib_1.VpcEndpointService(stack, "EndpointService", {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal("arn:aws:iam::123456789012:root")]
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ["arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a"],
                AcceptanceRequired: false
            }));
            assert_1.expect(stack).notTo(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: "EndpointServiceED36BE1F"
                },
                AllowedPrincipals: []
            }));
            test.done();
        },
        'create endpoint service with a principal'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer("arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a");
            new lib_1.VpcEndpointService(stack, "EndpointService", {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal("arn:aws:iam::123456789012:root")]
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ["arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a"],
                AcceptanceRequired: false
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: "EndpointServiceED36BE1F"
                },
                AllowedPrincipals: ["arn:aws:iam::123456789012:root"]
            }));
            test.done();
        },
        'with acceptance requried'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer("arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a");
            new lib_1.VpcEndpointService(stack, "EndpointService", {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: true,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal("arn:aws:iam::123456789012:root")]
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ["arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a"],
                AcceptanceRequired: true
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: "EndpointServiceED36BE1F"
                },
                AllowedPrincipals: ["arn:aws:iam::123456789012:root"]
            }));
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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