"use strict";
const core_1 = require("@aws-cdk/core");
const ec2 = require("../lib");
module.exports = {
    'can make and use a Windows image'(test) {
        // GIVEN
        const stack = new core_1.Stack(undefined, undefined, {
            env: { region: 'testregion' }
        });
        // WHEN
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234'
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.imageId, 'ami-1234');
        test.equals(details.osType, ec2.OperatingSystemType.WINDOWS);
        test.done();
    },
    'WindowsImage retains userdata'(test) {
        // GIVEN
        const stack = new core_1.Stack(undefined, undefined, {
            env: { region: 'testregion' }
        });
        // WHEN
        const ud = ec2.UserData.forWindows();
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234',
        }, {
            userData: ud
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.userData, ud);
        test.done();
    },
    'LookupMachineImage default search'(test) {
        // GIVEN
        const app = new core_1.App();
        const stack = new core_1.Stack(app, 'Stack', {
            env: { account: '1234', region: 'testregion' }
        });
        // WHEN
        new ec2.LookupMachineImage({ name: 'bla*', owners: ['amazon'] }).getImage(stack);
        // THEN
        const missing = app.synth().manifest.missing || [];
        test.deepEqual(missing, [
            {
                key: 'ami:account=1234:filters.image-type.0=machine:filters.name.0=bla*:filters.state.0=available:owners.0=amazon:region=testregion',
                props: {
                    account: '1234',
                    region: 'testregion',
                    owners: ['amazon'],
                    filters: {
                        'name': ['bla*'],
                        'state': ['available'],
                        'image-type': ['machine']
                    }
                },
                provider: 'ami'
            }
        ]);
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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