"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const common_1 = require("../utils/common");
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.pbSubnets = [];
        this.pvSubnets = [];
        this.natSubnets = [];
        this.peeringConnectionIds = {};
        this.vpc = new aws_cdk_lib_1.aws_ec2.Vpc(this, 'VPC', props.vpc);
        if (props.peeringConfigs) {
            const convertPeeringConfig = common_1.ObjToStrMap(props.peeringConfigs);
            convertPeeringConfig.forEach((createVpcPeering, key) => {
                let peeringConnectionIdByKey = new aws_cdk_lib_1.aws_ec2.CfnVPCPeeringConnection(this, `PeerDestination-${key}`, {
                    vpcId: this.vpc.vpcId,
                    peerVpcId: createVpcPeering.peeringVpcId,
                    peerOwnerId: createVpcPeering.peerOwnerId,
                    peerRoleArn: createVpcPeering.peerAssumeRoleArn,
                    peerRegion: createVpcPeering.peerRegion,
                });
                const tags = common_1.ObjToStrMap(createVpcPeering.tags);
                tags.forEach((v, k) => {
                    aws_cdk_lib_1.Tags.of(peeringConnectionIdByKey).add(k, v);
                });
                console.log(`test value ${peeringConnectionIdByKey}`);
                this.peeringConnectionIds[key] = peeringConnectionIdByKey;
            });
        }
        props.subnets.forEach((subnetProps) => {
            let subnet = this.createSubnet(subnetProps, this.vpc, this.peeringConnectionIds);
            subnet.forEach((sb) => {
                if (sb instanceof aws_cdk_lib_1.aws_ec2.PublicSubnet) {
                    this.pbSubnets.push(sb);
                }
                else if (sb instanceof aws_cdk_lib_1.aws_ec2.PrivateSubnet) {
                    this.pvSubnets.push(sb);
                }
                if (subnetProps.subnetGroupName == 'NATGateway' &&
                    sb instanceof aws_cdk_lib_1.aws_ec2.PublicSubnet) {
                    this.natSubnets.push(sb);
                }
            });
        });
        const internetGateway = new aws_cdk_lib_1.aws_ec2.CfnInternetGateway(this, 'InternetGateway', {});
        const att = new aws_cdk_lib_1.aws_ec2.CfnVPCGatewayAttachment(this, 'VPCGatewayAttachement', {
            internetGatewayId: internetGateway.ref,
            vpcId: this.vpc.vpcId,
        });
        this.pbSubnets.forEach((pb) => {
            pb.addDefaultInternetRoute(internetGateway.ref, att);
        });
        if (this.natSubnets.length > 0) {
            if (props.natEipAllocationIds?.length != 0 && this.natSubnets.length != props.natEipAllocationIds?.length) {
                // eslint-disable-next-line max-len
                throw new Error('natEipAllocationIds and natSubnets length should be  equal');
            }
            if (props.natEipAllocationIds?.length == this.natSubnets?.length) {
                this.natProvider = aws_cdk_lib_1.aws_ec2.NatProvider.gateway({
                    eipAllocationIds: props.natEipAllocationIds,
                });
            }
            else {
                this.natProvider = aws_cdk_lib_1.aws_ec2.NatProvider.gateway();
            }
            this.natProvider.configureNat({
                vpc: this.vpc,
                natSubnets: this.natSubnets,
                privateSubnets: this.pvSubnets,
            });
        }
    }
    createSubnet(option, vpc, peeringConnectionId) {
        const subnets = [];
        const SUBNETTYPE_TAG = 'aws-cdk:subnet-type';
        const SUBNETNAME_TAG = 'aws-cdk:subnet-name';
        const NAME_TAG = 'Name';
        if (option.availabilityZones.length != option.cidrBlock.length) {
            // eslint-disable-next-line max-len
            throw new Error("You cannot reference a Subnet's availability zone if it was not supplied. Add the availabilityZone when importing using option.fromSubnetAttributes()");
        }
        option.availabilityZones.forEach((az, index) => {
            let subnet = option.subnetType === aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC
                ? new aws_cdk_lib_1.aws_ec2.PublicSubnet(this, `${option.subnetGroupName}Subnet${index}`, {
                    availabilityZone: az,
                    cidrBlock: option.cidrBlock[index],
                    vpcId: vpc.vpcId,
                    mapPublicIpOnLaunch: true,
                })
                : new aws_cdk_lib_1.aws_ec2.PrivateSubnet(this, `${option.subnetGroupName}Subnet${index}`, {
                    availabilityZone: az,
                    cidrBlock: option.cidrBlock[index],
                    vpcId: vpc.vpcId,
                    mapPublicIpOnLaunch: false,
                });
            option.routes?.forEach((route, routeIndex) => {
                if (peeringConnectionId != undefined && route.existingVpcPeeringRouteKey != undefined) {
                    console.log(`peeringConnectionid ${peeringConnectionId}`);
                    console.log(`existingVpcPeeringRouteKey ${route.existingVpcPeeringRouteKey}`);
                    console.log(`object ${Object.keys(peeringConnectionId)}`);
                    console.log(`object get value ${peeringConnectionId[route.existingVpcPeeringRouteKey]}`);
                    let routeId = peeringConnectionId[route.existingVpcPeeringRouteKey];
                    console.log(routeId);
                    if (routeId != undefined) {
                        subnet.addRoute(`${option.subnetGroupName}${routeIndex}RouteEntry`, {
                            routerId: routeId.ref,
                            routerType: route.routerType,
                            destinationCidrBlock: route.destinationCidrBlock,
                        });
                    }
                }
                else if (route.routerId != undefined) {
                    subnet.addRoute(`${option.subnetGroupName}${routeIndex}RouteEntry`, {
                        routerId: route.routerId ?? '',
                        routerType: route.routerType,
                        destinationCidrBlock: route.destinationCidrBlock,
                    });
                }
            });
            aws_cdk_lib_1.Tags.of(subnet).add(SUBNETNAME_TAG, option.subnetGroupName);
            aws_cdk_lib_1.Tags.of(subnet).add(SUBNETTYPE_TAG, option.subnetType);
            if (option.tags != undefined) {
                const tags = common_1.ObjToStrMap(option.tags);
                tags.forEach((v, k) => {
                    aws_cdk_lib_1.Tags.of(subnet).add(k, v);
                });
            }
            subnets.push(subnet);
        });
        const nacl = new aws_cdk_lib_1.aws_ec2.NetworkAcl(this, `${option.subnetGroupName}NACL`, {
            vpc: vpc,
            subnetSelection: {
                subnets: subnets,
            },
        });
        aws_cdk_lib_1.Tags.of(nacl).add(NAME_TAG, nacl.node.path);
        option.ingressNetworkACL?.forEach((ingressNACL, index) => {
            new aws_cdk_lib_1.aws_ec2.NetworkAclEntry(this, `${option.subnetGroupName}IngressNACL-${index}`, {
                ruleNumber: 100 + index,
                cidr: ingressNACL.cidr,
                networkAcl: nacl,
                traffic: ingressNACL.traffic,
                direction: aws_cdk_lib_1.aws_ec2.TrafficDirection.INGRESS,
            });
        });
        option.egressNetworkACL?.forEach((ingressNACL, index) => {
            new aws_cdk_lib_1.aws_ec2.NetworkAclEntry(this, `${option.subnetGroupName}EgressNACL-${index}`, {
                ruleNumber: 100 + index,
                cidr: ingressNACL.cidr,
                networkAcl: nacl,
                traffic: ingressNACL.traffic,
                direction: aws_cdk_lib_1.aws_ec2.TrafficDirection.EGRESS,
            });
        });
        new aws_cdk_lib_1.CfnOutput(this, `${option.subnetGroupName}OutPutSubnets`, {
            value: subnets
                .map((subnet) => {
                return subnet.subnetId;
            })
                .join(','),
            description: `${option.subnetGroupName} subnets cross`,
        });
        new aws_cdk_lib_1.CfnOutput(this, `${option.subnetGroupName}OutPutNACL`, {
            value: nacl.networkAclId,
            description: `${option.subnetGroupName} subnets associated this nacl`,
        });
        return subnets;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@smallcase/cdk-vpc-module.Network", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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