import { aws_ec2 as ec2 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface NetworkACL {
    readonly cidr: ec2.AclCidr;
    readonly traffic: ec2.AclTraffic;
}
export interface AddRouteOptions {
    readonly routerId?: string;
    readonly existingVpcPeeringRouteKey?: string;
    /**
       * IPv4 range this route applies to.
       *
       * @default '0.0.0.0/0'
       * @stability stable
       */
    readonly destinationCidrBlock?: string;
    /**
      * IPv6 range this route applies to.
      *
      * @default - Uses IPv6
      * @stability stable
      */
    readonly destinationIpv6CidrBlock?: string;
    /**
      * What type of router to route this traffic to.
      *
      * @stability stable
      */
    readonly routerType: ec2.RouterType;
    /**
      * The ID of the router.
      *
      * Can be an instance ID, gateway ID, etc, depending on the router type.
      *
      * @stability stable
      */
    /**
      * Whether this route will enable internet connectivity.
      *
      * If true, this route will be added before any AWS resources that depend
      * on internet connectivity in the VPC will be created.
      *
      * @default false
      * @stability stable
      */
    readonly enablesInternetConnectivity?: boolean;
}
export interface ISubnetsProps {
    readonly subnetGroupName: string;
    readonly subnetType: ec2.SubnetType;
    readonly cidrBlock: string[];
    readonly availabilityZones: string[];
    readonly ingressNetworkACL?: NetworkACL[];
    readonly egressNetworkACL?: NetworkACL[];
    readonly routes?: AddRouteOptions[];
    readonly tags?: Record<string, string>;
}
export interface VPCProps {
    readonly vpc: ec2.VpcProps;
    readonly peeringConfigs?: Record<string, PeeringConfig>;
    readonly natEipAllocationIds?: string[];
    readonly subnets: ISubnetsProps[];
}
export interface PeeringConfig {
    readonly peeringVpcId: string;
    readonly peerOwnerId?: string;
    readonly peerAssumeRoleArn?: string;
    readonly peerRegion?: string;
    readonly tags: Record<string, string>;
}
export interface PeeringConnectionInternalType {
    [name: string]: ec2.CfnVPCPeeringConnection;
}
export declare class Network extends Construct {
    pbSubnets: ec2.PublicSubnet[];
    pvSubnets: ec2.PrivateSubnet[];
    natSubnets: ec2.PublicSubnet[];
    private peeringConnectionIds;
    readonly vpc: ec2.Vpc;
    readonly natProvider: ec2.NatProvider;
    constructor(scope: Construct, id: string, props: VPCProps);
    createSubnet(option: ISubnetsProps, vpc: ec2.Vpc, peeringConnectionId?: PeeringConnectionInternalType): ec2.Subnet[];
}
