/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cdk from '@aws-cdk/core';
import * as cloud9 from '@aws-cdk/aws-cloud9';
import * as ssm from '@aws-cdk/aws-ssm';
import * as iam from '@aws-cdk/aws-iam';
/**
 * @experimental
 */
export interface CustomCloud9SsmProps {
    /**
     * (experimental) Optional configuration for the SSM Document.
     *
     * @default : none
     * @experimental
     */
    readonly ssmDocumentProps?: ssm.CfnDocumentProps;
    /**
     * (experimental) Optional configuration for the Cloud9 EC2 environment.
     *
     * @default : none
     * @experimental
     */
    readonly cloud9Ec2Props?: cloud9.Ec2EnvironmentProps;
}
/**
 * @experimental
 */
export declare class CustomCloud9Ssm extends cdk.Construct {
    private static readonly DEFAULT_EBS_SIZE;
    private static readonly DEFAULT_DOCUMENT_FILE_NAME;
    private static readonly RESIZE_STEP_FILE_NAME;
    private static readonly ATTACH_PROFILE_FILE_NAME;
    private static readonly DEFAULT_DOCUMENT_NAME;
    private document;
    /**
     * (experimental) The IAM Role that is attached to the EC2 instance launched with the Cloud9 environment to grant it permissions to execute the statements in the SSM Document.
     *
     * @experimental
     */
    readonly ec2Role: iam.Role;
    /**
     * (experimental) Adds one or more steps to the content of the SSM Document.
     *
     * @param steps : YAML formatted string containing one or more steps to be added to the mainSteps section of the SSM Document.
     * @experimental
     */
    addDocumentSteps(steps: string): void;
    /**
     * (experimental) Adds one or more parameters to the content of the SSM Document.
     *
     * @param parameters : YAML formatted string containing one or more parameters to be added to the parameters section of the SSM Document.
     * @experimental
     */
    addDocumentParameters(parameters: string): void;
    /**
     * (experimental) Adds a step to the SSM Document content that resizes the EBS volume of the EC2 instance.
     *
     * Attaches the required policies to ec2Role.
     *
     * @param size : size in GiB to resize the EBS volume to.
     * @experimental
     */
    resizeEBSTo(size: number): void;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: CustomCloud9SsmProps);
}
