import { ResolvedApplicationProps } from '../applicationProps';
import { Repository } from 'aws-cdk-lib/aws-codecommit';
import { Construct } from 'constructs';
import { IStringParameter } from 'aws-cdk-lib/aws-ssm';
export interface MirrorRepositoryProps extends Pick<ResolvedApplicationProps, 'repository'> {
    repoTokenParam: IStringParameter;
}
export declare class MirrorRepository extends Construct {
    readonly codeCommitRepository: Repository;
    constructor(scope: Construct, id: string, props: MirrorRepositoryProps);
    private createCodeCommitRepository;
    private createRepositoryMirroring;
    private createWebhook;
    private triggerInitialMirror;
}
