"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppStage = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const context_1 = require("../util/context");
class AppStage extends aws_cdk_lib_1.Stage {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.node.setContext('env', props.envName);
        props.stacks.create(this, context_1.getProjectName(this), props.envName);
    }
}
exports.AppStage = AppStage;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwU3RhZ2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY29uc3RydWN0cy9hcHBTdGFnZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2Q0FBOEM7QUFHOUMsNkNBQStDO0FBTy9DLE1BQWEsUUFBUyxTQUFRLG1CQUFLO0lBQy9CLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBb0I7UUFDMUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFeEIsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUUzQyxLQUFLLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsd0JBQWMsQ0FBQyxJQUFJLENBQUMsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDbkUsQ0FBQztDQUNKO0FBUkQsNEJBUUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1N0YWdlLCBTdGFnZVByb3BzfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQge0NvbnN0cnVjdH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQge0lTdGFja3NDcmVhdGlvbn0gZnJvbSAnLi4vYXBwbGljYXRpb25Qcm9wcyc7XG5pbXBvcnQge2dldFByb2plY3ROYW1lfSBmcm9tICcuLi91dGlsL2NvbnRleHQnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEFwcFN0YWdlUHJvcHMgZXh0ZW5kcyBTdGFnZVByb3BzIHtcbiAgICBlbnZOYW1lOiBzdHJpbmc7XG4gICAgc3RhY2tzOiBJU3RhY2tzQ3JlYXRpb247XG59XG5cbmV4cG9ydCBjbGFzcyBBcHBTdGFnZSBleHRlbmRzIFN0YWdlIHtcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXBwU3RhZ2VQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgICAgICB0aGlzLm5vZGUuc2V0Q29udGV4dCgnZW52JywgcHJvcHMuZW52TmFtZSk7XG5cbiAgICAgICAgcHJvcHMuc3RhY2tzLmNyZWF0ZSh0aGlzLCBnZXRQcm9qZWN0TmFtZSh0aGlzKSwgcHJvcHMuZW52TmFtZSk7XG4gICAgfVxufVxuIl19