---
id: RCA-001
revision: 1
title: Regulatory Change Assessment
---

This document should be used when evaluating whether device changes requires a new 510(k) submission. See

- [_Deciding When to Submit a 510(k) for a Change to an Existing Device_](https://www.fda.gov/media/99812/download)
- [_Deciding When to Submit a 510(k) for a Software Change to an Existing Device_](https://www.fda.gov/media/99785/download)

for additional details.

# Summary

**Product Name:** {{ device.name }}

**Date of Assessment:** TODO: Fill in date here

**Device Description:** TODO: Fill in short device description and link to relevant design specifications for more details.

**Description of Change(s):** See the sections below.

**Reason for Change(s):** TODO: Fill in reason for change.

**Applicable Regulatory History (including 510(k) #s and comparison of modified device to most recently cleared version):**  
{{ device.name }} was originally cleared in KYYxxxx. All changes made between the KYYxxxx and modified device are described in this document. TODO: Fill in the full 510(k) history for the device.

**Completed Checklist Attached:**

- [ ] Yes -> Complete main flowchart questions
- [ ] No -> Provide rationale

**Recommended Regulatory Action:**

- [ ] Submit 510(k)
- [ ] Letter to file

**Supporting Documents:**

TODO: list supporting documents here

# Device Change I

TODO: Copy this entire section for each change that you're evaluating. You need to complete the flow chart for each change. In addition to checking the appropriate boxes, justify your choices below each question as appropriate. See the guidance documents for examples.

TODO: Update the section title to describe the change. Also write additional details about the change here.

## Main Flowchart Questions

**A. Change made with intent to significantly improve the safety or effectiveness of the device?**

- [ ] Yes -> Complete A1 after finishing the main flowchart
- [ ] No -> Provide rationale

**B. Labeling change?**

- [ ] Yes -> Complete B1 after finishing the main flowchart
- [ ] No -> Provide rationale

**C. Technology, engineering, or performance change?**

- [ ] Yes -> Complete C1 after finishing the main flowchart
- [ ] No -> Provide rationale

**D. Materials change?**

- [ ] Yes -> Complete D1 after finishing the main flowchart
- [ ] No -> Provide rationale

**S. Software change?**

- [ ] Yes -> Complete S1 after finishing the main flowchart
- [ ] No -> Provide rationale

## Labeling Flowchart Questions

**A1. Is it a change in the indications for use statement?**

- [ ] Yes -> Go to A1.1
- [ ] No -> Go to A2

**A1.1. Is it a change from a device labeled for single use only to a device labeled as reusable?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to A1.2

**A1.2. Is it a change from prescription (Rx) to over the counter (OTC) use?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to A1.3

**A1.3. Is it a change to the device name or a change solely to improve readability or clarity?**

- [ ] Yes -> Document to file
- [ ] No -> Go to A1.4

**A1.4. Does the change describe a new disease, condition, or patient population that the device is intended for use in diagnosing, treating, preventing, curing or mitigating?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to A1.5

**A1.5. Does a risk-based assessment of the changed device identify any new risks or significantly modified existing risks?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Document to file

**A2. Does the change add or delete a contraindication?**

- [ ] Yes -> Submit 510(k) (If adding a contraindication, submit CBE 510(k))
- [ ] No -> Go to A3

**A3. Is it a change in warnings or precautions?**

- [ ] Yes -> Go to A1.1
- [ ] No -> Go to A4

**A4. Could the change affect the directions for use of the device?**

- [ ] Yes -> Go to A1.1
- [ ] No -> Document to file

## Technology, Engineering, and Performance Changes

**B1. Is the device an in vitro diagnostic device?**

- [ ] Yes -> Go to D1
- [ ] No -> Go to B2

**B2. Is it a control mechanism, operating principle, or energy type change?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to B3

**B3. Is it a change in sterilization, cleaning, or disinfection?**

- [ ] Yes -> Go to B3.1
- [ ] No -> Go to B4

**B3.1. Is it a change to an “established category B” or “novel” sterilization method, does the change lower the sterility assurance level, or is it a change to how the device is provided?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to B3.2

**B3.2. Could the change significantly affect the performance or biocompatibility of the device?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Document to file

**B4. Is there a change in packaging or expiration dating?**

- [ ] Yes -> Go to B4.1
- [ ] No -> Go to B5

**B4.1. Is the same method or protocol, as described in a previously cleared 510(k), used to support the change?**

- [ ] Yes -> Document to file
- [ ] No -> Submit 510(k)

**B5. Is it any other change in design (e.g., dimensions, performance specifications, wireless communication, components or accessories, or the patient/user interface)?**

- [ ] Yes -> Go to B5.1
- [ ] No -> Document to file

**B5.1. Does the change significantly affect the use of the device?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to B5.2

**B5.2. Does a risk-based assessment of the changed device identify any new risks or significantly modified existing risks?**

- [ ] Yes -> Submit 510(k
- [ ] No -> Go to B5.3

**B5.3. Are clinical data necessary to evaluate safety or effectiveness for purposes of design validation?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to B5.4

**B5.4. Do design verification and/or validation activities produce any unexpected issues of safety or effectiveness?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Document to file

## Materials Changes

**C1. Is the device an in vitro diagnostic product (IVD)?**

- [ ] Yes -> Go to D1
- [ ] No -> Go to C2

**C2. Is this a change in material type, material formulation, chemical composition, or the material’s processing?**

- [ ] Yes -> Go to C3
- [ ] No -> Document to file

**C3. Will the changed material directly or indirectly contact body tissues or fluids?**

- [ ] Yes -> Go to C4
- [ ] No -> Go to C5

**C4. Does a risk assessment identify any new or increased biocompatibility concerns?**

- [ ] Yes -> Go to C4.1
- [ ] No -> Go to C5

**C4.1. Has the manufacturer used the same material in a similar legally marketed device?**

- [ ] Yes -> Go to C5
- [ ] No -> Submit 510(k)

**C5. Could the change affect the device’s performance specifications?**

- [ ] Yes -> Go to B5
- [ ] No -> Document to file

## Technology, Engineering, Performance, and Materials Changes for In Vitro Diagnostic Devices

**D1. Does the change alter the operating principle of the IVD?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to D2

**D2. Is the change identified in a device-specific final guidance or classification regulation?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to D3

**D3. Does a risk-based assessment of the changed device identify any new risks or significantly modified existing risks?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to D4

**D4. Do design verification and/or validation activities produce any unexpected issues of safety or effectiveness?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Document to file

## Software Flowchart Questions

**S1. Is the change made solely to strengthen cybersecurity and does not have any other impact on the software or device?**

- [ ] Yes -> Document to file
- [ ] No -> Go to S2

**S2. Is the change made solely to return the system into specification of the most recently cleared device?**

- [ ] Yes -> Document to file
- [ ] No -> Go to S3a

**S3a. Does the change introduce a new risk or modify an existing risk that could result in significant harm and that is not effectively mitigated in the most recently cleared device?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to S3b

**S3b. Does the change create or necessitate a new risk control measure or a modification of an existing risk control measure for a hazardous situation that could result in significant harm?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to S4

**S4. Could the change significantly affect clinical functionality or performance specifications that are directly associated with the intended use of the device?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Go to S5

**S5. Do any of the additional factors in section VI of _Deciding When to Submit a 510(k) for a Software Change to an Existing Device_ apply to this change?**

- [ ] Yes -> Submit 510(k)
- [ ] No -> Document to file
