<p align="center">
	<img src="https://raw.githubusercontent.com/DeepRegNet/DeepReg/main/docs/asset/deepreg_logo_purple_beta.svg" alt="deepreg_logo" title="DeepReg" width="200" />
</p>

# DeepReg

[![Build Status](https://travis-ci.com/DeepRegNet/DeepReg.svg?branch=main)](https://travis-ci.com/DeepRegNet/DeepReg)
[![Documentation Status](https://readthedocs.org/projects/deepreg/badge/?version=latest)](https://deepreg.readthedocs.io/en/latest/?badge=latest)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![codecov](https://codecov.io/gh/DeepRegNet/DeepReg/branch/main/graph/badge.svg)](https://codecov.io/gh/DeepRegNet/DeepReg)
[![status](https://joss.theoj.org/papers/7e6de472bc82a70d7618e23f618960b3/status.svg)](https://joss.theoj.org/papers/7e6de472bc82a70d7618e23f618960b3)

**DeepReg is a freely available, community-supported open-source toolkit for research
and education in medical image registration using deep learning.**

- TensorFlow2-based for efficient training and rapid deployment;
- Implementing major unsupervised and weakly-supervised algorithms, with their
  combinations and variants;
- Focusing on growing and diverse clinical applications, with all DeepReg Demos using
  open-accessible data;
- Simple built-in command line tools requiring minimal programming and scripting;
- Open, permissible and research-and-education-driven, under the Apache 2.0 license.

---

## Getting Started

- [Documentation, Tutorials and a Quick Start](https://deepreg.readthedocs.io/)
- [DeepReg Demos](https://deepreg.readthedocs.io/en/latest/demo/introduction.html)
- [Issue Tracker](https://github.com/DeepRegNet/DeepReg/issues/new/choose)
- [deepreg.net](http://deepreg.net/)

## Contributing

Get involved, and help make DeepReg better!

For guidance on making a contribution to DeepReg, see our
[contribution guidelines](https://deepreg.readthedocs.io/en/latest/contributing/code.html).

Have a registration application with openly accessible data? Consider
[contributing a DeepReg Demo](https://deepreg.readthedocs.io/en/latest/contributing/demo.html).

## MICCAI 2020 Educational Challenge

Our [MICCAI Educational Challenge](https://miccai-sb.github.io/materials.html)
submission on DeepReg is an Award Winner!

Check it out
[here](https://github.com/DeepRegNet/DeepReg/blob/main/docs/Intro_to_Medical_Image_Registration.ipynb) -
you can also
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/DeepRegNet/DeepReg/blob/main/docs/Intro_to_Medical_Image_Registration.ipynb)
