# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_fixture import FixtureProgressionsModelFixture
from atriumsports.datacore.openapi.models.fixtures_model_venue import FixturesModelVenue
from atriumsports.datacore.openapi.models.seasons_model_competition import SeasonsModelCompetition
from atriumsports.datacore.openapi.models.video_stream_outputs_model_organization import (
    VideoStreamOutputsModelOrganization,
)


class VideoStreamOutputsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    video_input_id: Optional[StrictStr] = Field(
        None, alias="videoInputId", description="The unique identifier of the video input"
    )
    master_venue_id: Optional[StrictStr] = Field(
        None, alias="masterVenueId", description="The unique identifier of the master venue"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[VideoStreamOutputsModelOrganization] = None
    venue_id: Optional[StrictStr] = Field(None, alias="venueId", description="The unique identifier of the venue")
    venue: Optional[FixturesModelVenue] = None
    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    competition: Optional[SeasonsModelCompetition] = None
    fixture_id: Optional[StrictStr] = Field(None, alias="fixtureId", description="The unique identifier of the fixture")
    fixture: Optional[FixtureProgressionsModelFixture] = None
    provider: Optional[constr(strict=True, max_length=100)] = Field(
        None, description="The code for the provider of the file"
    )
    locale: Optional[constr(strict=True, max_length=5, min_length=5)] = Field(
        None, description="The locale of the video"
    )
    source_number: Optional[StrictInt] = Field(
        1,
        alias="sourceNumber",
        description="Unique identifier for the video source. This is unique for the provider/fixtureId/locale combination.  Unless the provider is supplying multiple sources per fixture/locale then this is normally 1.",
    )
    feed_type: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="feedType",
        description="Type of video input >- `ADDITIONAL_ANGLE` Additional angle >- `LOW_LATENCY` Low Latency >- `PRIMARY` Primary ",
    )
    input_resolution: Optional[constr(strict=True, max_length=30)] = Field(
        None,
        alias="inputResolution",
        description="The resolution of the video input >- `1080` 1920 x 1080 >- `288` 512 x 288 >- `720` 1280 x 720 ",
    )
    name: Optional[constr(strict=True, max_length=200)] = Field(None, description="The name of the video source")
    content: Optional[constr(strict=True, max_length=30)] = Field(
        "CLEAN",
        description="Content of the stream >- `CLEAN` Output signal is the same as the input signal >- `PROGRAM` Score overlays and other enhancements have been added to the stream ",
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    audio_ambience: Optional[StrictBool] = Field(None, alias="audioAmbience", description="Audio Ambience")
    audio_commentary: Optional[StrictBool] = Field(None, alias="audioCommentary", description="Audio Commentary")
    __properties = [
        "videoInputId",
        "masterVenueId",
        "organizationId",
        "organization",
        "venueId",
        "venue",
        "competitionId",
        "competition",
        "fixtureId",
        "fixture",
        "provider",
        "locale",
        "sourceNumber",
        "feedType",
        "inputResolution",
        "name",
        "content",
        "updated",
        "added",
        "audioAmbience",
        "audioCommentary",
    ]

    @validator("locale")
    def locale_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[a-z]{2,2}-[A-Z]{2,2}$", v):
            raise ValueError(r"must validate the regular expression /^[a-z]{2,2}-[A-Z]{2,2}$/")
        return v

    @validator("feed_type")
    def feed_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("PRIMARY", "ADDITIONAL_ANGLE", "LOW_LATENCY"):
            raise ValueError("must validate the enum values ('PRIMARY', 'ADDITIONAL_ANGLE', 'LOW_LATENCY')")
        return v

    @validator("input_resolution")
    def input_resolution_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("288", "720", "1080"):
            raise ValueError("must validate the enum values ('288', '720', '1080')")
        return v

    @validator("content")
    def content_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("CLEAN", "PROGRAM"):
            raise ValueError("must validate the enum values ('CLEAN', 'PROGRAM')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoStreamOutputsModel:
        """Create an instance of VideoStreamOutputsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of venue
        if self.venue:
            _dict["venue"] = self.venue.to_dict()
        # override the default output from pydantic by calling `to_dict()` of competition
        if self.competition:
            _dict["competition"] = self.competition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fixture
        if self.fixture:
            _dict["fixture"] = self.fixture.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoStreamOutputsModel:
        """Create an instance of VideoStreamOutputsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VideoStreamOutputsModel.parse_obj(obj)

        _obj = VideoStreamOutputsModel.parse_obj(
            {
                "video_input_id": obj.get("videoInputId"),
                "master_venue_id": obj.get("masterVenueId"),
                "organization_id": obj.get("organizationId"),
                "organization": VideoStreamOutputsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "venue_id": obj.get("venueId"),
                "venue": FixturesModelVenue.from_dict(obj.get("venue")) if obj.get("venue") is not None else None,
                "competition_id": obj.get("competitionId"),
                "competition": SeasonsModelCompetition.from_dict(obj.get("competition"))
                if obj.get("competition") is not None
                else None,
                "fixture_id": obj.get("fixtureId"),
                "fixture": FixtureProgressionsModelFixture.from_dict(obj.get("fixture"))
                if obj.get("fixture") is not None
                else None,
                "provider": obj.get("provider"),
                "locale": obj.get("locale"),
                "source_number": obj.get("sourceNumber") if obj.get("sourceNumber") is not None else 1,
                "feed_type": obj.get("feedType"),
                "input_resolution": obj.get("inputResolution"),
                "name": obj.get("name"),
                "content": obj.get("content") if obj.get("content") is not None else "CLEAN",
                "updated": obj.get("updated"),
                "added": obj.get("added"),
                "audio_ambience": obj.get("audioAmbience"),
                "audio_commentary": obj.get("audioCommentary"),
            }
        )
        return _obj
