# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import date
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.transfer_component import TransferComponent


class TransferPutBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    competition_id: Optional[StrictStr] = Field(
        None, alias="competitionId", description="The unique identifier of the competition"
    )
    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    components: Optional[List[TransferComponent]] = Field(None, description="List of transfer components")
    status: Optional[constr(strict=True, max_length=30)] = Field(
        None, description="Transfer Status >- `APPROVED` Approved >- `DECLINED` Decline >- `PENDING` Pending "
    )
    reference: Optional[constr(strict=True, max_length=100)] = Field(None, description="Transfer reference number")
    transfer_type: Optional[constr(strict=True, max_length=100)] = Field(
        None,
        alias="transferType",
        description="Type of transfer >- `DROPPED` Dropped >- `OTHER` Other >- `PERMIT` Permit >- `TRADE` Trade >- `TRANSFER` Transfer ",
    )
    date_transfer: Optional[date] = Field(None, alias="dateTransfer", description="Date of transfer")
    date_permit_from: Optional[date] = Field(None, alias="datePermitFrom", description="Date the permit started")
    date_permit_to: Optional[date] = Field(None, alias="datePermitTo", description="Date the permit ended")
    notes: Optional[constr(strict=True, max_length=1000)] = Field(None, description="Notes")
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "competitionId",
        "seasonId",
        "components",
        "status",
        "reference",
        "transferType",
        "dateTransfer",
        "datePermitFrom",
        "datePermitTo",
        "notes",
        "externalId",
    ]

    @validator("status")
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("APPROVED", "PENDING", "DECLINED"):
            raise ValueError("must validate the enum values ('APPROVED', 'PENDING', 'DECLINED')")
        return v

    @validator("transfer_type")
    def transfer_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("TRADE", "TRANSFER", "DROPPED", "PERMIT", "OTHER"):
            raise ValueError("must validate the enum values ('TRADE', 'TRANSFER', 'DROPPED', 'PERMIT', 'OTHER')")
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransferPutBody:
        """Create an instance of TransferPutBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in components (list)
        _items = []
        if self.components:
            for _item in self.components:
                if _item:
                    _items.append(_item.to_dict())
            _dict["components"] = _items
        # set to None if components (nullable) is None
        if self.components is None:
            _dict["components"] = None

        # set to None if date_transfer (nullable) is None
        if self.date_transfer is None:
            _dict["dateTransfer"] = None

        # set to None if date_permit_from (nullable) is None
        if self.date_permit_from is None:
            _dict["datePermitFrom"] = None

        # set to None if date_permit_to (nullable) is None
        if self.date_permit_to is None:
            _dict["datePermitTo"] = None

        # set to None if notes (nullable) is None
        if self.notes is None:
            _dict["notes"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferPutBody:
        """Create an instance of TransferPutBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransferPutBody.parse_obj(obj)

        _obj = TransferPutBody.parse_obj(
            {
                "competition_id": obj.get("competitionId"),
                "season_id": obj.get("seasonId"),
                "components": [TransferComponent.from_dict(_item) for _item in obj.get("components")]
                if obj.get("components") is not None
                else None,
                "status": obj.get("status"),
                "reference": obj.get("reference"),
                "transfer_type": obj.get("transferType"),
                "date_transfer": obj.get("dateTransfer"),
                "date_permit_from": obj.get("datePermitFrom"),
                "date_permit_to": obj.get("datePermitTo"),
                "notes": obj.get("notes"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
