# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictFloat


class StandingPostBodyPointsValue(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    bonus_standing_points: Optional[StrictFloat] = Field(
        None, alias="bonusStandingPoints", description="Bonus Standing points"
    )
    penalty_standing_points: Optional[StrictFloat] = Field(
        None, alias="penaltyStandingPoints", description="Penalty Standing points"
    )
    bye_standing_points: Optional[StrictFloat] = Field(
        None, alias="byeStandingPoints", description="Bye Standing points"
    )
    team_differential: Optional[StrictFloat] = Field(
        None, alias="teamDifferential", description="Differential of Won-Lost"
    )
    team_differential_home: Optional[StrictFloat] = Field(
        None, alias="teamDifferentialHome", description="Differential of Won-Lost"
    )
    team_differential_away: Optional[StrictFloat] = Field(
        None, alias="teamDifferentialAway", description="Differential of Won-Lost"
    )
    games_behind: Optional[StrictFloat] = Field(
        None, alias="gamesBehind", description="Games behind leading competitor"
    )
    standing_points: Optional[StrictFloat] = Field(
        None, alias="standingPoints", description="Standing Points for competitor"
    )
    standing_points_home: Optional[StrictFloat] = Field(
        None, alias="standingPointsHome", description="Standing Points for competitor at Home"
    )
    standing_points_away: Optional[StrictFloat] = Field(
        None, alias="standingPointsAway", description="Standing Points for competitor away"
    )
    __properties = [
        "bonusStandingPoints",
        "penaltyStandingPoints",
        "byeStandingPoints",
        "teamDifferential",
        "teamDifferentialHome",
        "teamDifferentialAway",
        "gamesBehind",
        "standingPoints",
        "standingPointsHome",
        "standingPointsAway",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingPostBodyPointsValue:
        """Create an instance of StandingPostBodyPointsValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingPostBodyPointsValue:
        """Create an instance of StandingPostBodyPointsValue from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StandingPostBodyPointsValue.parse_obj(obj)

        _obj = StandingPostBodyPointsValue.parse_obj(
            {
                "bonus_standing_points": obj.get("bonusStandingPoints"),
                "penalty_standing_points": obj.get("penaltyStandingPoints"),
                "bye_standing_points": obj.get("byeStandingPoints"),
                "team_differential": obj.get("teamDifferential"),
                "team_differential_home": obj.get("teamDifferentialHome"),
                "team_differential_away": obj.get("teamDifferentialAway"),
                "games_behind": obj.get("gamesBehind"),
                "standing_points": obj.get("standingPoints"),
                "standing_points_home": obj.get("standingPointsHome"),
                "standing_points_away": obj.get("standingPointsAway"),
            }
        )
        return _obj
