# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.standing_building import StandingBuilding
from atriumsports.datacore.openapi.models.standing_configuration import StandingConfiguration
from atriumsports.datacore.openapi.models.standing_configurations_model_organization import (
    StandingConfigurationsModelOrganization,
)


class StandingConfigurationsModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    standing_configuration_id: Optional[StrictStr] = Field(
        None, alias="standingConfigurationId", description="The unique identifier of the configuration"
    )
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[StandingConfigurationsModelOrganization] = None
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the ~standing_configurations~ in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the ~standing_configurations~ in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    build_rules: Optional[StandingBuilding] = Field(None, alias="buildRules")
    configuration: Optional[StandingConfiguration] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "standingConfigurationId",
        "organizationId",
        "organization",
        "nameLocal",
        "nameLatin",
        "buildRules",
        "configuration",
        "externalId",
        "updated",
        "added",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StandingConfigurationsModel:
        """Create an instance of StandingConfigurationsModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of build_rules
        if self.build_rules:
            _dict["buildRules"] = self.build_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of configuration
        if self.configuration:
            _dict["configuration"] = self.configuration.to_dict()
        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StandingConfigurationsModel:
        """Create an instance of StandingConfigurationsModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StandingConfigurationsModel.parse_obj(obj)

        _obj = StandingConfigurationsModel.parse_obj(
            {
                "standing_configuration_id": obj.get("standingConfigurationId"),
                "organization_id": obj.get("organizationId"),
                "organization": StandingConfigurationsModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "name_local": obj.get("nameLocal"),
                "name_latin": obj.get("nameLatin"),
                "build_rules": StandingBuilding.from_dict(obj.get("buildRules"))
                if obj.get("buildRules") is not None
                else None,
                "configuration": StandingConfiguration.from_dict(obj.get("configuration"))
                if obj.get("configuration") is not None
                else None,
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
