# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator

from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_venues_address import SeasonVenuesAddress
from atriumsports.datacore.openapi.models.season_venues_list_model_organization import SeasonVenuesListModelOrganization
from atriumsports.datacore.openapi.models.season_venues_list_model_site import SeasonVenuesListModelSite
from atriumsports.datacore.openapi.models.social_media import SocialMedia


class SeasonVenuesListModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonVenuesListModelOrganization] = None
    venue_id: Optional[StrictStr] = Field(None, alias="venueId", description="The unique identifier of the venue")
    site_id: Optional[StrictStr] = Field(
        None, alias="siteId", description="The site that this season venues belongs to"
    )
    site: Optional[SeasonVenuesListModelSite] = None
    abbreviation_local: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLocal",
        description="An abbreviation/short name in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLocal",
        description="The name of the season venues in the [local](#section/Introduction/Character-Sets-and-Names) language",
    )
    alternate_name_local: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="alternateNameLocal", description="The alternate name of the venue, in Local Language"
    )
    abbreviation_latin: Optional[constr(strict=True, max_length=50)] = Field(
        None,
        alias="abbreviationLatin",
        description="An abbreviation/short name in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        alias="nameLatin",
        description="The name of the season venues in [latin](#section/Introduction/Character-Sets-and-Names) characters",
    )
    alternate_name_latin: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="alternateNameLatin", description="The alternate name of the venue, in Latin characters"
    )
    country_code: Optional[constr(strict=True, max_length=3, min_length=3)] = Field(
        None,
        alias="countryCode",
        description="Country code of the season venues. We recommend you use ISO-3166-1:alpha3 (upper case) values where available.",
    )
    timezone: Optional[constr(strict=True, max_length=150)] = Field(
        None,
        description="Timezone of the venue.  The name of the zone as defined by the IANA TZ database. https://en.wikipedia.org/wiki/List_of_tz_database_time_zones",
    )
    address: Optional[SeasonVenuesAddress] = None
    social: Optional[SocialMedia] = None
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    updated: Optional[datetime] = Field(None, description="Date/time last modified. In UTC")
    added: Optional[datetime] = Field(None, description="Date/time added. In UTC")
    __properties = [
        "seasonId",
        "season",
        "organizationId",
        "organization",
        "venueId",
        "siteId",
        "site",
        "abbreviationLocal",
        "nameLocal",
        "alternateNameLocal",
        "abbreviationLatin",
        "nameLatin",
        "alternateNameLatin",
        "countryCode",
        "timezone",
        "address",
        "social",
        "externalId",
        "updated",
        "added",
    ]

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonVenuesListModel:
        """Create an instance of SeasonVenuesListModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
                "updated",
                "added",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict["site"] = self.site.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict["address"] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social
        if self.social:
            _dict["social"] = self.social.to_dict()
        # set to None if site_id (nullable) is None
        if self.site_id is None:
            _dict["siteId"] = None

        # set to None if abbreviation_local (nullable) is None
        if self.abbreviation_local is None:
            _dict["abbreviationLocal"] = None

        # set to None if alternate_name_local (nullable) is None
        if self.alternate_name_local is None:
            _dict["alternateNameLocal"] = None

        # set to None if abbreviation_latin (nullable) is None
        if self.abbreviation_latin is None:
            _dict["abbreviationLatin"] = None

        # set to None if name_latin (nullable) is None
        if self.name_latin is None:
            _dict["nameLatin"] = None

        # set to None if alternate_name_latin (nullable) is None
        if self.alternate_name_latin is None:
            _dict["alternateNameLatin"] = None

        # set to None if country_code (nullable) is None
        if self.country_code is None:
            _dict["countryCode"] = None

        # set to None if address (nullable) is None
        if self.address is None:
            _dict["address"] = None

        # set to None if social (nullable) is None
        if self.social is None:
            _dict["social"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonVenuesListModel:
        """Create an instance of SeasonVenuesListModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonVenuesListModel.parse_obj(obj)

        _obj = SeasonVenuesListModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonVenuesListModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "venue_id": obj.get("venueId"),
                "site_id": obj.get("siteId"),
                "site": SeasonVenuesListModelSite.from_dict(obj.get("site")) if obj.get("site") is not None else None,
                "abbreviation_local": obj.get("abbreviationLocal"),
                "name_local": obj.get("nameLocal"),
                "alternate_name_local": obj.get("alternateNameLocal"),
                "abbreviation_latin": obj.get("abbreviationLatin"),
                "name_latin": obj.get("nameLatin"),
                "alternate_name_latin": obj.get("alternateNameLatin"),
                "country_code": obj.get("countryCode"),
                "timezone": obj.get("timezone"),
                "address": SeasonVenuesAddress.from_dict(obj.get("address"))
                if obj.get("address") is not None
                else None,
                "social": SocialMedia.from_dict(obj.get("social")) if obj.get("social") is not None else None,
                "external_id": obj.get("externalId"),
                "updated": obj.get("updated"),
                "added": obj.get("added"),
            }
        )
        return _obj
