# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr

from atriumsports.datacore.openapi.models.fixture_progressions_model_season import FixtureProgressionsModelSeason
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_pool import (
    SeasonFixtureStagesPoolsListModelPool,
)
from atriumsports.datacore.openapi.models.season_fixture_stages_pools_list_model_stage import (
    SeasonFixtureStagesPoolsListModelStage,
)
from atriumsports.datacore.openapi.models.season_standings_stages_pools_list_model_organization import (
    SeasonStandingsStagesPoolsListModelOrganization,
)


class SeasonStandingsStagesPoolsListModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    season: Optional[FixtureProgressionsModelSeason] = None
    organization_id: Optional[StrictStr] = Field(
        None, alias="organizationId", description="The unique identifier of the organization"
    )
    organization: Optional[SeasonStandingsStagesPoolsListModelOrganization] = None
    stage_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="stageCode", description="A unique code for the stage. (Unique for season)"
    )
    stage: Optional[SeasonFixtureStagesPoolsListModelStage] = None
    pool_code: Optional[constr(strict=True, max_length=30)] = Field(
        None, alias="poolCode", description="A unique code for the pool. (Unique for season)"
    )
    pool: Optional[SeasonFixtureStagesPoolsListModelPool] = None
    __properties = ["seasonId", "season", "organizationId", "organization", "stageCode", "stage", "poolCode", "pool"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonStandingsStagesPoolsListModel:
        """Create an instance of SeasonStandingsStagesPoolsListModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "organization_id",
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of season
        if self.season:
            _dict["season"] = self.season.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict["organization"] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stage
        if self.stage:
            _dict["stage"] = self.stage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict["pool"] = self.pool.to_dict()
        # set to None if stage_code (nullable) is None
        if self.stage_code is None:
            _dict["stageCode"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonStandingsStagesPoolsListModel:
        """Create an instance of SeasonStandingsStagesPoolsListModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonStandingsStagesPoolsListModel.parse_obj(obj)

        _obj = SeasonStandingsStagesPoolsListModel.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "season": FixtureProgressionsModelSeason.from_dict(obj.get("season"))
                if obj.get("season") is not None
                else None,
                "organization_id": obj.get("organizationId"),
                "organization": SeasonStandingsStagesPoolsListModelOrganization.from_dict(obj.get("organization"))
                if obj.get("organization") is not None
                else None,
                "stage_code": obj.get("stageCode"),
                "stage": SeasonFixtureStagesPoolsListModelStage.from_dict(obj.get("stage"))
                if obj.get("stage") is not None
                else None,
                "pool_code": obj.get("poolCode"),
                "pool": SeasonFixtureStagesPoolsListModelPool.from_dict(obj.get("pool"))
                if obj.get("pool") is not None
                else None,
            }
        )
        return _obj
