# coding: utf-8

"""
    DataCore API  - Sport

    For more details, see openapi/init.py

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, constr, validator


class SeasonRosterPostBody(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    season_id: Optional[StrictStr] = Field(None, alias="seasonId", description="The unique identifier of the season")
    entity_id: Optional[StrictStr] = Field(None, alias="entityId", description="The unique identifier of the entity")
    entity_group_id: Optional[StrictStr] = Field(
        None, alias="entityGroupId", description="The entity group that this entity belongs to"
    )
    division_id: Optional[StrictStr] = Field(
        None, alias="divisionId", description="The unique identifier of the division"
    )
    conference_id: Optional[StrictStr] = Field(
        None, alias="conferenceId", description="The unique identifier of the conference"
    )
    person_id: Optional[StrictStr] = Field(None, alias="personId", description="The unique identifier of the person")
    bib: Optional[constr(strict=True, max_length=100)] = Field(None, description="The number displayed on the jersey")
    position: Optional[constr(strict=True, max_length=100)] = Field(None, description="Playing position")
    status: constr(strict=True, max_length=100) = Field(
        ...,
        description="Participation status >- `ACTIVE` Active >- `INJURED` Injured >- `OTHER_NOT_PARTICIPATING` Other Non-Participation >- `OUT` Out >- `SUSPENDED` Suspended ",
    )
    external_id: Optional[constr(strict=True, max_length=150)] = Field(
        None, alias="externalId", description="The Id of the data as set by the provider of the data"
    )
    __properties = [
        "seasonId",
        "entityId",
        "entityGroupId",
        "divisionId",
        "conferenceId",
        "personId",
        "bib",
        "position",
        "status",
        "externalId",
    ]

    @validator("status")
    def status_validate_enum(cls, v):
        if v not in ("ACTIVE", "INJURED", "OUT", "SUSPENDED", "OTHER_NOT_PARTICIPATING"):
            raise ValueError(
                "must validate the enum values ('ACTIVE', 'INJURED', 'OUT', 'SUSPENDED', 'OTHER_NOT_PARTICIPATING')"
            )
        return v

    @validator("external_id")
    def external_id_validate_regular_expression(cls, v):
        if v is None:
            return v
        if not re.match(r"^[0-9A-Za-z\/_-]+$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-Za-z\/_-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SeasonRosterPostBody:
        """Create an instance of SeasonRosterPostBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # set to None if entity_group_id (nullable) is None
        if self.entity_group_id is None:
            _dict["entityGroupId"] = None

        # set to None if division_id (nullable) is None
        if self.division_id is None:
            _dict["divisionId"] = None

        # set to None if conference_id (nullable) is None
        if self.conference_id is None:
            _dict["conferenceId"] = None

        # set to None if bib (nullable) is None
        if self.bib is None:
            _dict["bib"] = None

        # set to None if position (nullable) is None
        if self.position is None:
            _dict["position"] = None

        # set to None if external_id (nullable) is None
        if self.external_id is None:
            _dict["externalId"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SeasonRosterPostBody:
        """Create an instance of SeasonRosterPostBody from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SeasonRosterPostBody.parse_obj(obj)

        _obj = SeasonRosterPostBody.parse_obj(
            {
                "season_id": obj.get("seasonId"),
                "entity_id": obj.get("entityId"),
                "entity_group_id": obj.get("entityGroupId"),
                "division_id": obj.get("divisionId"),
                "conference_id": obj.get("conferenceId"),
                "person_id": obj.get("personId"),
                "bib": obj.get("bib"),
                "position": obj.get("position"),
                "status": obj.get("status"),
                "external_id": obj.get("externalId"),
            }
        )
        return _obj
